<?php
namespace WglAddons\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use WglAddons\Includes\Wgl_Elementor_Helper;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Utils;


class Wgl_Header_Menu extends Widget_Base {

    public function get_name() {
        return 'wgl-menu';
    }

    public function get_title() {
        return esc_html__('WGL Menu', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-header-menu';
    }

    public function get_categories() {
        return [ 'wgl-header-modules' ];
    }

    public function get_script_depends() {
        return [
            'wgl-elementor-extensions-widgets',
        ];
    }


    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_general',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_control(
            'menu_choose',
            [
                'label' => esc_html__('Template', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default' => esc_html__('Default', 'atlets-core'),
                    'custom' => esc_html__('Custom Menu', 'atlets-core'),
                ],
                'default' => 'default',
            ]
        );

        $this->add_control(
            'custom_menu',
            [
                'label' => esc_html__('Custom Menu', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [ 'menu_choose' => 'custom' ],
                'options' => atlets_get_custom_menu(),
                'default' => 'Main',
            ]
        );

        $this->add_control(
            'lavalamp_active',
            [
                'label' => esc_html__('Lavalamp Marker', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'heading_width',
            [
                'label' => esc_html__('Width', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'display',
            [
                'label' => esc_html__('Display', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'inline-flex; width: auto' => esc_html__('Inline-Flex', 'atlets-core'),
                    'block' => esc_html__('Block', 'atlets-core'),
                ],
                'default' => 'inline-flex; width: auto',
                'selectors' => [
                    '{{WRAPPER}}' => 'display: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'flex_grow',
            [
                'label' => esc_html__('Flex Grow', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'display' => 'inline-flex; width: auto' ],
                'separator' => 'after',
                'min' => -1,
                'max' => 20,
                'default' => 1,
                'selectors' => [
                    '{{WRAPPER}}' => 'flex-grow: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_height',
            [
                'label' => esc_html__('Height', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'menu_height',
            [
                'label' => esc_html__( 'Widget Height (px)', 'atlets-core' ),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'default' => 100,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav' => 'height: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'menu_align_block',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [ 'display' => 'block' ],
                'separator' => 'before',
                'toggle' => false,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .primary-nav' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_align_flex',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [
                    'display' => [ 'inline-flex; width: auto', 'flex' ],
                ],
                'separator' => 'before',
                'toggle' => false,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}}' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> MENU
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_menu',
            [
                'label' => esc_html__('Menu', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'items',
                'selector' => '{{WRAPPER}} .primary-nav > div > ul, {{WRAPPER}} .primary-nav > ul',
            ]
        );

        $this->add_responsive_control(
            'menu_items_padding',
            [
                'label' => esc_html__('Items Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .primary-nav > ul' => 'margin-left: -{{LEFT}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_menu',
            [ 'separator' => 'before' ]
        );

        $this->start_controls_tab(
            'tab_menu_idle',
            [ 'label' => esc_html__('Idle' , 'atlets-core') ]
        );

        $this->add_control(
            'menu_text_idle',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_icon_idle',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li > a > span > .menu-item__plus' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_menu_hover',
            [ 'label' => esc_html__('Hover' , 'atlets-core') ]
        );

        $this->add_control(
            'menu_text_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
	            'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li:hover > a, {{WRAPPER}} .primary-nav > ul > li[class*="current"]:hover > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_icon_hover',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li:hover > a > span > .menu-item__plus,
                    {{WRAPPER}} .primary-nav > ul > li[class*="current"]:hover > a > span > .menu-item__plus' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_menu_active',
            [ 'label' => esc_html__('Active', 'atlets-core') ]
        );

        $this->add_control(
            'menu_text_active',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li.current-menu-item > a,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_item > a,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-parent > a,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_parent > a,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-ancestor > a,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_ancestor > a' => 'color: {{VALUE}}',

                ],
            ]
        );

        $this->add_control(
            'menu_line_active',
            [
                'label' => esc_html__('Line Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li.current-menu-item > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-item > a > span:before,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_item > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_item > a > span:before,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-parent > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-parent > a > span:before,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_parent > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_parent > a > span:before,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-ancestor > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current-menu-ancestor > a > span:before,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_ancestor > a > span:after,
                     {{WRAPPER}} .primary-nav > ul > li.current_page_ancestor > a > span:before' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_icon_active',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav > ul > li[class*="current"] > a > span > .menu-item__plus' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> SUBMENU
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_submenu',
            [
                'label' => esc_html__('Submenu', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submenu_typo',
                'selector' => '{{WRAPPER}} .primary-nav > div > ul ul, {{WRAPPER}} .primary-nav > ul ul',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'submenu_bg',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .primary-nav ul li ul',
            ]
        );

        $this->start_controls_tabs(
            'tabs_submenu',
            [ 'separator' => 'before' ]
        );

        $this->start_controls_tab(
            'tab_submenu_idle',
            [ 'label' => esc_html__('Idle' , 'atlets-core') ]
        );

        $this->add_control(
            'submenu_text_idle',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_line',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li:not([class*="current"]) > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li:not([class*="current"]) > a > span:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_icon_idle',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li > a > span + .menu-item__plus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_submenu_hover',
            [ 'label' => esc_html__('Hover' , 'atlets-core') ]
        );

        $this->add_control(
            'submenu_text_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
	            'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li:hover > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_line_hover',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li:hover > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li:hover > a > span:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_icon_hover',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li.menu-item:hover > a > span + .menu-item__plus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_submenu_active',
            [ 'label' => esc_html__('Active' , 'atlets-core') ]
        );

        $this->add_control(
            'submenu_text_active',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
	            'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li.current-menu-ancestor > a,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_ancestor > a,
                     {{WRAPPER}} .primary-nav ul li ul li.current-menu-item > a,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_item > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_line_active',
            [
                'label' => esc_html__('Line Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li.current-menu-ancestor > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li.current-menu-ancestor > a > span:after,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_ancestor > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_ancestor > a > span:after,
                     {{WRAPPER}} .primary-nav ul li ul li.current-menu-item > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li.current-menu-item > a > span:after,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_item > a > span:before,
                     {{WRAPPER}} .primary-nav ul li ul li.current_page_item > a > span:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_icon_active',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul li[class*="current"] > a > span + .menu-item__plus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'submenu_border',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .primary-nav ul li ul',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submenu_shadow',
                'selector' => '{{WRAPPER}} .primary-nav ul li ul',
            ]
        );

        $this->add_responsive_control(
            'submenu_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => [ 'px', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .primary-nav ul li ul' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
                    '{{WRAPPER}} .primary-nav ul li ul a' => 'padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> LAVALAMP
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_lavalamp',
            [
                'label' => esc_html__('Lavalamp', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'lavalamp_active!' => '' ],
            ]
        );

        $this->add_control(
            'lavalamp_color',
            [
                'label' => esc_html__('Lavalamp Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .lavalamp .lavalamp-object' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        extract($settings);

        $menu = '';

        if ($menu_choose === 'custom') {
            $menu = !empty($custom_menu) ? $custom_menu : '';
        }

        if (has_nav_menu('main_menu')) {
            echo "<nav class='primary-nav" . (!empty($lavalamp_active) ? ' menu_line_enable' : '') . "'>";
            atlets_main_menu($menu);
            echo '</nav>';

            echo '<div class="mobile-hamburger-toggle">',
                '<div class="hamburger-box">',
                '<div class="hamburger-inner">',
                '</div>',
                '</div>',
                '</div>';
        }
    }

}