<?php

namespace WglAddons\Widgets;

defined('ABSPATH') || exit; // Abort, If called directly.

use WglAddons\Includes\Wgl_Icons;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Utils;


class Wgl_Header_Search extends Widget_Base
{

    public function get_name()
    {
        return 'wgl-header-search';
    }

    public function get_title()
    {
        return esc_html__('WGL Search', 'atlets-core');
    }

    public function get_icon()
    {
        return 'wgl-header-search';
    }

    public function get_categories()
    {
        return ['wgl-header-modules'];
    }

    public function get_script_depends()
    {
        return [ 'wgl-elementor-extensions-widgets' ];
    }

    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $search_style = esc_attr(\Atlets_Theme_Helper::get_option('search_style'));

        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_general',
            ['label' => esc_html__('General', 'atlets-core')]
        );

        $this->add_control(
            'search_width',
            [
                'label' => esc_html__('Search Width', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search .wgl-search' => 'width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_control(
            'search_height',
            [
                'label' => esc_html__('Search Height', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search .wgl-search' => 'height: {{VALUE}}px;',
                ],
            ]
        );
        if($search_style === 'standard'){
            $this->add_control(
                'desc_offset',
                [
                    'label' => esc_html__('Description Offset', 'atlets-core'),
                    'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                    'selectors' => [
                        '{{WRAPPER}} .header_search.search_standard .header_search-field' => 'margin-top: {{VALUE}}px;',
                    ],
                ]
            );
        }

        $this->add_control(
            'search_alignment',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'label_block' => false,
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .wgl-search' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> SEARCH
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
	            'section_style_search',
            [
                'label' => esc_html__('Search', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => ['max' => 90],
                ],
                'selectors' => [
                    '{{WRAPPER}} .header_search-button' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'search_icon_tabs' );

        $this->start_controls_tab(
            'search_icon_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search-button-wrapper' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search-button-wrapper' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'search_icon_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search-button-wrapper:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .header_search-button-wrapper:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
		    'border_radius',
		    [
			    'label' => esc_html__('Border Radius', 'atlets-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%' ],
			    'default' => [
				    'top' => '3',
				    'right' => '3',
				    'bottom' => '3',
				    'left' => '3',
				    'unit' => 'px',
				    'isLinked' => false,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .header_search .wgl-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_control(
            'search_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .header_search .wgl-search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $description = esc_html__('Type To Search', 'atlets');
	    $search_style = \Atlets_Theme_Helper::get_option('search_style') ?? 'standard';
	    $search_counter = null;

	    if (class_exists('\Atlets_Theme_Helper')) {
		    $search_counter = \Atlets_Theme_Helper::$search_form_counter ?? null;
	    }

        $search_class = ' search_' . \Atlets_Theme_Helper::get_option('search_style');

	    $render_search = true;
	    if ($search_style === 'alt') {
		    $render_search = $search_counter > 0 ? false : true;

		    if (isset($search_counter)) \Atlets_Theme_Helper::$search_form_counter++;
	    }

        $this->add_render_attribute('search', 'class', ['wgl-search elementor-search header_search-button-wrapper']);
        $this->add_render_attribute('search', 'role', 'button');

        echo '<div class="header_search' . esc_attr($search_class) . '">';

        echo '<div ', $this->get_render_attribute_string('search'), '>',
            '<div class="header_search-button flaticon-find"></div>',
            '<div class="header_search-close"></div>',
            '</div>';

	    if ($render_search) {
		    echo '<div class="header_search-field">';
		    if ( $search_style === 'alt' ) {
			    echo '<div class="header_search-wrap">',
			    '<div class="atlets_module_double_headings aleft">',
			    '<h3 class="header_search-heading_description heading_title">',
			    apply_filters( 'atlets_desc_search', $description ),
			    '</h3>',
			    '</div>',
			    '<div class="header_search-close"></div>',
			    '</div>';
		    }
		    echo get_search_form( false );
		    echo '</div>';
	    }

        echo '</div>';
    }
}
