<?php
namespace WglAddons\Widgets;

use WglAddons\Includes\Wgl_Icons;
use WglAddons\Includes\Wgl_Carousel_Settings;
use WglAddons\Includes\Wgl_Elementor_Helper;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;
use Elementor\Plugin;


defined('ABSPATH') || exit; // Abort, If called directly.

class Wgl_Header_Wpml extends Widget_Base {

    public function get_name() {
        return 'wgl-header-wpml';
    }

    public function get_title() {
        return esc_html__('WPML Selector', 'atlets-core' );
    }

    public function get_icon() {
        return 'wgl-header-wpml';
    }

    public function get_categories() {
        return [ 'wgl-header-modules' ];
    }

    public function get_script_depends() {
        return [
            'perfect-scrollbar',
            'wgl-elementor-extensions-widgets',
        ];
    }

    protected function register_controls() {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);

        $this->start_controls_section(
            'section_navigation_settings',
            [
                'label' => esc_html__( 'WPML Settings', 'atlets-core' ),
            ]
        );

        $this->add_control(
            'wpml_height',
            array(
                'label' => esc_html__( 'WPML Height', 'atlets-core' ),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'min' => 0,
                'step' => 1,
                'default' => 100,
                'description' => esc_html__( 'Enter value in pixels', 'atlets-core' ),
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .sitepress_container' => 'height: {{VALUE}}px;',
                ],
            )
        );

        $this->add_control(
            'wpml_align',
            array(
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'label_block' => false,
                'default' => 'left',
                'toggle' => true,
                'prefix_class' => 'wpml_align_',
                'selectors' => [
                    '{{WRAPPER}} .sitepress_container' => 'text-align: {{VALUE}};',
                ],
            )
        );

	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name' => 'wpml_typo',
			    'selector' => '{{WRAPPER}} .wpml-ls-legacy-dropdown',
			    'fields_options' => [
				    'typography' => [ 'default' => 'custom' ],
				    'font_size' => [
					    'default' => [ 'size' => 14, 'unit' => 'px' ]
				    ],
				    'font_weight' => [
					    'default' => 800
				    ]
			    ],
		    ]
	    );

        $this->end_controls_section();
    }

    public function render(){
        if (class_exists('\SitePress')) {
            ob_start();
                do_action('wpml_add_language_selector');
            $wpml_render = ob_get_clean();

            if(!empty($wpml_render)){
                echo "<div class='sitepress_container'>";
                    do_action('wpml_add_language_selector');
                echo "</div>";
            }

        }
    }
}