<?php

namespace WglAddons\Includes;

defined('ABSPATH') || exit;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;


/**
* Wgl Elementor Icons Settings
*
*
* @class Wgl_Icons
* @version 1.0
* @category Class
* @author WebGeniusLab
*/

if (! class_exists('Wgl_Icons')) {

    class Wgl_Icons
    {
        private static $instance = null;

        public static function get_instance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        public function build($self, $atts, $pref)
        {
            $icon_builder = new Wgl_Icon_Builder();
            return $icon_builder->build( $self, $atts, $pref );
        }

        public static function init($self, $array = [])
        {
            if (! $self) return;

            $label = $array['label'] ?? '';
            $prefix = $array['prefix'] ?? '';
            $condition = $array['condition'] ?? [];

            $default_media_type = $array['default']['media_type'] ?? '';
            $default_icon = $array['default']['icon'] ?? [];
            $extra_media_type = $array['default']['extra_media_type'] ?? false;

            if (isset($array['section']) && $array['section']) {
                $self->start_controls_section(
                    $prefix.'add_icon_image_section',
                    [
                        'label' => sprintf( esc_html__('%s Icon/Image', 'atlets-core'), $label ),
                    ]
                );
            }

            $media_types_options = [
                '' => [
                    'title' => esc_html__( 'None', 'atlets-core' ),
                    'icon' => 'fa fa-ban',
                ],
                'font' => [
                    'title' => esc_html__( 'Icon', 'atlets-core' ),
                    'icon' => 'far fa-smile',
                ],
                'image' => [
                    'title' => esc_html__( 'Image', 'atlets-core' ),
                    'icon' => 'fa fa-image',
                ],
            ];

            if ( $extra_media_type ) {
                $media_types_options[ 'morph' ] = [
                    'title' => esc_html__( 'Morph', 'atlets-core' ),
                    'icon' => 'fa fa-superpowers',
                ];
            }

            $self->add_control(
                $prefix.'icon_type',
                [
                    'label' => esc_html__('Media Type', 'atlets-core'),
                    'type' => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'label_block' => false,
                    'options' => $media_types_options,
                    'default' => $default_media_type,
                    'condition' => $condition,
                ]
            );

            $self->add_control(
                $prefix.'media_test',
                [
                    'type' => Controls_Manager::HIDDEN,
                    'default' => 'test',
                ]
            );

            $self->add_control(
                $prefix.'media_type_class',
                [
                    'type' => Controls_Manager::HIDDEN,
                    'condition' => [ $prefix.'icon_type' => 'morph' ],
                    'default' => 'morph',
                    'prefix_class' => 'has-',
                ]
            );

            $self->add_control(
                $prefix.'icon_fontawesome',
                [
                    'label' => esc_html__('Icon', 'atlets-core'),
                    'type' => Controls_Manager::ICONS,
                    'condition' => array_merge([ $prefix.'icon_type' => 'font' ], $condition),
                    'label_block' => true,
                    'default' => $default_icon,
                ]
            );

            $self->add_control(
                $prefix.'icon_render_class',
                [
                    'label' => esc_html__('Icon Class', 'atlets-core'),
                    'type' => Controls_Manager::HIDDEN,
                    'condition' => array_merge([ $prefix.'icon_type' => 'font' ], $condition),
                    'prefix_class' => 'elementor-widget-icon-box ',
                    'default' => 'wgl-icon-box',
                ]
            );

            $self->add_control(
                $prefix.'thumbnail',
                [
                    'label' => esc_html__('Image', 'atlets-core'),
                    'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
                    'condition' => array_merge([ $prefix.'icon_type' => 'image' ], $condition),
                    'label_block' => true,
                    'default' => [ 'url' => Utils::get_placeholder_image_src() ],
                ]
            );

            if (isset($array['secondary_image']) && $array['secondary_image']) {
                $self->add_control(
                    $prefix . 'thumbnail_2',
                    [
                        'label' => esc_html__('Animated Image', 'atlets-core'),
                        'description' => esc_html__('Add a second image to enable animation', 'atlets-core'),
                        'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
                        'condition' => array_merge(
                            [
                                $prefix . 'icon_type' => 'image',
                                $prefix . 'thumbnail!' => ['url' => '', 'id' => '']
                            ],
                            $condition),
                        'label_block' => true,
                        'default' => ['url' => Utils::get_placeholder_image_src()],
                    ]
                );
            }

            $self->add_control(
                $prefix.'image_render_class',
                [
                    'label' => esc_html__('Image Class', 'atlets-core'),
                    'type' => Controls_Manager::HIDDEN,
                    'condition' => array_merge([ $prefix.'icon_type' => 'image' ], $condition),
                    'default' => 'wgl-image-box',
                    'prefix_class' => 'elementor-widget-image-box ',
                ]
            );

            $self->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => $prefix.'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                    'default' => 'full',
                    'separator' => 'none',
                    'condition' => array_merge([ $prefix.'icon_type' => 'image' ], $condition),
                ]
            );

            if (isset($array['output']) && !empty($array['output'])){
                foreach ($array['output'] as $key => $value) {
                    $self->add_control(
                        $key,
                        $value
                    );
                }
            }

            if (isset($array['section']) && $array['section']) {
                $self->end_controls_section();
            }
        }

    }
    new Wgl_Icons();
}

/**
* Wgl Icon Build
*
*
* @class Wgl_Icon_Builder
* @version 1.0
* @category Class
* @author WebGeniusLab
*/
if (!class_exists('Wgl_Icon_Builder')) {

    class Wgl_Icon_Builder
    {
        private static $instance = null;
        public static function get_instance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }


        public function build($self, $atts, $pref)
        {
            $prefix = $output = '';
            $icon_tag = 'span';

            if (isset($pref) && !empty($pref)) {
                $prefix = $pref;
            }

            $media_type = $atts[$prefix.'icon_type'] ?? '';
            $icon_fontawesome = $atts[$prefix.'icon_fontawesome'] ?? '';
            $thumbnail = $atts[$prefix.'thumbnail'] ?? '';
            $thumbnail_2 = isset($atts['secondary_image']) && !!$atts['secondary_image'] && $atts[$prefix.'thumbnail_2'] ?? '';
            $morph_text = $atts['morph_text'] ?? '';

            $self->add_render_attribute($prefix.'icon', 'class', 'wgl-icon');
            if (isset($atts['hover_animation_icon']) && !empty($atts['hover_animation_icon'])) {
                $self->add_render_attribute($prefix.'icon', 'class', 'elementor-animation-' . $atts['hover_animation_icon']);
            }

            // Wrapper Class
            $wrapper_class = $atts['wrapper_class'] ?? '';
            if ($media_type === 'image') $wrapper_class .= 'img-wrapper';
            if ($media_type === 'font') $wrapper_class .= 'icon-wrapper';
            if ($media_type === 'morph') $wrapper_class .= 'morph-wrapper';
            $self->add_render_attribute($prefix.'wrapper-icon', 'class', [
                'media-wrapper',
                $wrapper_class
            ]);

            if (!empty($atts['link_t']['url'])) {
                $icon_tag = 'a';
                $self->add_link_attributes($prefix.'link_t', $atts['link_t']);
            }

            $icon_attributes = $self->get_render_attribute_string($prefix.'icon');
            $link_attributes = $self->get_render_attribute_string($prefix.'link_t');


            if ($media_type === 'font' && !empty($icon_fontawesome)
                || $media_type === 'image' && !empty($thumbnail)
                || $media_type === 'morph' && $morph_text
           ) {
                $output .= '<div ' . $self->get_render_attribute_string($prefix.'wrapper-icon') . '>';

                    if ($media_type == 'font' && !empty($icon_fontawesome['value'])) {
                        $output .= '<';
                            $output .= implode(' ', [$icon_tag, $icon_attributes, $link_attributes]);
                        $output .= '>';

                        if('svg' === $icon_fontawesome['library']){
                            $output .= '<span class="icon elementor-icon">';
                        }

                        // * Icon migration
                        $migrated = isset($atts['__fa4_migrated'][$prefix.'icon_fontawesome']);
                        $is_new = Icons_Manager::is_migration_allowed();
                        if ($is_new || $migrated) {
                            ob_start();
                            Icons_Manager::render_icon($icon_fontawesome, ['class' => 'icon elementor-icon', 'aria-hidden' => 'true']);
                            $output .= ob_get_clean();
                        } else {
                            $output .= '<i class="icon '.esc_attr($icon_fontawesome['value']).'"></i>';
                        }

                        if('svg' === $icon_fontawesome['library']){
                            $output .= '</span>';
                        }

                        $output .= '</'.$icon_tag.'>';
                    }
                    if ($media_type === 'image' && !empty($thumbnail['url'])) {

                        $self->add_render_attribute(
                            'thumbnail',
                            [
                                'src' => $thumbnail['url'],
                                'alt' => Control_Media::get_image_alt($thumbnail),
                                'title' => Control_Media::get_image_title($thumbnail),
                            ]
                        );
                        if (!empty($thumbnail_2['url'])) {
	                        $self->add_render_attribute(
		                        'thumbnail_2',
		                        [
			                        'src'   => $thumbnail_2['url'],
			                        'alt'   => Control_Media::get_image_alt( $thumbnail_2 ),
			                        'title' => Control_Media::get_image_title( $thumbnail_2 ),
		                        ]
	                        );
                        }

                        if (isset($atts['hover_animation_image'])) {
                            $atts['hover_animation'] = $atts['hover_animation_image'];
                        }

                        $output .= '<figure class="wgl-image-box_img">';

                        $output .= '<' . $icon_tag . ' ' . $link_attributes . '>';
                            $output .= Group_Control_Image_Size::get_attachment_image_html($atts, 'thumbnail', $prefix.'thumbnail');
                        $output .= '</'.$icon_tag.'>';

                        if (!empty($thumbnail_2['url'])) {
	                        $output .= '<' . $icon_tag . ' ' . $link_attributes . '>';
	                        $output .= Group_Control_Image_Size::get_attachment_image_html( $atts, 'thumbnail', $prefix . 'thumbnail_2' );
	                        $output .= '</' . $icon_tag . '>';
                        }

                        $output .= '</figure>';

                    }
                    if ($media_type == 'morph' && $morph_text) {
                        $output .= '<span class="morph_text">';
                        $output .= $morph_text;
                        $output .= '</span>';
                    }

                $output .= '</div>';
            }

            return $output;
        }
    }
}
