<?php

namespace WglAddons\Includes;

use Elementor\Plugin;

defined('ABSPATH') || exit;

/**
* Wgl Elementor Helper Settings
*
*
* @class Wgl_Elementor_Helper
* @version 1.0
* @category Class
* @author WebGeniusLab
*/

if (!class_exists('Wgl_Elementor_Helper')) {

    class Wgl_Elementor_Helper
    {

        private static $instance = null;
        public static function get_instance() {

            if ( null == self::$instance ) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        public function get_wgl_icons() {
            return [
                'arrow-right',
                'search',
                'menu',
                'supermarket',
                'arrow',
                'wind-turbine',
                'phone',
                'phone-1',
                'correct',
                'download',
                'wind',
                'power',
                'ecology',
                'ecology-1',
                'plant',
                'paper-recycle',
                'earth',
                'trees',
                'heart',
                'eco-home',
                'eco-bag',
                'water',
                'landscape',
                'play',
                'plus',
                'power-1',
                'mill',
                'down',
                'chevron',
                'telegram',
                'yard',
                'user',
                'comment',
                'chat',
                'pin',
                'at',
                'envelope',
                'black-back-closed-envelope-shape',
                'share',
                'quotation-marks',
                'quote',
                'left-quote',
                'chain',
                'link',
                'files-and-folders',
                'files-and-folders-1',
                'pencil-edit-button',
                'hashtag',
                'photograph',
                'heart-1',
                'heart-2',
                'greenhouse',
                'nuclear',
                'ecology-2',
                'green',
                'settings',
                '24-hours',
                'chat-1',
                'leaf',
                'pot',
                'light-bulb',
                'price',
                'coin',
                'wallet',
                'thumb-up-button',
                'shopping-cart',
                'shopping-bag',
                'shopping-basket-button',
                'shopping-bag-1',
                'linkedin-letters',
                'search-1',
                'map',
                'surf',
                'shopper',
                'wave',
                'surfboard',
                'van',
                'windsurf',
                'help',
                'surf-1',
                'surf-2',
                'plus-1',
                'plus-2',
                'share-1',
                'find',
                'bag',
                'bag-1',
                'anchor',
                'snorkel',
                'animal',
                'phone-2',
                'alpine',
                'player',
                'skates',
                'snowboarding',
                'biathlonist',
                'boot',
                'snowboarder',
                'skis',
                'snowboarding-1',
                'helmet',
                'lift',
                'hat',
                'people',
                'slope',
                'ski',
                'riding',
                'skiing',
                'slope-1',
                'guarding',
                'snowboard',
                'house',
                'bike',
                'helmet-1',
                'eye-glasses',
                'bike-1',
                'clutch',
                'tricycle',
                'cycling',
                'wrench',
                'water-1',
                'checkmark',
                'bike-2',
                'bike-3',
                'chain-1',
                'stopwatch',
                'bike-4',
                'pump',
                'quote-left',
                'user-1',
                'link-1',
                'close-button',
                'round-information-button',
                'round-help-button',
                'round-done-button',
                'round-delete-button',
                'circle',
                'surfboard-1',
                'surfboard-2',
                'kayak',
                'palm',
                'sunrise',
                'boat',
                'wave-1',
                'beach-ball',
                'diving-mask',
                'jet-ski',
                'lifebuoy',
                'starfish',
                'anchor-1',
                'thermometer',
                'home',
                'padlock',
                'user-shape',
                'settings-1',
                'comment-black-oval-bubble-shape',
                'eye-open',
                'refresh',
                'globe',
                'cog',
                'tag',
                'pencil',
                'bookmark',
                'folder',
            ];
        }

        public static function enqueue_css($style) {
            if (! (bool) Plugin::$instance->editor->is_edit_mode()) {
                if (! empty($style)) {
                    ob_start();
                        echo $style;
                    $css = ob_get_clean();
                    $css = apply_filters('atlets/enqueue_shortcode_css', $css, $style );

                    return $css;
                }
            } else {
                echo '<style>'.esc_attr($style).'</style>';
            }
        }

        public function get_elementor_templates() {

            $options = [];

            $_templates = get_posts( array(
                'post_type' => 'elementor_library',
                'posts_per_page' => -1,
            ));

            if ( ! empty( $_templates ) && ! is_wp_error( $_templates ) ) {

                foreach ( $_templates as $_template ) {
                    $options[ $_template->ID ] = $_template->post_title;
                }

                update_option( 'temp_count', $options );

                return $options;
            }
        }

        /**
         * Retrieve the name of the highest priority template file that exists.
         *
         * @param string|array $template_names Template file(s) to search for, in order.
         * @param string       $origin_path    Template file(s) origin path. (../atlets-core/includes/elementor)
         * @param string       $override_path  New template file(s) override path. (../atlets)
         *
         * @return string The template filename if one is located.
         */
        public static function get_locate_template(
            $template_names,
            $origin_path,
            $override_path
        ) {
            $files = [];
            $file = '';
            foreach ((array)$template_names as $template_name) {
                if (file_exists(get_stylesheet_directory() . $override_path . $template_name)) {
                    $file = get_stylesheet_directory() . $override_path . $template_name;
                } elseif (file_exists(get_template_directory() . $override_path . $template_name)) {
                    $file = get_template_directory() . $override_path . $template_name;
                } elseif (file_exists(realpath(__DIR__ . '/..') . $origin_path . $template_name)) {
                    $file = realpath(__DIR__ . '/..') . $origin_path . $template_name;
                }
                array_push($files, $file);
            }
            return $files;
        }

        /**
         * Retrieve image dimensions based on passed arguments.
         *
         * @param array|string $desired_dimensions  Required. Desired dimensions. Ex: `700x300`, `[700, 300]`, `['width' => 700, 'height' => 300]`
         * @param string       $aspect_ratio        Required. Desired ratio. Ex: `16:9`
         * @param array        $img_data            Optional. Result of `wp_get_attachment_image_src` function.
         */
        public static function get_image_dimensions(
            $desired_dimensions,
            String $aspect_ratio,
            Array $img_data = []
        ) {
            if ($aspect_ratio) {
                $ratio_arr = explode(':', $aspect_ratio);
                $ratio = round($ratio_arr[0] / $ratio_arr[1], 4);
            }

            if ('full' === $desired_dimensions) {
                $attachemnt_data = $img_data ?: wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');

                if (!$attachemnt_data) {
                    // Bailout, if no featured image
                    return;
                }

                return [
                    'width' => $attachemnt_data[1],
                    'height' => isset($ratio) ? round((int) $attachemnt_data[1] / $ratio) : $attachemnt_data[2]
                ];
            }

            if (is_array($desired_dimensions)) {
                $desired_width = $desired_dimensions['width'];
                $desired_height = $desired_dimensions['height'];
            } else {
                $dims = explode('x', $desired_dimensions);
                $desired_width = $dims[0];
                $desired_height = !empty($dims[1]) ? $dims[1] : $dims[0];
            }

            return [
                'width' => (int) $desired_width,
                'height' => isset($ratio) ? round($desired_width / $ratio) : (int) $desired_height
            ];
        }
    }
    new Wgl_Elementor_Helper;
}
?>