<?php

namespace WglAddons\Modules;

use WglAddons\Includes\Wgl_Elementor_Helper;

defined('ABSPATH') || exit;

/**
 * Wgl Elementor Custom Icon Control
 *
 *
 * @class Wgl_Icons_Library
 * @version 1.0
 * @category Class
 * @author WebGeniusLab
 */

class Wgl_Icons_Library
{
    public function __construct()
    {
        add_filter('elementor/icons_manager/additional_tabs', [$this, 'extended_icons_library']);
    }

    public function extended_icons_library()
    {
        global $wp_version;

        return [
            'wgl_icons' => [
                'name' => 'wgl_icons',
                'label' => esc_html__('WGL Icons Library', 'atlets-core'),
                'prefix' => 'flaticon-',
                'displayPrefix' => 'flaticon',
                'labelIcon' => 'flaticon',
                'icons' => Wgl_Elementor_Helper::get_instance()->get_wgl_icons(),
                'native' => true,
            ]
        ];
    }
}
