<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/templates/wgl-team.php.
*/
namespace WglAddons\Templates;

defined('ABSPATH') || exit; // Abort, if called directly.

use Elementor\Plugin;
use Elementor\Frontend;
use WglAddons\Includes\Wgl_Loop_Settings;
use WglAddons\Includes\Wgl_Carousel_Settings;

/**
* WGL Elementor Team Template
*
*
* @class WglTeam
* @version 1.0
* @category Class
* @author WebGeniusLab
*/

class WglTeam
{
    private static $instance = null;

    public static function get_instance()
    {
        if (null == self::$instance) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function render($atts, $content = null)
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);

        extract($atts);

        if ($use_carousel) {
            $carousel_options = [
                'slide_to_show' => $posts_per_line,
                'autoplay' => $autoplay,
                'autoplay_speed' => $autoplay_speed,
                'use_pagination' => $use_pagination,
                'pag_type' => $pag_type,
                'pag_offset' => $pag_offset,
                'custom_pag_color' => $custom_pag_color,
                'pag_color' => $pag_color,
                'use_prev_next' => $use_prev_next,

                'prev_next_position' => $prev_next_position,
                'custom_prev_next_color' => $custom_prev_next_color,
                'prev_next_color' => $prev_next_color,
                'prev_next_color_hover' => $prev_next_color_hover,
                'prev_next_bg_idle' => $prev_next_bg_idle,
                'prev_next_bg_hover' => $prev_next_bg_hover,

                'custom_resp' => $custom_resp,
                'resp_medium' => $resp_medium,
                'resp_medium_slides' => $resp_medium_slides,
                'resp_tablets' => $resp_tablets,
                'resp_tablets_slides' => $resp_tablets_slides,
                'resp_mobile' => $resp_mobile,
                'resp_mobile_slides' => $resp_mobile_slides,
                'infinite' => $infinite,
                'slides_to_scroll' => $slides_to_scroll,
                'center_mode' => $center_mode,
            ];

            wp_enqueue_script('slick', get_template_directory_uri() . '/js/slick.min.js', [], false, false);
        }

        $wrapper_classes = 'team-col_'.$posts_per_line;
        $wrapper_classes .= ' a'.$info_align;

        ob_start();
            $this->render_wgl_team($atts);
        $team_items = ob_get_clean();

        ob_start();
        ?>
        <div class="wgl_module_team <?php echo esc_attr($wrapper_classes); ?>">
            <div class="team-items_wrap">
                <?php
                switch ($use_carousel) {
                    case true:
                        echo Wgl_Carousel_Settings::init($carousel_options, $team_items, false);
                        break;
                    default:
                        echo \Atlets_Theme_Helper::render_html($team_items);
                        break;
                }
                ?>
            </div>
        </div>
        <?php

        return ob_get_clean();
    }


    public function render_wgl_team($atts)
    {
        extract($atts);

        $compile = '';

        // Dimensions for team images
        switch ($posts_per_line) {
            default:
            case '1':
            case '2': $team_image_dims = ['width' => '970', 'height' => '1164']; break;
            case '3': $team_image_dims = ['width' => '600', 'height' => '720'];  break;
            case '4':
            case '5':
            case '6': $team_image_dims = ['width' => '400', 'height' => '480'];  break;
        }

        list($query_args) = Wgl_Loop_Settings::buildQuery($atts);
        $query_args['post_type'] = 'team';
        $wgl_posts = new \WP_Query($query_args);

        while ($wgl_posts->have_posts()) {
            $wgl_posts -> the_post();
            $compile .= $this->render_wgl_team_item(false, $atts, $team_image_dims);
        }
        wp_reset_postdata();

        echo $compile;
    }


    public function render_wgl_team_item($single_member, $item_atts, $team_image_dims)
    {
        extract($item_atts);

        $info_array = $info_bg_url = null;
        $t_info = $t_icons = $featured_image = $title = $watermark_title = $icons_wrap = '';

        $id = get_the_ID();
        $post = get_post($id);
        $permalink = esc_url(get_permalink($id));
        $department = get_post_meta($id, 'department', true);
        $watermark_team = get_post_meta($id, 'watermark_team', true);
        $social_array = get_post_meta($id, 'soc_icon', true);
        $wp_get_attachment_url = wp_get_attachment_url(get_post_thumbnail_id($id));
        if ($single_member) {
            $info_array = get_post_meta($id, 'info_items', true);
            $info_bg_id = get_post_meta($id, 'mb_info_bg', true);
            $info_bg_url = wp_get_attachment_url($info_bg_id);
        }

        // Info
        if ($info_array) {
            for ($i = 0, $count = count($info_array); $i < $count; $i++) {
                $info = $info_array[$i];
                $info_name = ! empty($info['name']) ? $info['name'] : '';
                $info_description = ! empty($info['description']) ? $info['description'] : '';
                $info_link = ! empty($info['link']) ? $info['link'] : '';

                if ($single_member && (! empty($info_name) || ! empty($info_description))) {
                    $t_info .= '<div class="team-info_item">';
                        $t_info .= ! empty($info_name) ? '<h5>' . esc_html($info_name) . '</h5>' : '';
                        $t_info .= ! empty($info_link) ? '<a href="'.esc_url($info_link).'">' : '';
                            $t_info .= '<span>' . esc_html($info_description) . '</span>';
                        $t_info .= ! empty($info_link) ? '</a>' : '';
                    $t_info .= '</div>';
                }
            }
        }

        // Social icons
        if (!$hide_soc_icons && $social_array) {
            for ($i = 0, $count = count($social_array); $i < $count; $i++) {
                $icon = $social_array[$i];
                $icon_name = $icon['select'] ?: '';
                $icon_link = $icon['link'] ?: '#';
                if ($icon['select']) {
                    $t_icons .= '<a href="' . $icon_link . '" class="team-icon ' . $icon_name . '"></a>';
                }
            }
            if ($t_icons) {
	            $icons_wrap  = '<div class="team__icons icons_count-'.$count.'">';
                    $icons_wrap .= '<span class="team-icon flaticon flaticon-share-1"></span>';
                    $icons_wrap .= $t_icons;
                $icons_wrap .= '</div>';
            }
        }

        // Featured Image
        if ($wp_get_attachment_url) {
            $img_url = aq_resize($wp_get_attachment_url, $team_image_dims['width'], $team_image_dims['height'], true, true, true);
            $img_alt = get_post_meta(get_post_thumbnail_id($id), '_wp_attachment_image_alt', true);

            $featured_image = sprintf('<%s class="team__image"><img src="%s" alt="%s" /></%s>',
                $single_link_wrapper && ! $single_member ? 'a href="'.$permalink.'"' : 'div',
                esc_url($img_url),
                $img_alt ?: '',
                $single_link_wrapper && ! $single_member ? 'a' : 'div'
            );
        }

        // Title
	    $title_def = get_the_title();
        if (! $hide_title) {
            $title .= '<h2 class="team-title">';
                $title .= $single_link_heading && ! $single_member ? '<a href="'.$permalink.'">' : '';
                    $title .= $title_def;
                $title .= $single_link_heading && ! $single_member ? '</a>' : '';
            $title .= '</h2>';
        }

        // Watermark Title
        if (! $hide_watermark) {
            $watermark_title .= '<span class="team-watermark">';
	            $watermark_title .= $title_def;
	        $watermark_title .= '</span>';
        }

        // Excerpt
        if (! $single_member && ! $hide_content) {
            $excerpt = $post->post_excerpt ?: $post->post_content;
            $excerpt = preg_replace( '~\[[^\]]+\]~', '', $excerpt);
            $excerpt = strip_tags($excerpt);
            $excerpt = \Atlets_Theme_Helper::modifier_character($excerpt, $letter_count, "");
        }

        // Render grid & single
        if (!$single_member) :

            echo '<div class="team-item">';
                echo '<div class="team-item_wrap">';

                if ($featured_image) {
                    echo '<div class="team__media-wrapper">',
                        '<div class="team__image-wrapper">',
                            $icons_wrap,
                            $featured_image,
                        '</div>',
                    '</div>';
                }

                if (!$featured_image && !$hide_soc_icons) echo $icons_wrap;


                if (!$hide_content || !$hide_title || !$hide_meta) {
                    echo '<div class="team-item_info">';
                        if (!$hide_meta && $department) {
                            echo '<div class="team-department">',
                            esc_html($department),
                            '</div>';
                        }
                        echo $title;
                    echo '</div>'; // item_info
                }

                if (! $hide_watermark) {
                    echo $watermark_title;
                }

                if (!$hide_content && $excerpt) {
                    echo '<div class="team-item_excerpt">',
                        $excerpt,
                    '</div>';
                }

	            echo '</div>'; // item_wrap
            echo '</div>';

        else :
            echo '<div class="team-single_wrapper"', ($info_bg_url ? ' style="background-image: url('.esc_url($info_bg_url).')"' : ''), '>';
                if ($featured_image) {
                    echo '<div class="team-image_wrap">',
                        $featured_image,
                        $watermark_team ? '<div class="watermark_team"><span>'.esc_html($watermark_team).'</span></div>' : '',
                    '</div>';
                }
                echo '<div class="team-info_wrapper">',
                    $title,
                    $department ? '<div class="team-info_item highlighted"><span>'.esc_html($department).'</span></div>' : '',
                    $t_info,
                    $icons_wrap,
                '</div>';
            echo '</div>';

        endif;

    }
}