<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-countdown.php.
*/
namespace WglAddons\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use WglAddons\Templates\WglCountDown;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Typography;


class Wgl_CountDown extends Widget_Base
{

    public function get_name()
    {
        return 'wgl-countdown';
    }

    public function get_title()
    {
        return esc_html__('WGL Countdown Timer', 'atlets-core');
    }

    public function get_icon()
    {
        return 'wgl-countdown';
    }

    public function get_categories()
    {
        return ['wgl-extensions'];
    }

    public function get_script_depends()
    {
        return [
            'jquery-countdown',
            'wgl-elementor-extensions-widgets',
        ];
    }


	protected function register_controls() {
		$primary_color     = esc_attr( \Atlets_Theme_Helper::get_option( 'theme-primary-color' ) );
		$header_font_color = esc_attr( \Atlets_Theme_Helper::get_option( 'header-font' )['color'] );
		$main_font_color   = esc_attr( \Atlets_Theme_Helper::get_option( 'main-font' )['color'] );

		/* Start General Settings Section */
		$this->start_controls_section( 'wgl_countdown_section',
			array(
				'label' => esc_html__( 'Countdown Timer Settings', 'atlets-core' ),
			)
		);

		$this->add_control( 'countdown_year',
			array(
				'label'       => esc_html__( 'Year', 'atlets-core' ),
				'type'        => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
				'placeholder' => esc_html__( 'Enter your title', 'atlets-core' ),
				'default'     => esc_html__( '2020', 'atlets-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Example: 2020', 'atlets-core' ),
			)
		);

		$this->add_control( 'countdown_month',
			array(
				'label'       => esc_html__( 'Month', 'atlets-core' ),
				'type'        => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
				'placeholder' => esc_html__( '12', 'atlets-core' ),
				'default'     => esc_html__( '12', 'atlets-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Example: 12', 'atlets-core' ),
			)
		);

		$this->add_control( 'countdown_day',
			array(
				'label'       => esc_html__( 'Day', 'atlets-core' ),
				'type'        => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
				'placeholder' => esc_html__( '31', 'atlets-core' ),
				'default'     => esc_html__( '31', 'atlets-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Example: 31', 'atlets-core' ),
			)
		);

		$this->add_control( 'countdown_hours',
			array(
				'label'       => esc_html__( 'Hours', 'atlets-core' ),
				'type'        => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
				'placeholder' => esc_html__( '24', 'atlets-core' ),
				'default'     => esc_html__( '24', 'atlets-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Example: 24', 'atlets-core' ),
			)
		);

		$this->add_control( 'countdown_min',
			array(
				'label'       => esc_html__( 'Minutes', 'atlets-core' ),
				'type'        => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
				'placeholder' => esc_html__( '59', 'atlets-core' ),
				'default'     => esc_html__( '59', 'atlets-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Example: 59', 'atlets-core' ),
			)
		);

		/*End General Settings Section*/
		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  Button Section
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section( 'wgl_countdown_content_section',
			array(
				'label' => esc_html__( 'Countdown Timer Content', 'atlets-core' ),
			)
		);

		$this->add_control( 'hide_day',
			array(
				'label'        => esc_html__( 'Hide Days?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control( 'hide_hours',
			array(
				'label'        => esc_html__( 'Hide Hours?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control( 'hide_minutes',
			array(
				'label'        => esc_html__( 'Hide Minutes?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control( 'hide_seconds',
			array(
				'label'        => esc_html__( 'Hide Seconds?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control( 'show_value_names',
			array(
				'label'        => esc_html__( 'Show Value Names?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'prefix_class' => 'show_value_names-',
			)
		);

		$this->add_control( 'show_separating',
			array(
				'label'        => esc_html__( 'Show Separating?', 'atlets-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'atlets-core' ),
				'label_off'    => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'prefix_class' => 'show_separating-',
			)
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'atlets-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'atlets-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlets-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'atlets-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default' => 'center',
			]
		);

		/*End General Settings Section*/
		$this->end_controls_section();

		$this->start_controls_section(
			'countdown_style_section',
			array(
				'label' => esc_html__( 'Style', 'atlets-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control( 'size',
			array(
				'label'   => esc_html__( 'Countdown Size', 'atlets-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'large'  => esc_html__( 'Large', 'atlets-core' ),
					'medium' => esc_html__( 'Medium', 'atlets-core' ),
					'small'  => esc_html__( 'Small', 'atlets-core' ),
					'custom' => esc_html__( 'Custom', 'atlets-core' ),
				],
				'default' => 'large'
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'label'     => esc_html__( 'Number Typography', 'atlets-core' ),
				'name'      => 'custom_fonts_number',
				'selector'  => '{{WRAPPER}} .wgl-countdown .countdown-section',
				'condition' => [
					'size' => 'custom'
				]
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'label'     => esc_html__( 'Text Typography', 'atlets-core' ),
				'name'      => 'custom_fonts_text',
				'selector'  => '{{WRAPPER}} .wgl-countdown .countdown-section .countdown-period',
				'condition' => [
					'size' => 'custom'
				]
			)
		);

		$this->add_control(
			'number_text_color',
			array(
				'label'     => esc_html__( 'Number Color', 'atlets-core' ),
				'type'      => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default'   => $header_font_color,
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-section .countdown-amount' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_control(
			'period_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'atlets-core' ),
				'type'      => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default'   => $main_font_color,
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-section .countdown-period' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_control(
			'separating_color',
			array(
				'label'     => esc_html__( 'Separate Color', 'atlets-core' ),
				'type'      => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default'   => $primary_color,
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-amount:after,
					{{WRAPPER}} .wgl-countdown .countdown-amount:before'  => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'show_separating' => 'yes'
				]
			)
		);

		/*End Style Section*/
		$this->end_controls_section();
	}

    protected function render()
    {
        $atts = $this->get_settings_for_display();

        $countdown = new WglCountDown();
        $countdown->render($this, $atts);
    }

	public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
