<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-demo-item.php.
*/
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Repeater;


class Wgl_Demo_Item extends Widget_Base
{

    public function get_name() {
        return 'wgl-demo-item';
    }

    public function get_title() {
        return esc_html__('WGL Demo Item', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-demo-item';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }

    protected function register_controls() {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $second_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $third_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-third-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);


        /*-----------------------------------------------------------------------------------*/
        /*  Content
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_demo_item_section',
            [
                'label' => esc_html__('Demo Item Settings', 'atlets-core'),
            ]
        );

        $this->add_control(
            'demo_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'default' => esc_html__('This is the heading', 'atlets-core'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('Choose your tag for demo item title', 'atlets-core'),
                'options' => [
                    'h1' => '‹h1›',
                    'h2' => '‹h2›',
                    'h3' => '‹h3›',
                    'h4' => '‹h4›',
                    'h5' => '‹h5›',
                    'h6' => '‹h6›',
                    'div' => '‹div›',
                    'span' => '‹span›',
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'thumbnail',
            [
                'label' => esc_html__('Image', 'atlets-core'),
                'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'coming_soon',
            [
                'label' => esc_html__('Coming Soon', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'add_button',
            [
                'label' => esc_html__('Add Button', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
                'return_value' => 'yes',
                'condition' => [
                    'coming_soon' => '',
                ]
            ]
        );

        $this->add_control(
            'button_title',
            [
                'label' => esc_html__('Button Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'default' => esc_html__('View Demo', 'atlets-core'),
                'condition' => [
                    'add_button' => 'yes',
                    'coming_soon' => '',
                ]
            ]
        );

        $this->add_control(
            'demo_link',
            [
                'label' => esc_html__('Demo Link', 'atlets-core'),
                'type' => Controls_Manager::URL,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'condition' => [
                    'add_button' => 'yes',
                    'coming_soon' => '',
                ]
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  Carousel styles
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__('Demo Item Styles', 'atlets-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'image_border_radius',
			[
				'label' => esc_html__('Image Border Radius', 'atlets-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px',
                ],
				'selectors' => [
					'{{WRAPPER}} .demo-item_image, {{WRAPPER}} .demo-item_image-link:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'image_box_shadow',
				'selector' => '{{WRAPPER}} .demo-item_image',
			]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_title',
                'selector' => '{{WRAPPER}} .demo-item_title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Title Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 30,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .demo-item_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'title_color_tab' );

        $this->start_controls_tab(
            'custom_title_color_idle',
            [ 'label' => esc_html__('Idle' , 'atlets-core') ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .demo-item_title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'custom_title_color_hover',
            [ 'label' => esc_html__('Hover' , 'atlets-core') ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => esc_attr($third_color),
                'selectors' => [
                    '{{WRAPPER}} .demo-item_title:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'coming_color',
            [
                'label' => esc_html__('Coming Soon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $third_color,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .demo-item_label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('demo', 'class', [
            'wgl-demo-item',
            (bool)$settings['coming_soon'] ? 'coming-soon' : ''
        ]);

        $this->add_render_attribute('demo_button', 'class', [
            'wgl-button',
            'elementor-button',
            'elementor-size-xl',
        ]);

        $this->add_render_attribute('demo_link', 'class', 'demo-item_image-link');
        if (!empty($settings['demo_link']['url'])) {
            $this->add_link_attributes('demo_button', $settings['demo_link']);
            $this->add_link_attributes('demo_link', $settings['demo_link']);
        }

        $this->add_render_attribute('title_link', 'class', 'demo-item_title-link');
        if (!empty($settings['demo_link']['url'])) {
            $this->add_link_attributes('title_link', $settings['demo_link']);
        }

        $this->add_render_attribute('demo_img', [
            'class' => 'demo-item_image',
            'src' => esc_url($settings['thumbnail']['url']),
            'alt' => Control_Media::get_image_alt( $settings['thumbnail'] ),
        ]);

        ?>
        <div <?php echo $this->get_render_attribute_string('demo'); ?>>
            <div class="demo-item_title-wrap"><?php
                if (!empty($settings[ 'thumbnail' ])) {?>
                    <div class="demo-item_image-wrap">
                        <a <?php echo $this->get_render_attribute_string('demo_link'); ?>><img <?php echo $this->get_render_attribute_string('demo_img'); ?> /></a><?php
                        if (!empty($settings['button_title'])) {?>
                            <a <?php echo $this->get_render_attribute_string('demo_button'); ?>><?php echo esc_html($settings[ 'button_title' ]);?></a><?php
                        }
                        if ((bool)$settings['coming_soon']) {?>
                            <h5 class="demo-item_label"><?php echo esc_html__('Coming Soon', 'atlets-core'); ?></h5><?php
                        }?>
                    </div><?php
                }
                if (!empty($settings['demo_title'])) {
                    echo '<a ', $this->get_render_attribute_string('title_link'), '>',
                        '<', $settings['title_tag'], ' class="demo-item_title">',
                            $settings['demo_title'],
                        '</', $settings['title_tag'], '>',
                    '</a>';
                }
                ?>
            </div>
        </div>

        <?php
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}