<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-double-headings.php.
*/
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use WglAddons\Includes\Wgl_Elementor_Helper;
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;

class Wgl_Double_Headings extends Widget_Base
{

    public function get_name() {
        return 'wgl-double-headings';
    }

    public function get_title() {
        return esc_html__('WGL Double Headings', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-double-headings';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }


    protected function register_controls() {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_double_headings_section',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );


        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'placeholder' => esc_html__('subtitle', 'atlets-core'),
                'default' => esc_html__('subtitle', 'atlets-core'),
            ]
        );

	    $this->add_control(
		    'subtitle_media_type',
		    [
			    'label' => esc_html__( 'Add Media', 'atlets-core' ),
			    'type' => Controls_Manager::CHOOSE,
			    'label_block' => false,
			    'options' => [
				    '' => [
					    'title' => esc_html__( 'None', 'atlets-core' ),
					    'icon' => 'fa fa-ban',
				    ],
				    'default' => [
					    'title' => esc_html__( 'Default', 'atlets-core' ),
					    'icon' => 'fas fa-signature',
				    ],
				    'line' => [
					    'title' => esc_html__( 'Line', 'atlets-core' ),
					    'icon' => 'fas fa-minus',
				    ],
				    'image' => [
					    'title' => esc_html__( 'Image', 'atlets-core' ),
					    'icon' => 'fa fa-image',
				    ]
			    ],
			    'default' => 'default',
		    ]
	    );

	    $this->add_control(
		    'subtitle_image',
		    [
			    'label' => esc_html__('Image', 'atlets-core'),
			    'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
			    'label_block' => true,
			    'condition' => [ 'subtitle_media_type' => 'image' ],
			    'default' => [ 'url' => Utils::get_placeholder_image_src() ],
		    ]
	    );

	    $this->add_control(
		    'subtitle_image_size',
		    [
			    'label' => esc_html__('Image Size', 'atlets-core'),
			    'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
			    'size_units' => [ 'px' ],
			    'range' => [
				    'px' => [ 'max' => 200 ],
			    ],
			    'default' => [ 'size' => 52, 'unit' => 'px' ],
			    'condition' => [ 'subtitle_media_type' => 'image' ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-dh-image img' => 'width: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_control(
            'dbl_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'type' => Controls_Manager::TEXTAREA,
			    'dynamic' => [  'active' => true],
                'rows' => 2,
                'separator' => 'before',
                'default' => esc_html__('Heading', 'atlets-core'),
                'placeholder' => esc_html__('Heading', 'atlets-core'),
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'prefix_class' => 'a',
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('Title Link', 'atlets-core'),
                'type' => Controls_Manager::URL,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('https://your-link.com', 'atlets-core'),
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLES -> TITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'dbl_title!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .dbl__title',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('HTML Tag', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => '‹h1›',
                    'h2' => '‹h2›',
                    'h3' => '‹h3›',
                    'h4' => '‹h4›',
                    'h5' => '‹h5›',
                    'h6' => '‹h6›',
                    'span' => '‹span›',
                    'div' => '‹div›',
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .dbl__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLES -> SUBTITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_subtitle',
            [
                'label' => esc_html__('Subtitle', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'subtitle!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_2['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_2['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .dbl__subtitle',
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#adadad',
                'selectors' => [
                    '{{WRAPPER}} .dbl__subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_width',
            [
                'label' => esc_html__('Bar Width', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'subtitle_media_type' => ['default', 'line'] ],
                'size_units' => [ 'px', 'em', 'rem' ],
                'range' => [
                    'px' => [ 'max' => 150 ],
                ],
                'default' => [ 'size' => 52 ],
                'selectors' => [
                    '{{WRAPPER}} .dbl__subtitle:before,
                    {{WRAPPER}} .dbl__subtitle.type-default .svg_media svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

	    $this->add_control(
		    'subtitle_bar_color',
		    [
			    'label' => esc_html__('Bar Color', 'atlets-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
			    'condition' => [ 'subtitle_media_type' => ['default', 'line'] ],
			    'default' => $secondary_color,
			    'selectors' => [
				    '{{WRAPPER}} .dbl__subtitle.type-line' => 'color: {{VALUE}};',
				    '{{WRAPPER}} .dbl__subtitle.type-default .svg_media svg' => 'fill: {{VALUE}};',
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'default' => [
	                'top' => '0',
	                'right' => '0',
	                'bottom' => '7',
	                'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .dbl__subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $_s = $this->get_settings_for_display();

        if ($_s['link']['url']) {
            $this->add_render_attribute('link', 'class', 'dbl__link');
            $this->add_link_attributes('link', $_s['link']);
        }
	    $subtitle_img = '';

	    if ($_s['subtitle_media_type'] == 'image' && !empty($_s['subtitle_image'])) {
		    if (!empty($_s['subtitle_image']['url'])) {
			    $this->add_render_attribute('thumbnail', 'src', $_s['subtitle_image']['url']);
			    $this->add_render_attribute('thumbnail', 'alt', Control_Media::get_image_alt($_s['subtitle_image']));
			    $this->add_render_attribute('thumbnail', 'title', Control_Media::get_image_title($_s['subtitle_image']));
			    $subtitle_img .= '<span class="wgl-dh-image">';
					$subtitle_img .= Group_Control_Image_Size::get_attachment_image_html($_s, 'full', 'subtitle_image');
			    $subtitle_img .= '</span>';
		    }
	    }

	    if ($_s['subtitle_media_type'] === 'default') {
	    	$subtitle_svg = '<span class="svg_media"><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 13.6" style="enable-background:new 0 0 100 13.6;" xml:space="preserve"><path class="st0" d="M28.8,9.7L33,6.9l4.3,2.9c7.7,5.2,17.7,5.2,25.4,0L67,6.9l4.3,2.9c3.9,2.6,8.3,3.9,12.7,3.9c4.4,0,8.8-1.3,12.7-3.9l3.2-2.1C99.9,6.3,100,5,100,3.7c0-0.6,0-1.1,0-1.7l-0.6-0.9L93.5,5c-5.8,3.9-13.3,3.9-19.1,0L67,0l-7.4,5c-5.8,3.9-13.3,3.9-19.1,0L33,0l-7.4,5C19.8,8.9,12.3,8.9,6.5,5L0.7,1.1L0,2c0,0.6,0,1.1,0,1.7C0,5,0.1,6.3,0.2,7.6l3.2,2.1C11.1,14.9,21,14.9,28.8,9.7z"/></svg></span>';
	    }

        $this->add_render_attribute('heading_wrapper', 'class', 'wgl-double_heading');

        echo '<div ', $this->get_render_attribute_string('heading_wrapper'), '>';

            if ($_s[ 'subtitle' ]) {
                echo '<div class="dbl__subtitle '.'type-'.$_s['subtitle_media_type'].'">',
                    $subtitle_svg ?? '',
                    $subtitle_img ?? '',
                    $_s[ 'subtitle' ],
                '</div>';
            }
            if ($_s['link']['url']) echo '<a ', $this->get_render_attribute_string('link'), '>';

            if ($_s[ 'dbl_title' ]) {
                echo '<', $_s[ 'title_tag' ], ' class="dbl__title-wrapper">',
                    '<span class="dbl__title">', $_s[ 'dbl_title' ], '</span>',
                '</', $_s[ 'title_tag' ], '>';
            }

            if ($_s['link']['url']) echo '</a>';

        echo '</div>';

    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}