<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-portfolio.php.
*/
namespace WglAddons\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use WglAddons\Includes\Wgl_Icons;
use WglAddons\Includes\Wgl_Loop_Settings;
use WglAddons\Includes\Wgl_Carousel_Settings;
use WglAddons\Templates\WglPortfolio;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;


class Wgl_Portfolio extends Widget_Base
{
    public function get_name() {
        return 'wgl-portfolio';
    }

    public function get_title() {
        return esc_html__('WGL Portfolio', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-portfolio';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }

    public function get_script_depends()
    {
        return [
            'slick',
            'imagesloaded',
            'isotope',
            'wgl-elementor-extensions-widgets',
        ];
    }


    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
	    $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
	    $tertiary_color = esc_attr( \Atlets_Theme_Helper::get_option( 'theme-tertiary-color' ) );
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);
	    $button_idle_color = esc_attr(\Atlets_Theme_Helper::get_option('button-idle-color'));
	    $button_hover_color = esc_attr(\Atlets_Theme_Helper::get_option('button-hover-color'));

        $hsl_color = \Atlets_Theme_Helper::hexToHsl($primary_color);
        $primary_color_shaded = esc_attr(\Atlets_Theme_Helper::shaded($hsl_color, 5));


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_portfolio_section',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_control(
            'portfolio_layout',
            [
                'label' => esc_html__('Layout', 'atlets-core'),
                'type' => 'wgl-radio-image',
                'options' => [
                    'grid' => [
                        'title' => esc_html__('Grid', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_grid.png',
                    ],
                    'carousel' => [
                        'title' => esc_html__('Carousel', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_carousel.png',
                    ],
                    'masonry' => [
                        'title' => esc_html__('Masonry', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry.png',
                    ],
                    'masonry2' => [
                        'title' => esc_html__('Masonry 2', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_2.png',
                    ],
                    'masonry3' => [
                        'title' => esc_html__('Masonry 3', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_3.png',
                    ],
                    'masonry4' => [
                        'title' => esc_html__('Masonry 4', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_4.png',
                    ],
                ],
                'default' => 'grid',
            ]
        );

        $this->add_control(
            'posts_per_row',
            [
                'label' => esc_html__('Columns Amount', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('1', 'atlets-core'),
                    '2' => esc_html__('2', 'atlets-core'),
                    '3' => esc_html__('3', 'atlets-core'),
                    '4' => esc_html__('4', 'atlets-core'),
                    '5' => esc_html__('5', 'atlets-core'),
                ],
                'default' => '3',
                'condition' => [
                    'portfolio_layout' => [ 'grid', 'masonry', 'carousel' ]
                ],
            ]
        );

        $this->add_control(
            'grid_gap',
            [
                'label' => esc_html__('Grid Gap', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '0px' => esc_html__('0', 'atlets-core'),
                    '1px' => esc_html__('1', 'atlets-core'),
                    '2px' => esc_html__('2', 'atlets-core'),
                    '3px' => esc_html__('3', 'atlets-core'),
                    '4px' => esc_html__('4', 'atlets-core'),
                    '5px' => esc_html__('5', 'atlets-core'),
                    '10px' => esc_html__('10', 'atlets-core'),
                    '15px' => esc_html__('15', 'atlets-core'),
                    '20px' => esc_html__('20', 'atlets-core'),
                    '25px' => esc_html__('25', 'atlets-core'),
                    '30px' => esc_html__('30', 'atlets-core'),
                    '35px' => esc_html__('35', 'atlets-core'),
                ],
                'default' => '30px',
            ]
        );

        $this->add_control(
            'show_filter',
            [
                'label' => esc_html__('Show Filter', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'portfolio_layout!' => 'carousel' ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'add_max_width_filter',
            [
                'label' => esc_html__('Limit the Filter Container Width', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'show_filter' => 'yes' ],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'max_width_filter',
            [
                'label' => esc_html__('Filter Container Max Width (px)', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'show_filter' => 'yes',
                    'add_max_width_filter' => 'yes',
                ],
                'default' => '1170',
                'selectors' => [
                    '{{WRAPPER}} .portfolio__filter' => 'max-width: {{VALUE}}px; margin-left: auto; margin-right: auto;',
                ],
            ]
        );

        $this->add_control(
            'filter_align',
            [
                'label' => esc_html__('Filter Align', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'portfolio_layout!' => 'carousel',
                    'show_filter' => 'yes',
                ],
                'options' => [
                    'left' => esc_html__('Left', 'atlets-core'),
                    'center' => esc_html__('Сenter', 'atlets-core'),
                    'right' => esc_html__('Right', 'atlets-core'),
                ],
                'default' => 'left',
            ]
        );

        $this->add_control(
            'img_size_string',
            [
                'label' => esc_html__('Image Size', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'portfolio_layout' => ['grid', 'carousel', 'masonry']
                ],
                'separator' => 'before',
                'options' => [
                    '150' => 'Thumbnail - 150x150',
                    '300' => 'Medium - 300x300',
                    '768' => 'Medium Large - 768x768',
                    '1024' => 'Large - 1024x1024',
                    '740x740' => '740x740', // 3col
                    '770x460' => '770x460', // slider variable width
                    '886x886' => '886x886', // 4col-wide
                    '1140x840' => '1140x840', // 2col
                    'full' => 'Full',
                    'custom' => 'Custom',
                ],
                'default' => '740x740',
            ]
        );

        $this->add_control(
            'img_size_array',
            [
                'label' => esc_html__('Image Dimension', 'atlets-core'),
                'type' => Controls_Manager::IMAGE_DIMENSIONS,
                'condition' => [
                    'img_size_string' => 'custom',
                    'portfolio_layout' => ['grid', 'carousel', 'masonry']
                ],
                'description' => esc_html__('Crop the original image to any custom size. You can also set a single value for width to keep the initial ratio.', 'atlets-core'),
                'default' => [
                    'width' => '740',
                    'height' => '940',
                ]
            ]
        );

        $this->add_control(
            'img_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'portfolio_layout' => ['grid', 'carousel', 'masonry'],
                    'img_size_string!' => 'custom',
                ],
                'options' => [
                    '1:1' => esc_html__('1:1', 'atlets-core'),
                    '3:2' => esc_html__('3:2', 'atlets-core'),
                    '4:3' => esc_html__('4:3', 'atlets-core'),
                    '9:16' => esc_html__('9:16', 'atlets-core'),
                    '16:9' => esc_html__('16:9', 'atlets-core'),
                    '21:9' => esc_html__('21:9', 'atlets-core'),
                    '' => esc_html__('Not Crop', 'atlets-core'),
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'navigation',
            [
                'label' => esc_html__('Navigation Type', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [ 'portfolio_layout!' => 'carousel' ],
                'options' => [
                    'none' => esc_html__('None', 'atlets-core'),
                    'pagination' => esc_html__('Pagination', 'atlets-core'),
                    'infinite' => esc_html__('Infinite Scroll', 'atlets-core'),
                    'load_more' => esc_html__('Load More', 'atlets-core'),
                ],
                'default' => 'none',
            ]
        );

        $this->add_control(
            'nav_align',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::SELECT,
                'condition' => [ 'navigation' => 'pagination' ],
                'options' => [
                    'left' => esc_html__('Left', 'atlets-core'),
                    'center' => esc_html__('Сenter', 'atlets-core'),
                    'right' => esc_html__('Right', 'atlets-core'),
                ],
                'default' => 'center',
            ]
        );

        $this->add_control(
            'items_load',
            [
                'label' => esc_html__('Items to be loaded', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'navigation' => [ 'load_more', 'infinite' ],
                ],
                'default' => esc_html__('4', 'atlets-core'),
            ]
        );

        $this->add_control(
            'name_load_more',
            [
                'label' => esc_html__('Button Text', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'navigation' => [ 'load_more', 'custom_link' ],
                ],
                'default' => esc_html__('Load More', 'atlets-core'),
            ]
        );

	    $output['icon_align'] = [
		    'label' => esc_html__('Icon Position', 'atlets-core'),
		    'type' => Controls_Manager::SELECT,
		    'condition' => ['icon_type!' => '', 'navigation' => 'load_more'],
		    'options' => [
			    'left' => esc_html__('Before', 'atlets-core'),
			    'right' => esc_html__('After', 'atlets-core'),
		    ],
		    'default' => 'right',
	    ];

	    $output['icon_indent'] = [
		    'label' => esc_html__('Icon Offset', 'atlets-core'),
		    'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
		    'condition' => ['icon_type!' => '', 'navigation' => 'load_more' ],
		    'range' => [
			    'px' => ['max' => 50],
		    ],
		    'default' => [ 'size' => 14, 'unit' => 'px' ],
		    'selectors' => [
			    '{{WRAPPER}} .align-icon-right .icon-wrapper' => 'margin-left: {{SIZE}}{{UNIT}};',
			    '{{WRAPPER}} .align-icon-left .icon-wrapper' => 'margin-right: {{SIZE}}{{UNIT}};',
		    ],
	    ];

	    Wgl_Icons::init(
		    $this,
		    [
			    'output' => $output,
			    'section' => false,
			    'condition' => [ 'navigation' => 'load_more' ],
		    ]
	    );

        $this->add_control(
            'add_animation',
            [
                'label' => esc_html__('Add Appear Animation', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'appear_animation',
            [
                'label' => esc_html__('Animation Style', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [ 'add_animation' => 'yes' ],
                'options' => [
                    'fade-in' => esc_html__('Fade In', 'atlets-core'),
                    'slide-top' => esc_html__('Slide Top', 'atlets-core'),
                    'slide-bottom' => esc_html__('Slide Bottom', 'atlets-core'),
                    'slide-left' => esc_html__('Slide Left', 'atlets-core'),
                    'slide-right' => esc_html__('Slide Right', 'atlets-core'),
                    'zoom' => esc_html__('Zoom', 'atlets-core'),
                ],
                'default' => 'fade-in',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> APPEARANCE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'display_section',
            [ 'label' => esc_html__('Appearance', 'atlets-core') ]
        );

        $this->add_control(
            'gallery_mode',
            [
                'label' => esc_html__('Gallery Mode', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'after',
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'show_portfolio_title',
            [
                'label' => esc_html__('Show Heading?', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'gallery_mode' => '' ],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_meta_categories',
            [
                'label' => esc_html__('Show Categories?', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'gallery_mode' => '' ],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_content',
            [
                'label' => esc_html__('Show Excerpt/Content?', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'gallery_mode' => '' ],
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'content_letter_count',
            [
                'label' => esc_html__('Content Letter Limit', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'show_content' => 'yes',
                    'gallery_mode' => '',
                ],
                'min' => 1,
                'default' => '85',
            ]
        );

        $this->add_control(
            'info_position',
            [
                'label' => esc_html__('Meta Position', 'atlets-core'),
                'condition' => [ 'gallery_mode' => '' ],
                'type' => Controls_Manager::SELECT,
                'separator' => 'before',
                'options' => [
                    'inside_image' => esc_html__('within image', 'atlets-core'),
                    'under_image' => esc_html__('beneath image', 'atlets-core'),
                ],
                'default' => 'inside_image',
            ]
        );

        $this->add_control(
            'image_anim',
            [
                'label' => esc_html__('Meta Animation', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'info_position' => 'inside_image',
                    'gallery_mode' => ''
                ],
                'options' => [
                    'simple' => esc_html__('Simple', 'atlets-core'),
                    'sub_layer' => esc_html__('On Sub-Layer', 'atlets-core'),
                    'offset' => esc_html__('Side Offset', 'atlets-core'),
                    'zoom_in' => esc_html__('Zoom In', 'atlets-core'),
                    'outline' => esc_html__('Outline', 'atlets-core'),
                    'always_info' => esc_html__('Visible Until Hover', 'atlets-core'),
                ],
                'default' => 'sub_layer',
            ]
        );

        $this->add_control(
            'meta_alignment',
            [
                'label' => esc_html__( 'Meta Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [ 'gallery_mode' => '' ],
                'label_block' => true,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'atlets-core'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
					'{{WRAPPER}} .portfolio__description' => 'text-align: {{VALUE}};',
				],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> LINKS
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_links',
            [
                'label' => esc_html__('Links', 'atlets-core'),
                'condition' => [ 'gallery_mode' => '' ],
            ]
        );

        $this->add_control(
            'linked_image',
            [
                'label' => esc_html__('Add link on Image', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'linked_title',
            [
                'label' => esc_html__('Add link on Heading', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'show_portfolio_title!' => '' ],
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'link_destination',
            [
                'label' => esc_html__('Link Action', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'linked_title',
                            'operator' => '!==',
                            'value' => '',
                        ],
                        [
                            'name' => 'linked_image',
                            'operator' => '!==',
                            'value' => '',
                        ],
                    ],
                ],
                'options' => [
                    'single' => esc_html__('Open Single Page', 'atlets-core'),
                    'custom' => esc_html__('Open Custom Link', 'atlets-core'),
                    'popup' => esc_html__('Popup the Image', 'atlets-core'),
                ],
                'default' => 'single',
            ]
        );

        $this->add_control(
            'link_custom_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'condition' => [ 'link_destination' => 'custom' ],
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'raw' => esc_html__('Note: Custom link can be specified in corresponding metabox options section of each post.', 'atlets-core' ),
            ]
        );

        $this->add_control(
            'link_target',
            [
                'label' => esc_html__('Open link in a new tab', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'conditions' => [
                    'terms' => [
                        [
                            'relation' => 'or',
                            'terms' => [
                                [
                                    'name' => 'linked_title',
                                    'operator' => '!==',
                                    'value' => '',
                                ],
                                [
                                    'name' => 'linked_image',
                                    'operator' => '!==',
                                    'value' => '',
                                ],
                            ],
                        ],
                        [
                            'name' => 'link_destination',
                            'operator' => '!==',
                            'value' => 'popup',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> CAROUSEL OPTIONS
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_carousel_section',
            [
                'label' => esc_html__('Carousel Options', 'atlets-core'),
                'condition' => [ 'portfolio_layout' => 'carousel' ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'autoplay' => 'yes' ],
                'min' => 1,
                'default' => '3000',
            ]
        );

        $this->add_control(
            'c_infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'c_slide_per_single',
            [
                'label' => esc_html__('Slide per single item', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'center_mode',
            [
                'label' => esc_html__('Center Mode', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'center_info',
            [
                'label' => esc_html__('Show Center Info', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'center_mode' => 'yes' ],
            ]
        );

        $this->add_control(
            'variable_width',
            [
                'label' => esc_html__('Variable Width', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'use_pagination',
            [
                'label' => esc_html__('Add Pagination control', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'pag_type',
            [
                'label' => esc_html__('Pagination Type', 'atlets-core'),
                'type' => 'wgl-radio-image',
                'condition' => [ 'use_pagination' => 'yes' ],
                'options' => [
                    'circle' => [
                        'title' => esc_html__('Circle', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_circle.png',
                    ],
                    'circle_border' => [
                        'title' => esc_html__('Empty Circle', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_circle_border.png',
                    ],
                    'square' => [
                        'title' => esc_html__('Square', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_square.png',
                    ],
                    'square_border' => [
                        'title' => esc_html__('Empty Square', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_square_border.png',
                    ],
                    'line' => [
                        'title' => esc_html__('Line', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_line.png',
                    ],
                    'line_circle' => [
                        'title' => esc_html__('Line - Circle', 'atlets-core'),
                        'image' => WGL_ELEMENTOR_ADDONS_URL . 'assets/img/wgl_elementor_addon/icons/pag_line_circle.png',
                    ],
                ],
                'default' => 'line_circle',
            ]
        );

        $this->add_control(
            'pag_offset',
            [
                'label' => esc_html__('Pagination Top Offset', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'use_pagination' => 'yes' ],
                'size_units' => [ 'px', '%', 'rem' ],
                'range' => [
	                'px' => [ 'min' => -55, 'max' => 55 ],
                ],
                'default' => [ 'size' => 14, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-carousel .slick-dots' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'custom_pag_color',
            [
                'label' => esc_html__('Customize Pagination Color', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'use_pagination!' => '' ],
            ]
        );

        $this->add_control(
            'pag_color',
            [
                'label' => esc_html__('Pagination Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'condition' => [ 'custom_pag_color' => 'yes' ],
            ]
        );

        $this->add_control(
            'use_prev_next',
            [
                'label' => esc_html__('Add Prev/Next buttons', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

	    $this->add_responsive_control(
		    'prev_next_offset',
		    [
			    'label' => esc_html__('Arrows Vertical Offset', 'atlets-core'),
			    'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
			    'condition' => [ 'use_prev_next!' => '' ],
			    'size_units' => [ 'px', '%', 'rem' ],
			    'range' => [
				    'px' => [ 'min' => -300, 'max' => 300 ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-carousel:not(.arrows_center_mode) .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
				    '{{WRAPPER}} .wgl-carousel.arrows_center_mode .slick-arrow' => 'bottom: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_control(
            'arrows_center_mode',
            [
                'label' => esc_html__('Set Arrows to Center', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'use_prev_next' => 'yes' ],
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );


        $this->add_control(
            'custom_resp',
            [
                'label' => esc_html__('Customize Responsive', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->add_control(
            'heading_desktop',
            [
                'label' => esc_html__('Desktop Settings', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'custom_resp' => 'yes' ],
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'resp_medium',
            [
                'label' => esc_html__('Desktop Screen Breakpoint', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
                'default' => '1025',
            ]
        );

        $this->add_control(
            'resp_medium_slides',
            [
                'label' => esc_html__('Columns amount', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
            ]
        );

        $this->add_control(
            'heading_tablet',
            [
                'label' => esc_html__('Tablet Settings', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [ 'custom_resp' => 'yes' ],
            ]
        );

        $this->add_control(
            'resp_tablets',
            [
                'label' => esc_html__('Tablet Screen Breakpoint', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
                'default' => '800',
            ]
        );

        $this->add_control(
            'resp_tablets_slides',
            [
                'label' => esc_html__('Columns amount', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
                'step' => 1,
            ]
        );

        $this->add_control(
            'heading_mobile',
            [
                'label' => esc_html__('Mobile Settings', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'custom_resp' => 'yes' ],
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'resp_mobile',
            [
                'label' => esc_html__('Mobile Screen Breakpoint', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
                'default' => '480',
            ]
        );

        $this->add_control(
            'resp_mobile_slides',
            [
                'label' => esc_html__('Columns amount', 'atlets-core'),
                'type' => Controls_Manager::NUMBER,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'custom_resp' => 'yes' ],
                'min' => 1,
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  SETTINGS -> QUERY
        /*-----------------------------------------------------------------------------------*/

        Wgl_Loop_Settings::init(
            $this,
            [
                'post_type' => 'portfolio',
                'hide_cats' => true,
                'hide_tags' => true
            ]
        );


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'media_style_section',
            [
                'label' => esc_html__('General', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

	    $this->add_control(
		    'items_radius',
		    [
			    'label' => esc_html__('Image Border Radius', 'atlets-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%' ],
			    'default' => [
				    'top' => '5',
				    'left' => '5',
				    'right' => '5',
				    'bottom' => '5',
				    'unit' => 'px',
				    'isLinked' => false,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-portfolio-item_image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'description_radius',
		    [
			    'label' => esc_html__('Description Border Radius', 'atlets-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%' ],
			    'default' => [
				    'top' => '5',
				    'left' => '5',
				    'right' => '5',
				    'bottom' => '5',
				    'unit' => 'px',
				    'isLinked' => false,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-portfolio-item_description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
            'items_padding',
            [
                'label' => esc_html__('Description Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'gallery_mode' => '' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '21',
                    'right' => '29',
                    'bottom' => '21',
                    'left' => '29',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-portfolio-item_description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'description',
                'types' => [ 'classic', 'gradient' ],
                'condition' => [
                    'info_position' => 'under_image',
                    'gallery_mode' => ''
                ],
                'selector' => '{{WRAPPER}} .wgl-portfolio-item_description',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color' => [ 'default' => '#ffffff' ],
                ],
            ]
        );

        $this->add_control(
            'overlay_heading',
            [
                'label' => esc_html__('Item Overlay', 'atlets-core'),
                'type' => Controls_Manager::HEADING,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'info_position',
                            'operator' => '===',
                            'value' => 'inside_image',
                        ],
                        [
                            'name' => 'gallery_mode',
                            'operator' => '!==',
                            'value' => '',
                        ],
                    ],
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'custom_image_mask_color',
                'types' => [ 'classic', 'gradient' ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'terms' => [
                                [
                                    'name' => 'info_position',
                                    'operator' => '===',
                                    'value' => 'inside_image',
                                ],
                                [
                                    'name' => 'image_anim',
                                    'operator' => '!==',
                                    'value' => 'sub_layer',
                                ],
                            ],
                        ],
                        [
                            'name' => 'gallery_mode',
                            'operator' => '!==',
                            'value' => '',
                        ],
                    ],
                ],
                'selector' => '{{WRAPPER}} .overlay',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color' => [ 'default' => '#ffffff' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'custom_desc_mask_color',
                'types' => [ 'classic', 'gradient' ],
                'condition' => [
                    'info_position' => 'inside_image',
                    'image_anim' => 'sub_layer',
                    'gallery_mode' => ''
                ],
                'selector' => '{{WRAPPER}} .wgl-portfolio-item_description',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color' => [ 'default' => '#ffffff' ],
                ],
            ]
        );

        $this->add_control(
            'sec_overlay_color',
            [
                'label' => esc_html__('Additional Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'info_position' => 'inside_image',
                    'image_anim' => [ 'offset', 'outline', 'always_info' ],
                ],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .inside_image .overlay:before' => 'box-shadow: inset 0px 0px 0px 0px {{VALUE}}',
                    '{{WRAPPER}} .inside_image:hover .overlay:before' => 'box-shadow: inset 0px 0px 0px 10px {{VALUE}}',
                    '{{WRAPPER}} .inside_image.offset_animation:before' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sec_overlay_bg',
            [
                'label' => esc_html__('Offset Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [
                    'info_position' => 'inside_image',
                    'image_anim' => [ 'offset' ],
                ],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .inside_image.offset_animation:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> FILTER
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_filter',
            [
                'label' => esc_html__('Filter', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'show_filter' => 'yes' ],
            ]
        );

	    $this->add_control(
		    'filter_counter',
		    [
			    'label' => esc_html__('Hide the Number of Categories?', 'atlets-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'default' => 'yes',
			    'selectors' => [
				    '{{WRAPPER}} .number_filter' => 'display: none;',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
            'filter_cats_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '9',
                    'bottom' => '0',
                    'left' => '9',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'filter_cats_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '32',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .isotope-filter' => 'margin-bottom: calc(32px - {{BOTTOM}}{{UNIT}});',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_filter_cats',
                'selector' => '{{WRAPPER}} .isotope-filter a',
            ]
        );

        $this->start_controls_tabs('filter_cats_color_tabs');

        $this->start_controls_tab(
            'filter_cats_color_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'filter_color_idle',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#828282',
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_idle',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_cats_color_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'filter_color_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .isotope-filter a:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_hover',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_cats_color_active',
            [ 'label' => esc_html__('Active', 'atlets-core') ]
        );

        $this->add_control(
            'filter_color_active',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_active',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'filter_cats_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'top' => '3',
                    'left' => '3',
                    'right' => '3',
                    'bottom' => '3',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'filter_cats_shadow',
                'selector' => '{{WRAPPER}} .isotope-filter a',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> HEADINGS
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_headings',
            [
                'label' => esc_html__('Headings', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_portfolio_title!' => '',
                    'gallery_mode' => ''
                ],
            ]
        );

        $this->add_responsive_control(
            'headings_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '1',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-item__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_portfolio_headings',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .portfolio-item__title .title',
            ]
        );

        $this->start_controls_tabs('headings_color');

        $this->start_controls_tab(
            'custom_headings_color_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'custom_headings_color',
            [
                'label' => esc_html__('Title Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-item__title .title:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .portfolio-item__title .title,
                     {{WRAPPER}} .inside_image .portfolio-item__title .title a:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'custom_headings_color_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'custom_hover_headings_color',
            [
                'label' => esc_html__('Title Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-item__title .title:hover, {{WRAPPER}} .portfolio-item__title .title:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> CATEGORIES
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'cats_style_section',
            [
                'label' => esc_html__('Categories', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'show_meta_categories!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_portfolio_cats',
                'selector' => '{{WRAPPER}} .post_cats',
            ]
        );

        $this->start_controls_tabs('cats_color_tabs');

        $this->start_controls_tab(
            'custom_cats_color_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'cat_color_idle',
            [
                'label' => esc_html__('Category Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .portfolio__item-meta .portfolio-category,
                     {{WRAPPER}} .portfolio__item-meta .portfolio-category:before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'custom_cats_color_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'cat_color_hover',
            [
                'label' => esc_html__('Category Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio__item-meta .portfolio-category:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> EXCERPT/CONTENT
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Excerpt/Content', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'show_content!' => '' ],
            ]
        );

        $this->add_control(
            'custom_content_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .wgl-portfolio-item_description .wgl-portfolio-item_content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> LOAD MORE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'load_more_style_section',
            [
                'label' => esc_html__('Load More', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'navigation' => 'load_more' ],
            ]
        );

        $this->add_control(
            'align_load_more',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
	                'top' => '20.5',
	                'right' => '35',
	                'bottom' => '20.5',
	                'left' => '35',
	                'unit' => 'px',
	                'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '50',
                    'left' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_load_more',
                'selector' => '{{WRAPPER}} .load_more_wrapper .load_more_item',
            ]
        );

        $this->start_controls_tabs('load_more_styles');

        $this->start_controls_tab(
            'load_more_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'load_more_color_idle',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_bg_idle',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $button_idle_color,
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'load_more_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'load_more_color_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_bg_hover',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
	            'default' => $button_hover_color,
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'load_more_border',
                'label' => esc_html__('Border Type', 'atlets-core'),
                'selector' => '{{WRAPPER}} .load_more_wrapper .load_more_item',
            ]
        );

        $this->add_control(
            'load_more_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'load_more_shadow',
                'selector' => '{{WRAPPER}} .load_more_wrapper .load_more_item',
            ]
        );

	    $this->add_control(
		    'morph_switcher',
		    [
			    'label' => esc_html__('Use morph element?', 'atlets-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'default' => 'yes',
		    ]
	    );

	    $this->add_control(
		    'morph_animation_idle',
		    [
			    'label' => esc_html__('Idle run animation', 'atlets-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'condition' => ['morph_switcher!' => ''],
			    'return_value' => 'idle-run',
			    'prefix_class' => 'morph-',
		    ]
	    );
	    $this->start_controls_tabs(
		    'tabs_morph_style',
		    ['condition' => ['morph_switcher!' => '']]
	    );

	    $this->start_controls_tab(
		    'tab_morph_idle',
		    ['label' => esc_html__('Idle', 'atlets-core')]
	    );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'morph_background',
			    'label' => esc_html__('Morph Background', 'atlets-core'),
			    'types' => [ 'classic' ],
			    'condition' => ['morph_switcher!' => ''],
			    'selector' => '{{WRAPPER}} .wgl-button .morph_element:after',
		    ]
	    );

	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'tab_morph_hover',
		    ['label' => esc_html__('Hover', 'atlets-core')]
	    );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'morph_background_hover',
			    'label' => esc_html__('Morph Background', 'atlets-core'),
			    'types' => [ 'classic' ],
			    'condition' => ['morph_switcher!' => ''],
			    'selector' => '{{WRAPPER}} .wgl-button:hover .morph_element:after',
		    ]
	    );

	    $this->end_controls_tab();
	    $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $atts = $this->get_settings_for_display();

        $portfolio = new WglPortfolio();
        echo $portfolio->render($atts, $this);
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}
