<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-pricing-table.php.
*/
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use WglAddons\Includes\Wgl_Icons;
use WglAddons\templates\WGL_Button;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;


class Wgl_Pricing_Table extends Widget_Base
{

    public function get_name() {
        return 'wgl-pricing-table';
    }

    public function get_title() {
        return esc_html__('WGL Pricing Table', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-pricing-table';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }


    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);

        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_general',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_responsive_control(
            'p_alignment',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
	                    'title' => esc_html__('Justified', 'atlets-core'),
	                    'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'justify',
                'prefix_class' => 'a',
            ]
        );

        $this->add_control(
            'p_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('Title...', 'atlets-core'),
                'default' => esc_html__('Basic Plan', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'p_currency',
            [
                'label' => esc_html__('Currency', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('Currency...', 'atlets-core'),
                'default' => esc_html__('$', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'p_price',
            [
                'label' => esc_html__('Price', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('Price...', 'atlets-core'),
                'default' => esc_html__('99', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'p_period',
            [
                'label' => esc_html__('Period', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('Period...', 'atlets-core'),
                'default' => esc_html__('/ per month', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'p_content',
            [
                'label' => esc_html__('Content', 'atlets-core'),
                'type' => Controls_Manager::WYSIWYG,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'default' => esc_html__('Your content...', 'atlets-core'),
            ]
        );

        $this->add_control(
            'p_description',
            [
                'label' => esc_html__('Description', 'atlets-core'),
                'type' => Controls_Manager::TEXTAREA,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'placeholder' => esc_html__('Description...', 'atlets-core'),
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('Enable hover animation', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('Lift up the item on hover.', 'atlets-core'),
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> HIGHLIGHTER
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_highlighter',
            [ 'label' => esc_html__('Highlighter', 'atlets-core') ]
        );

        $this->add_control(
            'highlighter_switch',
            [
                'label' => esc_html__('Use highlighting element?', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'highlighter_text',
            [
                'label' => esc_html__('Highlighting Text', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'highlighter_switch' => 'yes' ],
                'default' => esc_html__('Best', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> BUTTON
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_button',
            [ 'label' => esc_html__('Button', 'atlets-core') ]
        );

        $this->add_control(
            'b_switch',
            [
                'label' => esc_html__('Use button?','atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'b_title',
            [
                'label' => esc_html__('Button Text', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'b_switch' => 'yes' ],
                'label_block' => true,
                'default' => esc_html__('Buy Now', 'atlets-core'),
            ]
        );

        $this->add_control(
            'b_link',
            [
                'label' => esc_html__('Button Link', 'atlets-core'),
                'type' => Controls_Manager::URL,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'b_switch' => 'yes' ],
                'label_block' => true,
            ]
        );

	    $output['pre--icon_align'] = [
		    'label' => esc_html__('Icon Position', 'atlets-core'),
		    'type' => Controls_Manager::SELECT,
		    'condition' => ['pre--icon_type!' => ''],
		    'options' => [
			    'left' => esc_html__('Before', 'atlets-core'),
			    'right' => esc_html__('After', 'atlets-core'),
		    ],
		    'default' => 'right',
	    ];

	    $output['pre--icon_indent'] = [
		    'label' => esc_html__('Icon Offset', 'atlets-core'),
		    'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
		    'condition' => ['pre--icon_type!' => ''],
		    'range' => [
			    'px' => ['max' => 50],
		    ],
		    'default' => [ 'size' => 14, 'unit' => 'px' ],
		    'selectors' => [
			    '{{WRAPPER}} .align-icon-right .icon-wrapper' => 'margin-left: {{SIZE}}{{UNIT}};',
			    '{{WRAPPER}} .align-icon-left .icon-wrapper' => 'margin-right: {{SIZE}}{{UNIT}};',
		    ],
	    ];

	    Wgl_Icons::init(
		    $this,
		    [
			    'output' => $output,
			    'prefix' => 'pre--',
			    'section' => false,
		    ]
	    );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> HIGHLIGHTER
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_highlighter',
            [
                'label' => esc_html__('Highlighter', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'highlighter_switch!' => '' ],
            ]
        );

        $this->add_control(
            'highlighter_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing_highlighter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'highlighter_bg_color',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .pricing_highlighter' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'highlighter_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '30',
                    'bottom' => '0',
                    'left' => '0',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_highlighter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'highlighter_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '15',
                    'right' => '13',
                    'bottom' => '15',
                    'left' => '13',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_highlighter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'highlighter_b_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'top' => '50',
                    'right' => '50',
                    'bottom'=> '50',
                    'left' => '50',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_highlighter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> TITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .pricing_title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing_title' => 'color: {{VALUE}};',
                ],
            ]
        );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'title_bg',
			    'types' => [ 'classic', 'gradient' ],
			    'fields_options' => [
				    'background' => [ 'default' => 'classic' ],
				    'color' => [ 'default' => $h_font_color ],
			    ],
			    'selector' => '{{WRAPPER}} .pricing_title',
		    ]
	    );

	    $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
	                'top' => '40',
	                'right' => '0',
	                'bottom'=> '0',
	                'left' => '-59',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '14',
                    'right' => '56',
                    'bottom'=> '14',
                    'left' => '56',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom'=> '5',
                    'left' => '5',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .pricing_title',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> PRICE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_price',
            [
                'label' => esc_html__('Price', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_price_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .pricing_price_wrap',
            ]
        );

        $this->add_control(
            'custom_price_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .pricing_price_wrap' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '40',
                    'right' => '0',
                    'bottom'=> '38',
                    'left' => '0',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_price_wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'price_border',
			    'fields_options' => [
				    'border' => [ 'default' => 'solid' ],
				    'width' => [
					    'default' => [
						    'top' => 0,
						    'right' => 0,
						    'bottom' => 1,
						    'left' => 0,
					    ],
				    ],
				    'color' => [ 'default' => '#e8e8e8' ],
			    ],
			    'selector' => '{{WRAPPER}} .pricing_price_wrap',
		    ]
	    );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> PERIOD
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_period',
            [
                'label' => esc_html__('Period', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_period_typo',
                'selector' => '{{WRAPPER}} .pricing_period',
                'fields_options' => [
                    'font_size' => [
                        'default' => [ 'size' => 0.3, 'unit' => 'em' ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'period_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#a2a2a2',
                'selectors' => [
                    '{{WRAPPER}} .pricing_period' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'period_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
	                'top' => '0',
	                'right' => '0',
	                'bottom' => '0',
	                'left' => '7',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_period' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> CONTENT
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_content_typo',
                'selector' => '{{WRAPPER}} .pricing_content',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .pricing_content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content-padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'default' => [
	                'top' => '24',
	                'right' => '40',
	                'bottom' => '13',
	                'left' => '40',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_content' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}}; padding-left: {{LEFT}}{{UNIT}} !important; padding-right: {{RIGHT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> DESCRIPTION
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_description',
            [
                'label' => esc_html__('Description', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'p_description!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_desc_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_3['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_3['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .pricing_desc',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $main_font_color,
                'selectors' => [
                    '{{WRAPPER}} .pricing_desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> BUTTON
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_button',
            [
                'label' => esc_html__('Button', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'b_switch!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'tab_button_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_icon_color',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'b_bg_idle',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'b_color_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover, {{WRAPPER}} .wgl-button:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

	    $this->add_control(
		    'button_icon_color_hover',
		    [
			    'label' => esc_html__('Icon Color', 'atlets-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
			    'default' => '#ffffff',
			    'selectors' => [
				    '{{WRAPPER}} .wgl-button:hover .elementor-icon, {{WRAPPER}} .wgl-button:focus .elementor-icon' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->add_control(
            'b_bg_hover',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover, {{WRAPPER}} .wgl-button:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .wgl-button:hover',
            ]
        );

        $this->add_control(
            'b_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'border_border!' => '' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover, {{WRAPPER}} .wgl-button:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .wgl-button',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'b_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
	                'top' => '3',
	                'right' => '3',
	                'bottom' => '3',
	                'left' => '3',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'b_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'b_switch' => 'yes' ],
                'separator' => 'before',
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '40',
                    'left' => '0',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'b_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'b_switch' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
	                'top' => '19',
	                'right' => '35',
	                'bottom' => '19',
	                'left' => '35',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

	    $this->add_control(
		    'pre--morph_switcher',
		    [
			    'label' => esc_html__('Use morph element?', 'atlets-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'default' => 'yes',
		    ]
	    );

	    $this->add_control(
		    'pre--morph_animation_idle',
		    [
			    'label' => esc_html__('Idle run animation', 'atlets-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'condition' => ['pre--morph_switcher!' => ''],
			    'return_value' => 'idle-run',
			    'prefix_class' => 'morph-',
		    ]
	    );

	    $this->start_controls_tabs(
		    'tabs_morph_style',
		    ['condition' => ['pre--morph_switcher!' => '']]
	    );

	    $this->start_controls_tab(
		    'tab_morph_idle',
		    ['label' => esc_html__('Idle', 'atlets-core')]
	    );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'pre--morph_background',
			    'label' => esc_html__('Morph Background', 'atlets-core'),
			    'types' => [ 'classic' ],
			    'condition' => ['pre--morph_switcher!' => ''],
			    'selector' => '{{WRAPPER}} .wgl-button .morph_element:after',
		    ]
	    );

	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'tab_morph_hover',
		    ['label' => esc_html__('Hover', 'atlets-core')]
	    );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'pre--morph_background_hover',
			    'label' => esc_html__('Morph Background', 'atlets-core'),
			    'types' => [ 'classic' ],
			    'condition' => ['pre--morph_switcher!' => ''],
			    'selector' => '{{WRAPPER}} .wgl-button:hover .morph_element:after',
		    ]
	    );

	    $this->end_controls_tab();
	    $this->end_controls_tabs();
        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> BACKGROUND
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_bg',
            [
                'label' => esc_html__('Background', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bg_scheme',
            [
                'label' => esc_html__('Customize for:', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'module' => esc_html__('whole module', 'atlets-core'),
                    'sections' => esc_html__('separate sections', 'atlets-core'),
                ],
                'default' => 'module',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'module',
                'types' => [ 'classic', 'gradient' ],
                'condition' => [ 'bg_scheme' => 'module' ],
                'selector' => '{{WRAPPER}} .pricing_plan_wrap',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_s',
                'label' => esc_html__('Header Section Background', 'atlets-core'),
                'types' => [ 'classic', 'gradient' ],
                'condition' => [ 'bg_scheme' => 'sections' ],
                'selector' => '{{WRAPPER}} .pricing_header',
            ]
        );

        $this->add_control(
            'content_s_bg',
            [
                'label' => esc_html__('Content Section Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'bg_scheme' => 'sections' ],
                'separator' => 'before',
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pricing_content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'footer_s_bg',
            [
                'label' => esc_html__('Footer Section Background', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'bg_scheme' => 'sections' ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pricing_footer' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bg_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '40',
                    'bottom' => '0',
                    'left' => '40',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_header' => 'padding-top: {{TOP}}{{UNIT}};',
                    '{{WRAPPER}} .pricing_header, {{WRAPPER}} .pricing_content, {{WRAPPER}} .pricing_footer' => 'padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};',
                    '{{WRAPPER}} .pricing_footer' => 'padding-bottom: {{BOTTOM}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing_plan_wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'bg_border',
                'selector' => '{{WRAPPER}} .pricing_plan_wrap',
            ]
        );

	    $this->add_group_control(
		    Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'bg_shadow',
			    'selector' => '{{WRAPPER}} .pricing_plan_wrap',
			    'fields_options' => [
				    'box_shadow_type' => [
					    'default' => 'yes'
				    ],
				    'box_shadow' => [
					    'default' => [
						    'horizontal' => 0,
						    'vertical' => 8,
						    'blur' => 30,
						    'spread' => 0,
						    'color' => 'rgba(0,0,0,.12)',
					    ]
				    ]
			    ]
		    ]
	    );

	    $this->end_controls_section();

    }

    protected function render()
    {
        $_s = $this->get_settings_for_display();

        $title = $description = $highlighter = $button = '';

        // Wrapper classes
        $wrap_classes = $_s['hover_animation'] ? ' hover-animation' : '';

        // Title
        if (!empty($_s['p_title'])) {
            $title .= '<div class="pricing_title_wrapper">';
            $title .= '<h4 class="pricing_title">';
                $title .= esc_html($_s['p_title']);
            $title .= '</h4>';
            $title .= '</div>';
        }

        // Currency
        $currency = ! empty($_s['p_currency']) ? '<span class="pricing_currency">'.esc_html($_s['p_currency']).'</span>' : '';

        // Price
        if ( isset($_s['p_price']) ) {
            preg_match( "/(\d+)(\.| |,)(\d+)$/", $_s['p_price'], $matches, PREG_OFFSET_CAPTURE );
            switch ( isset($matches[0]) ) {
                case false:
                    $price = '<div class="pricing_price">'.esc_html($_s['p_price']).'</div>';
                    break;
                case true:
                    $price = '<div class="pricing_price">';
                        $price .= esc_html($matches[1][0]);
                        $price .= '<span class="price_decimal">'.esc_html($matches[3][0]).'</span>';
                    $price .= '</div>';
                    break;
            }
        }

        // Period
        $period = ! empty($_s['p_period']) ? '<span class="pricing_period">'.esc_html($_s['p_period']).'</span>' : '';

        // Description
        if ( $_s['p_description'] ) {
            $allowed_html = [
                'a' => [
                    'href' => true, 'title' => true,
                    'class' => true, 'style' => true,
                    'rel' => true, 'target' => true
                ],
                'br' => [ 'class' => true, 'style' => true ],
                'em' => [ 'class' => true, 'style' => true ],
                'strong' => [ 'class' => true, 'style' => true ],
                'span' => [ 'class' => true, 'style' => true ],
                'p' => [ 'class' => true, 'style' => true ],
                'ul' => [ 'class' => true, 'style' => true ],
                'ol' => [ 'class' => true, 'style' => true ],
            ];
            $description = '<div class="pricing_desc">'.wp_kses( $_s['p_description'], $allowed_html ).'</div>';
        }

        // Highlighter
        if ( $_s['highlighter_switch'] && ! empty($_s['highlighter_text']) ) {
            $highlighter = '<div class="pricing_highlighter">'.esc_html($_s['highlighter_text']).'</div>';
        }

        // Button
        if ( $_s['b_switch'] ) {
            $button_options = [
                'icon_type' => '',
                'text' => $_s['b_title'],
                'link' => $_s['b_link'],
                'size' => 'lg',
            ];

	        foreach($_s as $key => $value){
		        $exp_key = explode('--', $key);
		        if($exp_key[0] === 'pre' && !empty($value)){
			        $button_options[$exp_key[1]] = $value;
		        }
	        }

            $button = new WGL_Button();
            ob_start();
                $button->render($this, $button_options);
            $button = ob_get_clean();
        }

        // Render
        echo '<div class="wgl-pricing_plan', $wrap_classes, '">',
            '<div class="pricing_plan_wrap">',
                '<div class="pricing_header">',
                    $highlighter,
                    $title,
                    '<div class="pricing_price_wrap">',
                        $currency,
                        $price,
                        $period,
                    '</div>',
                '</div>',
                '<div class="pricing_content">',
                    $_s['p_content'],
                '</div>',
                '<div class="pricing_footer">',
                    $description,
                    $button,
                '</div>',
            '</div>',
        '</div>';
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
