<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-progress-bar.php.
*/
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use WglAddons\Includes\Wgl_Icons;
use WglAddons\Templates\WglProgressBar;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;

class Wgl_Progress_Bar extends Widget_Base
{

    public function get_name() {
        return 'wgl-progress-bar';
    }

    public function get_title() {
        return esc_html__('WGL Progress Bar', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-progress-bar';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }

    public function get_script_depends() {
        return [ 'jquery-appear' ];
    }

    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_general',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_control(
            'progress_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'placeholder' => esc_html__('Ex: My Skill', 'atlets-core'),
                'default' => esc_html__('My Skill', 'atlets-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'value',
            [
                'label' => esc_html__('Value', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'default' => [ 'size' => 50, 'unit' => '%' ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'units',
            [
                'label' => esc_html__('Units', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'placeholder' => esc_html__('Ex: %, px, points, etc.', 'atlets-core'),
                'default' => esc_html__('%', 'atlets-core'),
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> TITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_title_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_4['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_4['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .progress_label',
            ]
        );

        $this->add_control(
            'progress_title_tag',
            [
                'label' => esc_html__('HTML Tag', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => '‹h1›',
                    'h2' => '‹h2›',
                    'h3' => '‹h3›',
                    'h4' => '‹h4›',
                    'h5' => '‹h5›',
                    'h6' => '‹h6›',
                    'div' => '‹div›',
                ],
                'default' => 'div',
            ]
        );

        $this->add_control(
            'custom_title_color',
            [
                'label' => esc_html__('Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => esc_attr($h_font_color),
                'selectors' => [
                    '{{WRAPPER}} .progress_label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress_label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> VALUE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_value',
            [
                'label' => esc_html__('Value', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_value_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_4['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_4['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .progress_value_wrap',
            ]
        );

        $this->add_control(
            'custom_value_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .progress_value_wrap' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'custom_value_color_bg',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .progress_value_wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'value_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress_value_wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'value_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress_value_wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'value_pos',
            [
                'label' => esc_html__('Value Position', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'fixed' => esc_html__('Fixed', 'atlets-core'),
                    'dynamic' => esc_html__('Dynamic', 'atlets-core'),
                ],
                'default' => 'fixed',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> PROGRESS BAR
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_bar',
            [
                'label' => esc_html__('Bar', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bar_height_filled',
            [
                'label' => esc_html__('Filled Bar Height', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => 1, 'max' => 50 ],
                ],
                'default' => [ 'size' => 4 ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap .progress_bar' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_gap',
            [
                'label' => esc_html__('Bar gap', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => -20, 'max' => 20 ],
                ],
                'default' => [ 'size' => 11 ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar' => 'transform: translateY(calc( -1 * {{SIZE}}{{UNIT}}));',
                ],
            ]
        );

        $this->add_control(
            'bar_height_empty',
            [
                'label' => esc_html__('Empty Bar Height', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => 1, 'max' => 50 ],
                ],
                'default' => [ 'size' => 2 ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_bg_color',
            [
                'label' => esc_html__('Empty Bar Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#e6e6e6',
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'bar_color',
            [
                'label' => esc_html__('Filled Bar Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .progress_bar' => 'background-color: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bar_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bar_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '25',
                    'right' => '0',
                    'bottom' => '7',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress_bar_wrap,
                     {{WRAPPER}} .progress_bar,
                     {{WRAPPER}} .progress_bar_wrap-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'bar_box_shadow',
                'selector' => '{{WRAPPER}} .progress_bar_wrap',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .progress_bar_wrap-wrap',
            ]
        );

        $this->end_controls_section();

    }

    public function render()
    {
        $_s = $this->get_settings_for_display();

        $this->add_render_attribute('progress_bar', 'class', [
            'wgl-progress_bar',
            $_s['value_pos'] == 'dynamic' ? 'dynamic-value' : '',
        ]);

        $this->add_render_attribute('bar', [
            'class' => 'progress_bar',
            'data-width' => esc_attr((int)$_s['value']['size']),
        ]);

        $this->add_render_attribute('label', 'class', 'progress_label');

        // Render
        echo '<div ', $this->get_render_attribute_string('progress_bar'), '>';
            echo '<div class="progress_wrap">';

                echo '<div class="progress_label_wrap">';
                    if (!empty($_s['progress_title'])) { ?>
                        <<?php echo esc_attr($_s['progress_title_tag']); ?> <?php echo $this->get_render_attribute_string('label'); ?>><?php
                            echo esc_html($_s['progress_title']);
                        ?></<?php echo esc_attr($_s['progress_title_tag']); ?>>
                    <?php }
                    echo '<div class="progress_value_wrap">';
                        echo '<span class="progress_value">0</span>';
                        if (!empty($_s['units'])) {
                            echo '<span class="progress_units">',
                                esc_html($_s['units']),
                            '</span>';
                        }
                    echo '</div>';
                echo '</div>';

                echo '<div class="progress_bar_wrap-wrap">',
                    '<div class="progress_bar_wrap">',
                        '<div ', $this->get_render_attribute_string('bar'), '></div>',
                    '</div>',
                '</div>';

	        echo '</div>';
        echo '</div>';
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}