<?php
/**
 * This template can be overridden by copying it to `atlets[-child]/atlets-core/elementor/widgets/wgl-tabs.php`.
 */
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Frontend,
    Widget_Base,
    Utils,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Control_Media,
    Group_Control_Image_Size,
    Icons_Manager,
    Repeater
};
use WglAddons\Includes\Wgl_Elementor_Helper;

class Wgl_Tabs extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-tabs';
    }

    public function get_title()
    {
        return esc_html__('WGL Tabs', 'atlets-core');
    }

    public function get_icon()
    {
        return 'wgl-tabs';
    }

    public function get_categories()
    {
        return [ 'wgl-extensions' ];
    }

    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);

        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'section_content_general',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_responsive_control(
            'tabs_tab_align',
            [
                'label' => esc_html__( 'Title Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'atlets-core'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'render_type' => 'template',
            ]
        );

        $this->end_controls_section();

        /** CONTENT -> CONTENT */

        $this->start_controls_section(
            'section_content_content',
            [ 'label' => esc_html__('Content', 'atlets-core') ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
			'tabs_tab_title',
			[
                'label' => esc_html__('Tab Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'default' => esc_html__('Tab Title', 'atlets-core'),
			]
        );
        $repeater->add_control(
			'tabs_tab_icon_type',
			[
                'label' => esc_html__( 'Add Icon/Image', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    '' => [
                        'title' => esc_html__( 'None', 'atlets-core' ),
                        'icon' => 'fa fa-ban',
                    ],
                    'font' => [
                        'title' => esc_html__( 'Icon', 'atlets-core' ),
                        'icon' => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => esc_html__( 'Image', 'atlets-core' ),
                        'icon' => 'fa fa-image',
                    ]
                ],
                'default' => '',
			]
        );
        $repeater->add_control(
			'tabs_tab_icon_fontawesome',
			[
                'label'       => esc_html__( 'Icon', 'atlets-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'     => [
                    'tabs_tab_icon_type'  => 'font',
                ],
                'description' => esc_html__( 'Select icon from Fontawesome library.', 'atlets-core' ),
			]
        );
        $repeater->add_control(
			'tabs_tab_icon_thumbnail',
			[
                'label'       => esc_html__( 'Image', 'atlets-core' ),
                'type'        => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
                'condition'     => [
                    'tabs_tab_icon_type'   => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
			]
        );
        $repeater->add_control(
			'tabs_content_type',
			[
                'label' => esc_html__('Content Type', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'content' => esc_html__('Content', 'atlets-core'),
                    'template' => esc_html__('Saved Templates', 'atlets-core'),
                ],
                'default' => 'content',
			]
        );
        $repeater->add_control(
			'tabs_content_templates',
			[
                'label' => esc_html__('Choose Template', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => Wgl_Elementor_Helper::get_instance()->get_elementor_templates(),
                'condition' => [
                    'tabs_content_type' => 'template',
                ],
			]
        );
        $repeater->add_control(
			'tabs_content',
			[
                'label' => esc_html__('Tab Content', 'atlets-core'),
                'type' => Controls_Manager::WYSIWYG,
			    'dynamic' => [  'active' => true],
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit. Optio, neque qui velit. Magni dolorum quidem ipsam eligendi, totam, facilis laudantium cum accusamus ullam voluptatibus commodi numquam, error, est. Ea, consequatur.', 'atlets-core'),
                'condition' => [
                    'tabs_content_type' => 'content',
                ],
			]
        );

        $this->add_control(
            'tabs_tab',
            [
                'type' => Controls_Manager::REPEATER,
                'seperator' => 'before',
                'default' => [
                    [ 'tabs_tab_title' => esc_html__('Tab Title 1', 'atlets-core') ],
                    [ 'tabs_tab_title' => esc_html__('Tab Title 2', 'atlets-core') ],
                    [ 'tabs_tab_title' => esc_html__('Tab Title 3', 'atlets-core') ],
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{tabs_tab_title}}',
            ]
        );

        $this->end_controls_section();

        /** STYLE -> TITLE */

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tabs_title_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_1['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .wgl-tabs_title',
            ]
        );

        $this->add_control(
            'tabs_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => '‹h1›',
                    'h2' => '‹h2›',
                    'h3' => '‹h3›',
                    'h4' => '‹h4›',
                    'h5' => '‹h5›',
                    'h6' => '‹h6›',
                    'div' => '‹div›',
                ],
                'default' => 'h4',
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '8',
                    'right' => '35',
                    'bottom' => '19',
                    'left' => '35',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'mobile_default' => [
	                'top' => '19',
	                'right' => '35',
	                'bottom' => '19',
	                'left' => '35',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '27',
                    'bottom' => '0',
                    'left' => '0',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_title_line',
            [
                'label' => esc_html__('Add Title Bottom Line', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'return_value' => 'yes',

            ]
        );

        $this->start_controls_tabs( 'tabs_header_tabs' );

        $this->start_controls_tab(
            'tabs_header_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'title_color_idle',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#828282',
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header' => 'color: {{VALUE}};',
                ],
            ]
        );

	    $this->add_control(
		    't_title_line_color_idle',
		    [
			    'label' => esc_html__('Title Bottom Line Color', 'atlets-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
			    'condition' => [ 'tabs_title_line' => 'yes' ],
			    'default' => '#e5e5e5',
			    'selectors' => [
				    '{{WRAPPER}} .wgl-tabs_header:after' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->add_control(
            'title_bg_color_idle',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_border_radius_idle',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'tabs_title_border',
                'selector' => '{{WRAPPER}} .wgl-tabs_header',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_header_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            't_title_color_hover',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_line_color_hover',
            [
                'label' => esc_html__('Title Bottom Line Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'tabs_title_line' => 'yes' ],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header:hover:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 't_title_border_hover',
                'selector' => '{{WRAPPER}} .wgl-tabs_header:hover',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            't_header_active',
            [ 'label' => esc_html__('Active', 'atlets-core') ]
        );

        $this->add_control(
            't_title_color_active',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_bg_color_active',
            [
                'label' => esc_html__('Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_line_color_active',
            [
                'label' => esc_html__('Title Bottom Line Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'tabs_title_line' => 'yes' ],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header.active:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            't_title_border_radius_active',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 't_title_border_active',
                'selector' => '{{WRAPPER}} .wgl-tabs_header.active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> ICON */

        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => esc_html__('Icon', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'tabs_icon_size',
            [
                'label' => esc_html__('Icon Size', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'default' => [
                    'size' => 26,
                    'unit' => 'px',
                ],
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_icon:not(.wgl-tabs_icon-image)' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_icon_position',
            [
                'label' => esc_html__('Icon/Image Position', 'atlets-core'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'top' => [
                        'title' => esc_html__('Top', 'atlets-core'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'bottom' => [
                        'title' => esc_html__('Bottom', 'atlets-core'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-h-align-left',
                    ]
                ],
                'default' => 'top',
                'render_type' => 'template',
            ]
        );

        $this->add_responsive_control(
            'tabs_icon_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_icon_tabs' );

        $this->start_controls_tab(
            'tabs_icon_idle',
            [ 'label' => esc_html__('Idle', 'atlets-core') ]
        );

        $this->add_control(
            'tabs_icon_color',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .wgl-tabs_icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_icon_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_control(
            'tabs_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header:hover .wgl-tabs_icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .wgl-tabs_header:hover .wgl-tabs_icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_icon_active',
            [ 'label' => esc_html__('Active', 'atlets-core') ]
        );

        $this->add_control(
            'tabs_icon_color_active',
            [
                'label' => esc_html__('Icon Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_header.active .wgl-tabs_icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .wgl-tabs_header.active .wgl-tabs_icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> CONTENT */

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tabs_content_typo',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_family' => ['default' => \Wgl_Addons_Elementor::$typography_3['font_family']],
                    'font_weight' => ['default' => \Wgl_Addons_Elementor::$typography_3['font_weight']],
                ],
                'selector' => '{{WRAPPER}} .wgl-tabs_content',
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '21',
                    'right' => '0',
                    'bottom' => '15',
                    'left' => '0',
                    'unit'  => 'px',
                    'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_content_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_content_color',
            [
                'label' => esc_html__('Content Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $main_font_color,
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_content_bg_color',
            [
                'label' => esc_html__('Content Background Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-tabs_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'tabs_content_border',
                'selector' => '{{WRAPPER}} .wgl-tabs_content',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $_s = $this->get_settings_for_display();
        $id_int = substr( $this->get_id_int(), 0, 3 );

        $this->add_render_attribute(
            'tabs',
            [
                'class' => [
                    'wgl-tabs',
	                (!empty($_s['tabs_tab_align']) ? 'tabs_align-'.$_s['tabs_tab_align'] : ''),
	                (!empty($_s['tabs_tab_align_tablet']) ? 'tabs_align-tablet-'.$_s['tabs_tab_align_tablet'] : ''),
	                (!empty($_s['tabs_tab_align_mobile']) ? 'tabs_align-mobile-'.$_s['tabs_tab_align_mobile'] : ''),
	                (!empty($_s['tabs_icon_position']) ? 'icon_position-'.$_s['tabs_icon_position'] : ''),
                    (!empty($_s['tabs_icon_position_tablet']) ? 'icon_position-tablet-'.$_s['tabs_icon_position_tablet'] : ''),
	                (!empty($_s['tabs_icon_position_mobile']) ? 'icon_position-mobile-'.$_s['tabs_icon_position_mobile'] : ''),
                ],
            ]
        );

        ?>
        <div <?php echo $this->get_render_attribute_string( 'tabs' ); ?>>

            <div class="wgl-tabs_headings"><?php
                foreach ( $_s[ 'tabs_tab' ] as $index => $item ) :

                    $tab_count = $index + 1;
                    $tab_title_key = $this->get_repeater_setting_key( 'tabs_tab_title', 'tabs_tab', $index );
                    $this->add_render_attribute(
                        $tab_title_key,
                        [
                            'data-tab-id' => 'wgl-tab_' . $id_int . $tab_count,
                            'class' => [ 'wgl-tabs_header' ],
                        ]
                    );

                    ?>
                    <<?php echo $_s[ 'tabs_title_tag' ]; ?> <?php echo $this->get_render_attribute_string( $tab_title_key ); ?>>
                        <span class="wgl-tabs_title"><?php echo $item[ 'tabs_tab_title' ] ?></span>

                        <?php
                        // Tab Icon/image
                        if ( $item[ 'tabs_tab_icon_type' ] != '' ) {
                            if ( $item[ 'tabs_tab_icon_type' ] == 'font' && (!empty( $item[ 'tabs_tab_icon_fontawesome' ] )) ) {

                                $icon_font = $item[ 'tabs_tab_icon_fontawesome' ];
                                $icon_out = '';
                                // add icon migration
                                $migrated = isset( $item['__fa4_migrated'][$item[ 'tabs_tab_icon_fontawesome' ]] );
                                $is_new = Icons_Manager::is_migration_allowed();
                                if ( $is_new || $migrated ) {
                                    ob_start();
                                    Icons_Manager::render_icon( $item[ 'tabs_tab_icon_fontawesome' ], [ 'aria-hidden' => 'true' ] );
                                    $icon_out .= ob_get_clean();
                                } else {
                                    $icon_out .= '<i class="icon '.esc_attr($icon_font).'"></i>';
                                }

                                ?>
                                <span class="wgl-tabs_icon">
                                    <?php
                                        echo $icon_out;
                                    ?>
                                </span>
                                <?php
                             }
                            if ($item['tabs_tab_icon_type'] == 'image' && !empty($item['tabs_tab_icon_thumbnail'])) {
                                if (!empty($item['tabs_tab_icon_thumbnail']['url'])) {
                                    $this->add_render_attribute('thumbnail', 'src', $item['tabs_tab_icon_thumbnail']['url']);
                                    $this->add_render_attribute('thumbnail', 'alt', Control_Media::get_image_alt($item['tabs_tab_icon_thumbnail']));
                                    $this->add_render_attribute('thumbnail', 'title', Control_Media::get_image_title($item['tabs_tab_icon_thumbnail']));
                                    ?>
                                    <span class="wgl-tabs_icon wgl-tabs_icon-image">
                                    <?php
                                        echo Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'tabs_tab_icon_thumbnail');
                                    ?>
                                    </span>
                                    <?php
                                }
                            }
                        }
                        // End Tab Icon/image
                        ?>

                    </<?php echo $_s[ 'tabs_title_tag' ]; ?>>

                <?php endforeach;?>
            </div>

            <div class="wgl-tabs_content-wrap"><?php
                foreach ( $_s[ 'tabs_tab' ] as $index => $item ) :

                    $tab_count = $index + 1;
                    $tab_content_key = $this->get_repeater_setting_key( 'tab_content', 'tabs_tab', $index );
                    $this->add_render_attribute(
                        $tab_content_key,
                        [
                            'data-tab-id' => 'wgl-tab_' . $id_int . $tab_count,
                            'class' => [ 'wgl-tabs_content' ],
                        ]
                    );

                    ?>
                    <div <?php echo $this->get_render_attribute_string( $tab_content_key ); ?>>
                    <?php
                        if ( $item[ 'tabs_content_type' ] == 'content' ) {
                            echo do_shortcode( $item[ 'tabs_content' ] );
                        } else if ( $item[ 'tabs_content_type' ] == 'template' ) {
                            $id = $item[ 'tabs_content_templates' ];
                            $wgl_frontend = new Frontend;
                            echo $wgl_frontend->get_builder_content_for_display( $id, false );
                        }
                    ?>
                    </div>

                <?php endforeach; ?>
            </div>

        </div>
        <?php
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
