<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-time-line-vertical.php.
*/
namespace WglAddons\Widgets;

defined('ABSPATH') || exit;

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Control_Media,
    Group_Control_Border,
    Group_Control_Box_Shadow,
    Group_Control_Typography,
    Utils,
    Repeater
};

class Wgl_Time_Line_Vertical extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-time-line-vertical';
    }

    public function get_title()
    {
        return esc_html__('Wgl Time Line Vertical', 'atlets-core');
    }

    public function get_icon()
    {
        return 'wgl-time-line-vertical';
    }

    public function get_categories()
    {
        return ['wgl-extensions'];
    }

    public function get_script_depends()
    {
        return ['appear'];
    }

	protected function register_controls() {
		$primary_color = esc_attr( \Atlets_Theme_Helper::get_option( 'theme-primary-color' ) );
		$tertiary_color = esc_attr( \Atlets_Theme_Helper::get_option( 'theme-tertiary-color' ) );
		$header_font_color = esc_attr( \Atlets_Theme_Helper::get_option( 'header-font' )['color'] );
		$main_font_color   = esc_attr( \Atlets_Theme_Helper::get_option( 'main-font' )['color'] );

		/* Start General Settings Section */
		$this->start_controls_section( 'wgl_time_line_section',
			array(
				'label' => esc_html__( 'General Settings', 'atlets-core' ),
			)
		);

		$this->add_control(
			'add_appear',
			array(
				'label' => esc_html__( 'Add Appear Animation', 'atlets-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'atlets-core' ),
				'label_off' => esc_html__( 'Off', 'atlets-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			)
		);

		$this->add_control( 'start_image',
			array(
				'label' => esc_html__( 'Time Line Start Image', 'atlets-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'custom' => 'Custom',
					'none' => 'None',
				],
			)
		);

		$this->add_control( 'start_image_thumb',
			array(
				'label' => esc_html__( 'Thumbnail', 'atlets-core' ),
				'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
				'condition' => [
					'start_image' => 'custom'
				],
			)
		);

		$this->add_responsive_control(
			'start_image_margin',
			array(
				'label' => esc_html__( 'Image Margin', 'atlets-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .time_line-start_image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'start_image' => 'custom'
				]
			)
		);

		$this->add_control(
			'line_color',
			array(
				'label' => esc_html__( 'Line Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => '#e7e6e2',
				'selectors' => array(
					'{{WRAPPER}} .time_line-curve svg' => 'stroke: {{VALUE}};',
					'{{WRAPPER}} .time_line-curve:before' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		/* Start General Settings Section */
		$this->start_controls_section( 'content_section',
			array(
				'label' => esc_html__( 'Content Settings', 'atlets-core' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'thumbnail',
			array(
				'label' => esc_html__( 'Thumbnail', 'atlets-core' ),
				'type' => Controls_Manager::MEDIA,
			    'dynamic' => [  'active' => true],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label' => esc_html__( 'Title', 'atlets-core' ),
				'type' => Controls_Manager::TEXTAREA,
			    'dynamic' => [  'active' => true],
				'default' => esc_html__( 'This is the heading', 'atlets-core' ),
				'placeholder' => esc_html__( 'This is the heading', 'atlets-core' ),
			)
		);

		$repeater->add_control(
			'content',
			array(
				'label' => esc_html__( 'Content', 'atlets-core' ),
				'type' => Controls_Manager::WYSIWYG,
			    'dynamic' => [  'active' => true],
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Optio, neque qui velit. Magni dolorum quidem ipsam eligendi, totam, facilis laudantium cum accusamus ullam voluptatibus commodi numquam, error, est. Ea, consequatur.', 'atlets-core' ),
			)
		);

		$repeater->add_control(
			'date',
			array(
				'label' => esc_html__( 'Date', 'atlets-core' ),
				'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
			)
		);

		$this->add_control(
			'items',
			array(
				'label' => esc_html__( 'Layers', 'atlets-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[ 'title' => esc_html__( 'This is the heading', 'atlets-core' ) ],
					[ 'title' => esc_html__( 'This is the heading', 'atlets-core' ) ],
				],
				'title_field' => '{{title}}',
			)
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  Style Section
		/*-----------------------------------------------------------------------------------*/

		//Image Styles

		$this->start_controls_section(
			'media_style_section',
			array(
				'label' => esc_html__( 'Image', 'atlets-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'media_bg_color',
			array(
				'label' => esc_html__( 'Background Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $tertiary_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-media' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'image_size',
			array(
				'label' => esc_html__( 'Image Size', 'atlets-core' ),
				'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
				'range' => [
					'px' => [
						'min' => 290,
						'max' => 500,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'size' => '300',
					'unit' => 'px',
				],
				'tablet_default'  => [
					'size' => '300',
					'unit' => 'px',
				],
				'mobile_default'  => [
					'size' => '100',
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .time_line-media_wrapper' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			)
		);

		$this->add_responsive_control(
			'bg_position',
			array(
				'label' => esc_html_x( 'Background Position for Image', 'Background Control', 'atlets-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'center center',
				'responsive' => true,
				'options' => [
					'top left' => esc_html_x( 'Top Left', 'Background Control', 'atlets-core' ),
					'top center' => esc_html_x( 'Top Center', 'Background Control', 'atlets-core' ),
					'top right' => esc_html_x( 'Top Right', 'Background Control', 'atlets-core' ),
					'center left' => esc_html_x( 'Center Left', 'Background Control', 'atlets-core' ),
					'center center' => esc_html_x( 'Center Center', 'Background Control', 'atlets-core' ),
					'center right'  => esc_html_x( 'Center Right', 'Background Control', 'atlets-core' ),
					'bottom left' => esc_html_x( 'Bottom Left', 'Background Control', 'atlets-core' ),
					'bottom center' => esc_html_x( 'Bottom Center', 'Background Control', 'atlets-core' ),
					'bottom right'  => esc_html_x( 'Bottom Right', 'Background Control', 'atlets-core' ),
				],
                'selectors' => [
                    '{{WRAPPER}} .time_line-media' => 'background-position: {{VALUE}};',
                ],
			)
		);

		$this->start_controls_tabs(
			'media_colors'
		);

		$this->start_controls_tab(
			'media_colors_normal',
			[
				'label' => esc_html__( 'Normal', 'atlets-core' ),
			]
		);

		$this->add_control(
			'media_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => '#e7e6e2',
				'selectors' => array(
					'{{WRAPPER}} .time_line-media_wrapper' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'media_colors_hover',
			[
				'label' => esc_html__( 'Hover', 'atlets-core' ),
			]
		);

		$this->add_control(
			'media_hover_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $primary_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-item:hover .time_line-media_wrapper' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		//Title Styles

		$this->start_controls_section(
			'title_style_section',
			array(
				'label' => esc_html__( 'Title', 'atlets-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .time_line-title',
			)
		);

		$this->start_controls_tabs(
			'title_colors'
		);

		$this->start_controls_tab(
			'title_colors_normal',
			[
				'label' => esc_html__( 'Normal', 'atlets-core' ),
			]
		);

		$this->add_control(
			'title_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $header_font_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-title' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_colors_hover',
			[
				'label' => esc_html__( 'Hover', 'atlets-core' ),
			]
		);

		$this->add_control(
			'title_hover_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $primary_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-item:hover .time_line-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .time_line-item:hover .time_line-pointer:before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		// Content Styles

		$this->start_controls_section(
			'content_style_section',
			array(
				'label' => esc_html__( 'Content', 'atlets-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name' => 'content_typo',
                'selector' => '{{WRAPPER}} .time_line-text',
			)
		);

		$this->add_control(
			'content_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $main_font_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-text' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'content_bg_color',
			array(
				'label' => esc_html__( 'Background Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .time_line-content' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'content_border_radius',
			array(
				'label' => esc_html__( 'Border Radius', 'atlets-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default' => [
					'top' => 15,
					'right'  => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .time_line-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],

			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'content_border',
				'selector' => '{{WRAPPER}} .time_line-content',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'content_shadow',
				'selector' => '{{WRAPPER}} .time_line-content',
			]
		);

		$this->end_controls_section();

		// Date Styles

		$this->start_controls_section(
			'date_style_section',
			array(
				'label' => esc_html__( 'Date', 'atlets-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name' => 'date_typo',
				'selector' => '{{WRAPPER}} .time_line-date',
			)
		);

		$this->start_controls_tabs(
			'date_colors'
		);

		$this->start_controls_tab(
			'date_colors_normal',
			[
				'label' => esc_html__( 'Normal', 'atlets-core' ),
			]
		);

		$this->add_control(
			'date_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => $primary_color,
				'selectors' => array(
					'{{WRAPPER}} .time_line-date' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'date_colors_hover',
			[
				'label' => esc_html__( 'Hover', 'atlets-core' ),
			]
		);

		$this->add_control(
			'date_hover_color',
			array(
				'label' => esc_html__( 'Color', 'atlets-core' ),
				'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
				'default' => '#f4f6f6',
				'selectors' => array(
					'{{WRAPPER}} .time_line-item:hover .time_line-date' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

    protected function render()
    {
		wp_enqueue_script('appear', get_template_directory_uri() . '/js/jquery.appear.js');

		$_s = $this->get_settings_for_display();

        $kses_allowed_html = [
            'a' => [
                'id' => true, 'class' => true, 'style' => true,
                'href' => true, 'title' => true,
                'rel' => true, 'target' => true,
            ],
            'br' => ['id' => true, 'class' => true, 'style' => true],
            'em' => ['id' => true, 'class' => true, 'style' => true],
            'strong' => ['id' => true, 'class' => true, 'style' => true],
            'span' => ['id' => true, 'class' => true, 'style' => true],
            'p' => ['id' => true, 'class' => true, 'style' => true],
            'ul' => ['id' => true, 'class' => true, 'style' => true],
            'ol' => ['id' => true, 'class' => true, 'style' => true],
            'li' => ['id' => true, 'class' => true, 'style' => true],
        ];

		$this->add_render_attribute('timeline-vertical', [
			'class' => [
				'wgl-timeline-vertical',
				'start-' . $_s['start_image'],
				( (bool) $_s['add_appear'] ? 'appear_anim' : '' ),
			],
		]);

        $this->add_render_attribute('start_image', [
            'class' => 'start_image',
            'alt' => Control_Media::get_image_alt($_s['start_image_thumb']),
        ]);
        empty($_s['start_image_thumb']['url']) || $this->add_render_attribute('start_image', 'src', esc_url($_s['start_image_thumb']['url']));

		$curve_svg = '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 65.8 167.9" style="enable-background:new 0 0 65.8 167.9;">
            <path d="M8,167.5c-4.2-13.8-6.5-28.5-6.5-43.7C1.5,73.2,26.6,28.4,65,1.2"/>
        </svg>';

		?>
    <div <?php echo $this->get_render_attribute_string( 'timeline-vertical' ); ?>>

        <div class="time_line-start_image">
            <div class="time_line-curve"><?php echo $curve_svg; ?></div><?php
			if ( $_s['start_image'] == 'custom' ) { ?>
                <img <?php echo $this->get_render_attribute_string( 'start_image' ); ?> /><?php
			} ?>
        </div>

        <div class="time_line-items_wrap"><?php

			foreach ($_s['items'] as $index => $item) {

				$media = $this->get_repeater_setting_key( 'media', 'items', $index );
				$this->add_render_attribute( $media, [
					'class' => 'time_line-media',
					'style' => [
						( ! empty( $item['thumbnail']['url'] ) ? 'background-image: url(' . esc_url( $item['thumbnail']['url'] ) . ');' : '' ),
					]
				] );

				$title = $this->get_repeater_setting_key( 'title', 'items', $index );
				$this->add_render_attribute( $title, [
					'class' => [
						'time_line-title',
					],
				] );

				$item_wrap = $this->get_repeater_setting_key( 'item_wrap', 'items', $index );
				$this->add_render_attribute( $item_wrap, [
					'class' => [
						'time_line-item',
					],
				] );

				?>
                <div <?php echo $this->get_render_attribute_string( $item_wrap ); ?>><?php
				if ( ! empty( $item['date'] ) ) {
					?>
                    <div class="time_line-date"><?php echo $item['date'] ?></div><?php
				} ?>
                <div class="time_line-media_wrapper">
                    <div <?php echo $this->get_render_attribute_string( $media ); ?>></div>
                </div>
                <div class="time_line-content"><?php
					if ( ! empty( $item['content'] ) || ! empty( $item['title'] ) ) {
						if ( ! empty( $item['title'] ) ) { ?>
                            <h3 <?php echo $this->get_render_attribute_string( $title ); ?>><?php echo $item['title'] ?></h3><?php
						}
						if ( ! empty( $item['content'] ) ) {
							?>
                            <div class="time_line-text"><?php echo wp_kses( $item['content'], $kses_allowed_html ); ?></div><?php
						}
					} ?>
                </div>
                <div class="time_line-curve"><?php echo $curve_svg; ?></div>
                </div><?php
			} ?>
        </div>
        </div><?php

	}

	public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}