<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-video-popup.php.
*/
namespace WglAddons\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Embed;


class Wgl_Video_Popup extends Widget_Base
{

    public function get_name() {
        return 'wgl-video-popup';
    }

    public function get_title() {
        return esc_html__('WGL Video Popup', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-video-popup';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }


    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> GENERAL
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_video_popup_section',
            [ 'label' => esc_html__('General', 'atlets-core') ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('Video Link', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'description' => esc_html__('Link from youtube or vimeo.', 'atlets-core'),
                'separator' => 'after',
                'label_block' => true,
                'placeholder' => esc_html__('Your URL', 'atlets-core'),
                'default' => 'https://www.youtube.com/watch?v=TKnufs85hXk',
            ]
        );

        $this->add_control(
            'title_pos',
            [
                'label' => esc_html__('Title Position', 'atlets-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'top' => [
                        'title' => esc_html__('Top', 'atlets-core'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'bot' => [
                        'title' => esc_html__('Bottom', 'atlets-core'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-h-align-left',
                    ],

                ],
                'label_block' => false,
                'default' => 'bot',
                'toggle' => true,
            ]
        );

        $this->add_responsive_control(
            'button_pos',
            [
                'label' => esc_html__( 'Alignment', 'atlets-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'atlets-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'atlets-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'atlets-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'inline' => [
                        'title' => esc_html__('Inline', 'atlets-core'),
                        'icon' => 'eicon-h-align-stretch',
                    ],
                ],
                'default' => 'center',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  CONTENT -> ANIMATION
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_content_animation',
            [
                'label' => esc_html__('Animation', 'atlets-core'),
                'condition' => [ 'title!' => '' ],
            ]
        );

        $this->add_control(
            'animation_style',
            [
                'label' => esc_html__('Animation Style', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'separator' => 'before',
                'options' => [
                    '' => esc_html__('No animation', 'atlets-core'),
                    'ring_static' => esc_html__('Static Ring', 'atlets-core'),
                    'ring_pulse' => esc_html__('Pulsing Ring', 'atlets-core'),
                    'circles' => esc_html__('Divergent Rings', 'atlets-core'),
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'anim_color',
            [
                'label' => esc_html__('Animation Element Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'condition' => [ 'animation_style!' => '' ],
                'default' => $primary_color,
                'selectors' => [
                    '{{WRAPPER}} .videobox_animation' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .animation_ring_pulse .videobox_animation' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'always_run_animation',
            [
                'label' => esc_html__('Run Animation Until Hover', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'animation_style!' => ['', 'ring_static']
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> TITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'title!' => '' ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Padding', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $h_font_color,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'atlets-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => '‹h1›',
                    'h2' => '‹h2›',
                    'h3' => '‹h3›',
                    'h4' => '‹h4›',
                    'h5' => '‹h5›',
                    'h6' => '‹h6›',
                    'div' => '‹div›',
                ],
                'default' => 'h3',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> BUTTON
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_button',
            [
                'label' => esc_html__('Button', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__('Margin', 'atlets-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .videobox_link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_size',
            [
                'label' => esc_html__('Button Size', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [ 'max' => 200 ],
                ],
                'default' => [ 'size' => 70, 'unit' => 'px' ],
                'description' => esc_html__('Button diameter in pixels.', 'atlets-core'),
                'selectors' => [
                    '{{WRAPPER}} .videobox_link' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'item_color_tab' );

        $this->start_controls_tab(
            'custom_item_color_normal',
            [ 'label' => esc_html__('Normal' , 'atlets-core') ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_color',
                'label' => esc_html__('Button Background', 'atlets-core'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .videobox_link',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color' => [ 'default' => $primary_color ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => esc_html__('Border Type', 'atlets-core'),
                'selector' => '{{WRAPPER}} .videobox_link',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow',
                'selector' => '{{WRAPPER}} .videobox_link',
            ]
        );

	    $this->add_control(
		    'triangle_color',
		    [
			    'label' => esc_html__('Triangle Color', 'atlets-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
			    'default' => '#ffffff',
			    'selectors' => [
				    '{{WRAPPER}} .videobox_icon' => 'fill: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'custom_item_color_hover',
            [ 'label' => esc_html__('Hover', 'atlets-core') ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_color_hover',
                'label' => esc_html__('Button Background', 'atlets-core'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .videobox_link:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'label' => esc_html__('Border Type', 'atlets-core'),
                'selector' => '{{WRAPPER}} .videobox_link:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_hover',
                'selector' => '{{WRAPPER}} .videobox_link:hover',
            ]
        );

	    $this->add_control(
		    'triangle_color_hover',
		    [
			    'label' => esc_html__('Triangle Color', 'atlets-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
			    'default' => '#ffffff',
			    'selectors' => [
				    '{{WRAPPER}} .videobox_link:hover .videobox_icon' => 'fill: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'triangle_size',
            [
                'label' => esc_html__('Triangle Size', 'atlets-core'),
                'type' => Controls_Manager::SLIDER,
			    'dynamic' => [  'active' => true],
                'separator' => 'before',
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => ['max' => 100],
                ],
                'default' => ['size' => 27, 'unit' => '%'],
                'selectors' => [
                    '{{WRAPPER}} .videobox_icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'triangle_corners',
            [
                'label' => esc_html__('Triangle Rounded Corners', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $_s = $this->get_settings_for_display();
        $animated_element = '';

        $this->add_render_attribute('video-wrap', 'class', [
            'wgl-video_popup',
            'button_align-'.$_s['button_pos'],
            $_s[ 'animation_style' ] ? 'animation_' . $_s['animation_style'] : '',
            'title_pos-'.$_s[ 'title_pos' ],
            !empty($_s['bg_image']['url']) ? 'with_image' : '',
            $_s['always_run_animation'] ? 'idle-animation' : '',
        ]);

        // Animation element
        switch ($_s['animation_style']) {
            case 'circles':
                $animated_element .= '<div class="videobox_animation circle_1"></div>';
                $animated_element .= '<div class="videobox_animation circle_2"></div>';
                $animated_element .= '<div class="videobox_animation circle_3"></div>';
                break;
            case 'ring_pulse':
            case 'ring_static':
                $animated_element .= '<div class="videobox_animation"></div>';
                break;
        }

        // Triangle svg
        switch ($_s['triangle_corners']) {
            default:
            case false:
                $triangle_svg = '<svg class="videobox_icon" viewBox="0 0 10 10"><polygon points="1,0 1,10 9,5"/></svg>';
                break;
            case true:
                $triangle_svg = '<svg class="videobox_icon" viewBox="0 0 232 232"><path d="M203,99L49,2.3c-4.5-2.7-10.2-2.2-14.5-2.2 c-17.1,0-17,13-17,16.6v199c0,2.8-0.07,16.6,17,16.6c4.3,0,10,0.4,14.5-2.2 l154-97c12.7-7.5,10.5-16.5,10.5-16.5S216,107,204,100z"/></svg>';
                break;
        }

        // Render
        echo '<div ', $this->get_render_attribute_string('video-wrap'), '>';
        echo '<div class="videobox_content">';
            if (!empty($_s['bg_image']['url'])) {
                echo '<div class="videobox_background">',
                    wp_get_attachment_image($_s['bg_image']['id'], 'full'),
                '</div>',
                '<div class="videobox_link_wrapper">';
            }
            if (!empty($_s['title'])) {
                echo '<', $_s['title_tag'], ' class="title">',
                    esc_html__($_s['title']),
                '</', $_s['title_tag'], '>';
            }

            $lightbox_url = Embed::get_embed_url( $_s['link'], [], [] );

            $lightbox_options = [
                'type' => 'video',
                'url' => $lightbox_url,
                'modalOptions' => [
                    'id' => 'elementor-lightbox-' . $this->get_id(),
                ],
            ];

            $this->add_render_attribute( 'video-lightbox', [
                'class' => 'videobox_link videobox',
                'data-elementor-open-lightbox' => 'yes',
                'data-elementor-lightbox' =>  wp_json_encode( $lightbox_options ),
            ] );

            echo '<div ', $this->get_render_attribute_string( 'video-lightbox' ) , '>';
                echo $triangle_svg;
                echo $animated_element;
            echo '</div>';
            if (!empty($_s['bg_image']['url'])) {
                echo '</div>';
            }
        echo '</div>'; // videobox_content
        echo '</div>';

    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}