<?php
/*
 * This template can be overridden by copying it to yourtheme/atlets-core/elementor/widgets/wgl-working-hours.php.
*/
namespace WglAddons\Widgets;

use WglAddons\Includes\Wgl_Icons;
use WglAddons\Includes\Wgl_Carousel_Settings;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;


defined( 'ABSPATH' ) || exit; // Abort, if called directly.

class Wgl_Working_Hours extends Widget_Base {

    public function get_name() {
        return 'wgl-working-hours';
    }

    public function get_title() {
        return esc_html__('WGL Working Hours', 'atlets-core');
    }

    public function get_icon() {
        return 'wgl-working-hours';
    }

    public function get_categories() {
        return [ 'wgl-extensions' ];
    }

    public function get_script_depends() {
        return [ 'jquery-appear' ];
    }



    protected function register_controls()
    {
        $primary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-primary-color'));
        $secondary_color = esc_attr(\Atlets_Theme_Helper::get_option('theme-secondary-color'));
        $h_font_color = esc_attr(\Atlets_Theme_Helper::get_option('header-font')['color']);
        $main_font_color = esc_attr(\Atlets_Theme_Helper::get_option('main-font')['color']);

        /*-----------------------------------------------------------------------------------*/
        /*  Content
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'wgl_working_section',
            [ 'label' => esc_html__('Content', 'atlets-core') ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'working_day',
            [
                'label' => esc_html__('Day', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'default' => esc_html__('Monday', 'atlets-core'),
            ]
        );

        $repeater->add_control(
            'working_hours',
            [
                'label' => esc_html__('Hours', 'atlets-core'),
                'type' => Controls_Manager::TEXT,
			    'dynamic' => [  'active' => true],
                'default' => esc_html__('8.00 - 21.00', 'atlets-core'),
            ]
        );

        $repeater->add_control(
            'custom_colors',
            [
                'label' => esc_html__('Custom Colors', 'atlets-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'atlets-core'),
                'label_off' => esc_html__('Off', 'atlets-core'),
            ]
        );

        $repeater->add_control(
            'day_color',
            [
                'label' => esc_html__('Day Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $main_font_color,
                'condition' => [ 'custom_colors' => 'yes' ],
            ]
        );

        $repeater->add_control(
            'hours_color',
            [
                'label' => esc_html__('Hours Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $secondary_color,
                'condition' => [ 'custom_colors' => 'yes' ],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Days', 'atlets-core'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'working_day' => esc_html__('Monday', 'atlets-core')],
                    [ 'working_day' => esc_html__('Tuesday', 'atlets-core')],
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{working_day}}',
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  Style Section
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Styles', 'atlets-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_styles',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Item Styles', 'atlets-core'),
            ]
        );

        $this->add_responsive_control(
			'item_margin',
			[
				'label' => esc_html__('Margin', 'atlets-core'),
				'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'after',
				'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => 0,
                    'left' => 0,
                    'right' => 0,
                    'bottom' => 6,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .working-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_control(
            'day_styles',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Day Styles', 'atlets-core'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'day_typo',
                'selector' => '{{WRAPPER}} .working-item_day',
            ]
        );

        $this->add_control(
            'day_color',
            [
                'label' => esc_html__('Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $main_font_color,
                'selectors' => [
                    '{{WRAPPER}} .working-item_day' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'day_margin',
			[
				'label' => esc_html__('Margin', 'atlets-core'),
				'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'after',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .working-item_day' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            'hours_styles',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Hours Styles', 'atlets-core'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'hours_typo',
                'selector' => '{{WRAPPER}} .working-item_hours',
            ]
        );

        $this->add_control(
            'hours_color',
            [
                'label' => esc_html__('Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => $secondary_color,
                'selectors' => [
                    '{{WRAPPER}} .working-item_hours' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'hours_margin',
			[
				'label' => esc_html__('Margin', 'atlets-core'),
				'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'after',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .working-item_hours' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
        );

        $this->add_control(
            'line_color',
            [
                'label' => esc_html__('Line Between Color', 'atlets-core'),
                'type' => Controls_Manager::COLOR,
			    'dynamic' => [  'active' => true],
                'default' => '#e5e5e5',
                'selectors' => [
                    '{{WRAPPER}} .working-item:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'working-hours', [
			'class' => [
                'wgl-working-hours',
            ],
        ] );

        ?><div <?php echo $this->get_render_attribute_string( 'working-hours' ); ?>><?php

        foreach ( $settings[ 'items' ] as $index => $item ) {

            $working_day = $this->get_repeater_setting_key( 'working_day', 'items' , $index );
            $this->add_render_attribute( $working_day, [
                'class' => [
                    'working-item_day',
                ],
                'style' => [
                    ((bool)$item[ 'custom_colors' ] ? 'color: '.esc_attr($item[ 'day_color' ]).';' : '' ),
                ]
            ] );

            $working_hours = $this->get_repeater_setting_key( 'working_hours', 'items' , $index );
            $this->add_render_attribute( $working_hours, [
                'class' => [
                    'working-item_hours',
                ],
                'style' => [
                    ((bool)$item[ 'custom_colors' ] ? 'color: '.esc_attr($item[ 'hours_color' ]).';' : '' ),
                ]
            ] );

            ?>
            <div class="working-item"><?php
                if (!empty($item[ 'working_day' ])) {
                    ?><div <?php echo $this->get_render_attribute_string( $working_day ); ?>><?php echo esc_html($item[ 'working_day' ]); ?></div><?php
                }
                if (!empty($item[ 'working_hours' ])) {
                    ?><div <?php echo $this->get_render_attribute_string( $working_hours ); ?>><?php echo esc_html($item[ 'working_hours' ]); ?></div><?php
                }?>
            </div><?php

        }

        ?></div><?php

    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WglAddons\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }

}