<?php

defined('ABSPATH') || exit;

use WglAddons\Templates\WglPortfolio;

get_header();

$term_id = get_queried_object()->term_id ?? '';

// Show Filter Options
$show_filter = Atlets_Theme_Helper::get_option('portfolio_list_show_filter');
$list_terms = Atlets_Theme_Helper::get_option('portfolio_list_filter_cats');

if (!$term_id) $show_filter = '';

if (!empty($show_filter) && !empty($list_terms)) {
    $term_id = $list_terms;
}
$term_slug = [];
$cat_title = $cat_descr = '';

$tax = get_queried_object()->taxonomy ?? ''; // get taxonomies

if (!empty($term_id)) {
    $return = '';
    if (is_array($term_id)) {
        $count = count($term_id);
        $i = 0;
        foreach ($term_id as $value) {
            $item = get_term_by('id', (int) $value, $tax);
            $i++;
            $return .= $tax . $item->slug . ($i !== $count ? ', ' : '');
        }
    } else {
        $return = get_term_by('id', $term_id, $tax);
        $return = $tax . ":" . $return->slug;
    }
    $term_slug[] = $return;
    $cat = get_term_by('id', (int) $term_id, $tax);
    $cat_title = $cat->name;
    $cat_descr = $cat->description;
}

$defaults = [
    'portfolio_layout' => 'masonry',
    'link_destination' => 'single',
    'linked_image' => true,
    'linked_title' => true,
    'add_animation' => null,
    'navigation' => 'pagination',
    'nav_align' => 'center',
    'posts_per_row' => Atlets_Theme_Helper::get_option('portfolio_list_columns'),
    'show_portfolio_title' => Atlets_Theme_Helper::get_option('portfolio_list_show_title'),
    'show_meta_categories' => Atlets_Theme_Helper::get_option('portfolio_list_show_cat'),
    'show_content' => Atlets_Theme_Helper::get_option('portfolio_list_show_content'),
    'show_filter' => $show_filter,
    'filter_align' => 'left',
    'crop_images' => 'yes',
    'items_load' => '4',
    'grid_gap' => '30px',
    'info_position' => 'inside_image',
    'image_anim' => 'sub_layer',
    'gallery_mode' => false,
    'img_size_string' => '580x580',
    'img_size_array' => '',
    'img_aspect_ratio' => '',
    // Query
    'number_of_posts' => '12',
    'order_by' => 'menu_order',
    'order' => 'DSC',
    'post_type' => 'portfolio',
    'taxonomies' => $term_slug,
];
extract($defaults);

$sb = Atlets_Theme_Helper::render_sidebars('portfolio_list');
$row_class = $sb['row_class'];
$column = $sb['column'];
$container_class = $sb['container_class'];

// Render
echo '<div class="wgl-container', apply_filters('atlets_container_class', $container_class), '">';
    echo '<div class="row', apply_filters('atlets_row_class', $row_class), '">';
        echo '<div id="main-content" class="wgl_col-', apply_filters('atlets_column_class', $column), '">';
            if (!empty($term_id)) {
                echo '<div class="portfolio_archive-cat">',
                    '<h4 class="portfolio_archive-cat_title">',
                        get_the_archive_title(),
                    '</h4>',
                    '<div class="portfolio_archive-cat_descr">',
                        esc_html($cat_descr),
                    '</div>',
                '</div>';
            }
            $portfolio_render = new WglPortfolio();
            echo $portfolio_render->render($defaults);
        echo '</div>';

        // Sidebar
        echo !empty($sb['content']) ? $sb['content'] : '';

    echo '</div>';
echo '</div>';

get_footer();
