<?php

defined('ABSPATH') || exit;

use WglAddons\Templates\WglPortfolio;

get_header();

$sb = Atlets_Theme_Helper::render_sidebars('portfolio_single');
$row_class = $sb['row_class'];
$column = $sb['column'];
$container_class = $sb['container_class'];

$defaults = [
    'posts_per_row' => '1',
    'portfolio_layout' => '',
    'portfolio_icon_pack' => '',
];

// HTML allowed for rendering
$allowed_html = [
    'a' => [
        'href' => true, 'title' => true,
        'target' => true, 'rel' => true,
        'class' => true, 'style' => true
    ],
    'br' => ['class' => true, 'style' => true],
    'b' => ['class' => true, 'style' => true],
    'em' => ['class' => true, 'style' => true],
    'strong' => ['class' => true, 'style' => true]
];

$item = new WglPortfolio();

echo '<div class="wgl-portfolio-single_wrapper">';
  echo '<div class="wgl-container single_portfolio', apply_filters('atlets_container_class', $container_class), '">';
    echo '<div class="row', apply_filters('atlets_row_class', $row_class), '">';
        echo '<div id="main-content" class="wgl_col-', apply_filters('atlets_column_class', $column), '">';

            while (have_posts()) :
                the_post();
                echo $item->wgl_portfolio_single_item($defaults, $item_class = '');
            endwhile;
            wp_reset_postdata();

            // Navigation
            get_template_part('templates/post/post-navigation');

            // Related
            $related_switch = Atlets_Theme_Helper::get_option('portfolio_related_switch');
            if (class_exists('RWMB_Loader')) {
                $mb_related_switch = rwmb_meta('mb_portfolio_related_switch');
                if ($mb_related_switch == 'on') {
                    $related_switch = true;
                } elseif ($mb_related_switch == 'off') {
                    $related_switch = false;
                }
            }

            if ($related_switch
                && class_exists('Atlets_Core')
                && class_exists('Elementor\Plugin')
            ) :
                $mb_pf_cat_r = [];

                $mb_pf_carousel_r = Atlets_Theme_Helper::get_mb_option('pf_carousel_r', 'mb_portfolio_related_switch', 'on');
                $mb_pf_title_r = Atlets_Theme_Helper::get_mb_option('pf_title_r', 'mb_portfolio_related_switch', 'on');
                $mb_pf_column_r = Atlets_Theme_Helper::get_mb_option('pf_column_r', 'mb_portfolio_related_switch', 'on');
                $mb_pf_number_r = Atlets_Theme_Helper::get_mb_option('pf_number_r', 'mb_portfolio_related_switch', 'on');
                $mb_pf_number_r = !empty($mb_pf_number_r) ? $mb_pf_number_r : '12';

                if (class_exists('RWMB_Loader')) {
                    $mb_pf_cat_r = get_post_meta(get_the_id(), 'mb_pf_cat_r'); // store terms’ IDs in the post meta and doesn’t set post terms.
                }

                if (!$mb_pf_carousel_r) {
                    wp_enqueue_script('isotope');
                }

                $cats = get_the_terms(get_the_id(), 'portfolio-category') ?: [];
                $cat_slugs = [];
                foreach ($cats as $cat) {
                    $cat_slugs[] = 'portfolio-category:'.$cat->slug;
                }

                if (!empty($mb_pf_cat_r[0])) {
                    $cat_slugs = [];
                    $list = get_terms('portfolio-category', ['include' => $mb_pf_cat_r[0]]);
                    foreach ($list as $value) {
                        $cat_slugs[] = 'portfolio-category:'.$value->slug;
                    }
                }

                $atts = [
                    'portfolio_layout' => 'related',
                    'image_anim' => 'sub_layer',
                    'link_destination' => 'single',
                    'gallery_mode' => false,
                    'linked_title' => 'yes',
                    'linked_image' => 'yes',
                    'add_animation' => '',
                    'show_filter' => '',
                    'info_position' => 'inside_image',
                    'crop_images' => 'yes',
                    'show_portfolio_title' => 'true',
                    'show_meta_categories' => 'true',
                    'show_content' => '',
                    'grid_gap' => '30px',
                    'featured_render' => '1',
                    'items_load' => $mb_pf_column_r,
                    'img_size_string' => '740x740',
                    'img_size_array' => '',
                    'img_aspect_ratio' => '',
                    // Carousel
                    'autoplay' => true,
                    'autoplay_speed' => '5000',
                    'c_infinite_loop' => true,
                    'c_slide_per_single' => 1,
                    'mb_pf_carousel_r' => $mb_pf_carousel_r,
                    'posts_per_row' => $mb_pf_column_r,
                    'use_pagination' => false,
                    'arrows_center_mode' => '',
                    'center_info' => '',
                    'use_prev_next' => '',
                    'center_mode' => '',
                    'variable_width' => '',
                    'navigation' => '',
                    'pag_type' => 'circle',
                    'pag_offset' => '',
                    'pag_color' => '',
                    'custom_resp' => true,
                    'resp_medium' => '',
                    'custom_pag_color' => '',
                    'resp_tablets_slides' => '',
                    'resp_tablets' => '',
                    'resp_medium_slides' => '',
                    'resp_mobile' => '600',
                    'resp_mobile_slides'=> '1',
                    // Query
                    'number_of_posts' => $mb_pf_number_r,
                    'order_by' => 'menu_order',
                    'post_type' => 'portfolio',
                    'taxonomies' => $cat_slugs,
                ];
                $featured_render = new WglPortfolio();

                $featured_post = $featured_render->render($atts);
                if ($featured_render->post_count > 0) {
                    echo '<section class="related_portfolio">';
                        if (!empty($mb_pf_title_r)) {
                            echo '<div class="atlets_module_title">',
                                '<h4>', esc_html($mb_pf_title_r), '</h4>',
                            '</div>';
                        }
                        echo $featured_post;
                    echo '</section>';
                }
            endif;

            // Comments
            if (comments_open() || get_comments_number()) {
                echo '<div class="row">';
                    echo '<div class="wgl_col-12">';
                        comments_template('', true);
                    echo '</div>';
                echo '</div>';
            }

        echo '</div>';

        // Sidebar
        echo !empty($sb['content']) ? $sb['content'] : '';

    echo '</div>';
  echo '</div>';
echo '</div>'; // single_wrapper


get_footer();
