<?php

use Atlets_Theme_Helper as Atlets;

/**
* Template for Side Panel CPT single page
*
* @package atlets-core\includes\post-types
* @author WebGeniusLab <webgeniuslab@gmail.com>
* @since 1.0.0
*/

get_header();
the_post();

$sb = Atlets::render_sidebars();
$row_class = $sb['row_class'];
$column = $sb['column'];
$container_class = $sb['container_class'];

?>
<div class="wgl-container<?php echo apply_filters('atlets_container_class', $container_class); ?>">
<div class="row <?php echo apply_filters('atlets_row_class', $row_class); ?>">
    <div id='main-content' class="wgl_col-<?php echo apply_filters('atlets_column_class', $column); ?>">
        <?php

        the_content(esc_html__('Read more!', 'atlets-core'));

        wp_link_pages(array('before' => '<div class="page-link">' . esc_html__('Pages', 'atlets') . ': ', 'after' => '</div>'));

        if (comments_open() || get_comments_number()) {
            comments_template();
        }

    echo '</div>';

    // Sidebar
    if (!empty($sb['content'])) echo $sb['content'];

echo '</div>';
echo '</div>';

get_footer();
