<?php

class WglThemeHelper
{

    protected static $instance = null;

    /**
     * @var \WP_Post
     */
    private $post_id;

    public static function instance()
    {
        if (is_null( self::$instance )) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    private function __construct ()
    {
        $this->post_id = get_the_ID();
    }

    public function render_post_share($show_share)
    {
        $img_url = wp_get_attachment_image_url(get_post_thumbnail_id($this->post_id), 'single-post-thumbnail');

        if ($show_share) :
            ?>
            <!-- post share block -->
            <div class="share_social-wpapper">
                <a class="share_link share_twitter" target="_blank" href="<?php echo esc_url('https://twitter.com/intent/tweet?text='. get_the_title() .'&amp;url='. get_permalink()); ?>"><span class="fab fa-twitter"></span><span class="share_text"><?php echo esc_html__('Twitter', 'atlets-core'); ?></span></a>
                <a class="share_link share_facebook" target="_blank" href="<?php echo  esc_url('https://www.facebook.com/share.php?u='. get_permalink()); ?>"><span class="fab fa-facebook-f"></span><span class="share_text"><?php echo esc_html__('Facebook', 'atlets-core'); ?></span></a>
                <?php
                    if ($img_url) {
                        echo '<a class="share_link share_pinterest" target="_blank" href="'. esc_url('https://pinterest.com/pin/create/button/?url='. get_permalink() .'&media='. $img_url) .'"><span class="fab fa-pinterest-p"></span><span class="share_text">'. esc_html__( "Pinterest", "atlets-core" ).'</span></a>';
                    }
                ?>
                <a class="share_link share_linkedin" href="<?php echo esc_url('http://www.linkedin.com/shareArticle?mini=true&url='.substr(urlencode( get_permalink() ),0,1024));?>&title=<?php echo esc_attr(substr(urlencode(html_entity_decode(get_the_title())),0,200));?>" target="_blank" ><span class="fab fa-linkedin-in fa-linkedin"></span><span class="share_text"><?php echo esc_html__('Linkedin', 'atlets-core'); ?></span></a>
            </div>
            <!-- //post share block -->
            <?php
        endif;
    }

    public function render_post_list_share() {?>
        <div class="share_post-container">
            <div class="share_social-wpapper">
                <ul>
                    <li>
                    <?php echo '<a class="share_post share_twitter"',
                            ' target="_blank"',
                            ' href="', esc_url('https://twitter.com/intent/tweet?text=' . get_the_title() . '&amp;url=' . get_permalink()), '"',
                            '>',
                            '<span class="fab fa-twitter"></span>',
                        '</a>'; ?>
                    </li>

                    <li>
                        <?php echo '<a class="share_post share_facebook"',
                            ' target="_blank"',
                            ' href="', esc_url('https://www.facebook.com/share.php?u=' . get_permalink()), '"',
                            '>',
                            '<span class="fab fa-facebook-f"></span>',
                        '</a>'; ?>
                    </li>

                    <?php
                    $img_url = wp_get_attachment_image_url(get_post_thumbnail_id(get_the_ID()), 'single-post-thumbnail');
                    if ($img_url) {
                        echo '<li>',
                            '<a class="share_post share_pinterest"',
                                ' target="_blank"',
                                ' href="', esc_url('https://pinterest.com/pin/create/button/?url='. get_permalink() .'&media='. $img_url), '"',
                                '>',
                                '<span class="fab fa-pinterest-p"></span>',
                            '</a>',
                        '</li>';
                    }?>

                    <li>
                    <?php echo '<a class="share_post share_linkedin"',
                            ' target="_blank"',
                            ' href="', esc_url('http://www.linkedin.com/shareArticle?mini=true&url=' . substr(urlencode(get_permalink()), 0, 1024)), '&title=', esc_attr(substr(urlencode(html_entity_decode(get_the_title())), 0, 200)), '"',
                            '>',
                            '<span class="fab fa-linkedin-in"></span>',
                        '</a>'; ?>
                    </li>
                </ul>
            </div>
            <span class="share_title"><?php esc_html_e('Share:', 'atlets-core');?></span>
            <a href="#"></a>
        </div><?php
    }

    public static function render_page_marker(){

        $offset = Atlets_Theme_Helper::get_mb_option('page_marker_offset', 'mb_customize_markers', 'on');

        $style =  isset($offset['margin-top']) && $offset['margin-top'] !== '' ? 'top:'.(int)$offset['margin-top'].'%;' : '';

        ?>
        <section class="wgl-page-markers"<?php echo !empty($style) ? ' style="'.$style.'"' : '' ?>>
            <div class="page-markers-wpapper"><?php
                for ($i = 1; $i <= 6; $i++) {
                    ${'add_marker_'.$i} = Atlets_Theme_Helper::get_mb_option('add_marker_'.$i, 'mb_customize_markers', 'on');
                    ${'marker_link_'.$i} = Atlets_Theme_Helper::get_mb_option('marker_link_'.$i, 'mb_customize_markers', 'on');
                    ${'marker_title_'.$i} = Atlets_Theme_Helper::get_mb_option('marker_title_'.$i, 'mb_customize_markers', 'on');
                    ${'marker_image_'.$i} = Atlets_Theme_Helper::get_option('marker_image_'.$i);
                    ${'marker_image_alt_'.$i} = isset(${'marker_image_'.$i}['id']) ? get_post_meta(${'marker_image_'.$i}['id'], '_wp_attachment_image_alt', true) : '';
                    ${'marker_image_'.$i} = ${'marker_image_'.$i}['url'];

                    if (class_exists( 'RWMB_Loader' ) && rwmb_meta('mb_customize_markers') == 'on') {
                        ${'mb_marker_image_src'.$i} = rwmb_meta('mb_marker_image_'.$i);
                        if (!empty(${'mb_marker_image_src'.$i})) {
                            ${'marker_image_'.$i} = array_values(${'mb_marker_image_src'.$i});
                            ${'marker_image_alt_'.$i} = isset(${'marker_image_'.$i}[0]['ID']) ? get_post_meta(${'marker_image_'.$i}[0]['ID'], '_wp_attachment_image_alt', true) : '';
                            ${'marker_image_'.$i} = ${'marker_image_'.$i}[0]['full_url'];
                        }
                    }

                    if ((bool)${'add_marker_'.$i}) {?>
                        <a class="page-marker" href="<?php echo esc_url( ${'marker_link_'.$i} );?>" target="_blank">
                            <?php
                                if(!empty(${'marker_image_'.$i})):
                            ?>
                            <span class="img">
                                <img src="<?php echo esc_attr(${'marker_image_'.$i});?>" alt="<?php echo !empty(${'marker_image_alt_'.$i}) ? esc_attr(${'marker_image_alt_'.$i}) : ''?>"/>
                            </span>
                            <?php
                                endif;
                            ?>
                            <?php
                                if(isset(${'marker_title_'.$i})):
                            ?>
                            <span class="title"><?php echo ${'marker_title_'.$i};?></span>
                            <?php
                                endif;
                            ?>
                        </a><?php
                    }
                }?>
            </div>
        </section>
        <?php
    }
}

function wgl_theme_helper() {
    return WglThemeHelper::instance();
}
