<?php

defined('ABSPATH') || exit;

/**
* Atlets Wgl_Admin_Icon
*
*
* @class Wgl_Admin_Icon
* @version 1.0
* @category Class
* @author WebGeniusLab
*/

if (!class_exists('Wgl_Admin_Icon')) {

    class Wgl_Admin_Icon
    {
        private $icons = [];

        private static $instance = null;
        public static function get_instance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        private function __construct()
        {
            $this->load();
        }

        public function load()
        {
            $this->setup_stylesheet_data();

        }

        private function setup_stylesheet_data()
        {
            $this->icons = $this->setup_icon_array();
        }

        private function setup_icon_array()
        {
            $icons = array();

            $icons = $this->get_icon_list();
            $icons = apply_filters('atlets_icon_list', $icons);

            return $icons;
        }

        /*----------------------------------------------------------------------------*
         * Public Helper Functions
         *----------------------------------------------------------------------------*/
        public function get_icons_name($get_icons_value = false)
        {
            $icons = [];

            if (!empty($this->icons)) {
                foreach ($this->icons as $key => $value) {
                    $icons[$key] = (bool) $get_icons_value ? esc_html($key) : esc_html($value);
                }

                return $icons;
            } else {
                return $icons;
            }

        }

        public function get_icon_list()
        {
            return [
                'fab fa-500px' => esc_html__( '500px', 'atlets' ),
                'fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'atlets' ),
                'fab fa-accusoft' => esc_html__( 'accusoft', 'atlets' ),
                'fas fa-address-book' => esc_html__( 'address-book', 'atlets' ),
                'far fa-address-book' => esc_html__( 'address-book', 'atlets' ),
                'fas fa-address-card' => esc_html__( 'address-card', 'atlets' ),
                'far fa-address-card' => esc_html__( 'address-card', 'atlets' ),
                'fas fa-adjust' => esc_html__( 'adjust', 'atlets' ),
                'fab fa-adn' => esc_html__( 'adn', 'atlets' ),
                'fab fa-adversal' => esc_html__( 'adversal', 'atlets' ),
                'fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'atlets' ),
                'fab fa-algolia' => esc_html__( 'algolia', 'atlets' ),
                'fas fa-align-center' => esc_html__( 'align-center', 'atlets' ),
                'fas fa-align-justify' => esc_html__( 'align-justify', 'atlets' ),
                'fas fa-align-left' => esc_html__( 'align-left', 'atlets' ),
                'fas fa-align-right' => esc_html__( 'align-right', 'atlets' ),
                'fas fa-allergies' => esc_html__( 'allergies', 'atlets' ),
                'fab fa-amazon' => esc_html__( 'amazon', 'atlets' ),
                'fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'atlets' ),
                'fas fa-ambulance' => esc_html__( 'ambulance', 'atlets' ),
                'fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'atlets' ),
                'fab fa-amilia' => esc_html__( 'amilia', 'atlets' ),
                'fas fa-anchor' => esc_html__( 'anchor', 'atlets' ),
                'fab fa-android' => esc_html__( 'android', 'atlets' ),
                'fab fa-angellist' => esc_html__( 'angellist', 'atlets' ),
                'fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'atlets' ),
                'fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'atlets' ),
                'fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'atlets' ),
                'fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'atlets' ),
                'fas fa-angle-down' => esc_html__( 'angle-down', 'atlets' ),
                'fas fa-angle-left' => esc_html__( 'angle-left', 'atlets' ),
                'fas fa-angle-right' => esc_html__( 'angle-right', 'atlets' ),
                'fas fa-angle-up' => esc_html__( 'angle-up', 'atlets' ),
                'fab fa-angrycreative' => esc_html__( 'angrycreative', 'atlets' ),
                'fab fa-angular' => esc_html__( 'angular', 'atlets' ),
                'fab fa-app-store' => esc_html__( 'app-store', 'atlets' ),
                'fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'atlets' ),
                'fab fa-apper' => esc_html__( 'apper', 'atlets' ),
                'fab fa-apple' => esc_html__( 'apple', 'atlets' ),
                'fab fa-apple-pay' => esc_html__( 'apple-pay', 'atlets' ),
                'fas fa-archive' => esc_html__( 'archive', 'atlets' ),
                'fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'atlets' ),
                'far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'atlets' ),
                'fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'atlets' ),
                'far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'atlets' ),
                'fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'atlets' ),
                'far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'atlets' ),
                'fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'atlets' ),
                'far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'atlets' ),
                'fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'atlets' ),
                'fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'atlets' ),
                'fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'atlets' ),
                'fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'atlets' ),
                'fas fa-arrow-down' => esc_html__( 'arrow-down', 'atlets' ),
                'fas fa-arrow-left' => esc_html__( 'arrow-left', 'atlets' ),
                'fas fa-arrow-right' => esc_html__( 'arrow-right', 'atlets' ),
                'fas fa-arrow-up' => esc_html__( 'arrow-up', 'atlets' ),
                'fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'atlets' ),
                'fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'atlets' ),
                'fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'atlets' ),
                'fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'atlets' ),
                'fas fa-asterisk' => esc_html__( 'asterisk', 'atlets' ),
                'fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'atlets' ),
                'fas fa-at' => esc_html__( 'at', 'atlets' ),
                'fab fa-audible' => esc_html__( 'audible', 'atlets' ),
                'fas fa-audio-description' => esc_html__( 'audio-description', 'atlets' ),
                'fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'atlets' ),
                'fab fa-avianex' => esc_html__( 'avianex', 'atlets' ),
                'fab fa-aviato' => esc_html__( 'aviato', 'atlets' ),
                'fab fa-aws' => esc_html__( 'aws', 'atlets' ),
                'fas fa-backward' => esc_html__( 'backward', 'atlets' ),
                'fas fa-balance-scale' => esc_html__( 'balance-scale', 'atlets' ),
                'fas fa-ban' => esc_html__( 'ban', 'atlets' ),
                'fas fa-band-aid' => esc_html__( 'band-aid', 'atlets' ),
                'fab fa-bandcamp' => esc_html__( 'bandcamp', 'atlets' ),
                'fas fa-barcode' => esc_html__( 'barcode', 'atlets' ),
                'fas fa-bars' => esc_html__( 'bars', 'atlets' ),
                'fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'atlets' ),
                'fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'atlets' ),
                'fas fa-bath' => esc_html__( 'bath', 'atlets' ),
                'fas fa-battery-empty' => esc_html__( 'battery-empty', 'atlets' ),
                'fas fa-battery-full' => esc_html__( 'battery-full', 'atlets' ),
                'fas fa-battery-half' => esc_html__( 'battery-half', 'atlets' ),
                'fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'atlets' ),
                'fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'atlets' ),
                'fas fa-bed' => esc_html__( 'bed', 'atlets' ),
                'fas fa-beer' => esc_html__( 'beer', 'atlets' ),
                'fab fa-behance' => esc_html__( 'behance', 'atlets' ),
                'fab fa-behance-square' => esc_html__( 'behance-square', 'atlets' ),
                'fas fa-bell' => esc_html__( 'bell', 'atlets' ),
                'far fa-bell' => esc_html__( 'bell', 'atlets' ),
                'fas fa-bell-slash' => esc_html__( 'bell-slash', 'atlets' ),
                'far fa-bell-slash' => esc_html__( 'bell-slash', 'atlets' ),
                'fas fa-bicycle' => esc_html__( 'bicycle', 'atlets' ),
                'fab fa-bimobject' => esc_html__( 'bimobject', 'atlets' ),
                'fas fa-binoculars' => esc_html__( 'binoculars', 'atlets' ),
                'fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'atlets' ),
                'fab fa-bitbucket' => esc_html__( 'bitbucket', 'atlets' ),
                'fab fa-bitcoin' => esc_html__( 'bitcoin', 'atlets' ),
                'fab fa-bity' => esc_html__( 'bity', 'atlets' ),
                'fab fa-black-tie' => esc_html__( 'black-tie', 'atlets' ),
                'fab fa-blackberry' => esc_html__( 'blackberry', 'atlets' ),
                'fas fa-blind' => esc_html__( 'blind', 'atlets' ),
                'fab fa-blogger' => esc_html__( 'blogger', 'atlets' ),
                'fab fa-blogger-b' => esc_html__( 'blogger-b', 'atlets' ),
                'fab fa-bluetooth' => esc_html__( 'bluetooth', 'atlets' ),
                'fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'atlets' ),
                'fas fa-bold' => esc_html__( 'bold', 'atlets' ),
                'fas fa-bolt' => esc_html__( 'bolt', 'atlets' ),
                'fas fa-bomb' => esc_html__( 'bomb', 'atlets' ),
                'fas fa-book' => esc_html__( 'book', 'atlets' ),
                'fas fa-bookmark' => esc_html__( 'bookmark', 'atlets' ),
                'far fa-bookmark' => esc_html__( 'bookmark', 'atlets' ),
                'fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'atlets' ),
                'fas fa-box' => esc_html__( 'box', 'atlets' ),
                'fas fa-box-open' => esc_html__( 'box-open', 'atlets' ),
                'fas fa-boxes' => esc_html__( 'boxes', 'atlets' ),
                'fas fa-braille' => esc_html__( 'braille', 'atlets' ),
                'fas fa-briefcase' => esc_html__( 'briefcase', 'atlets' ),
                'fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'atlets' ),
                'fab fa-btc' => esc_html__( 'btc', 'atlets' ),
                'fas fa-bug' => esc_html__( 'bug', 'atlets' ),
                'fas fa-building' => esc_html__( 'building', 'atlets' ),
                'far fa-building' => esc_html__( 'building', 'atlets' ),
                'fas fa-bullhorn' => esc_html__( 'bullhorn', 'atlets' ),
                'fas fa-bullseye' => esc_html__( 'bullseye', 'atlets' ),
                'fas fa-burn' => esc_html__( 'burn', 'atlets' ),
                'fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'atlets' ),
                'fas fa-bus' => esc_html__( 'bus', 'atlets' ),
                'fab fa-buysellads' => esc_html__( 'buysellads', 'atlets' ),
                'fas fa-calculator' => esc_html__( 'calculator', 'atlets' ),
                'fas fa-calendar' => esc_html__( 'calendar', 'atlets' ),
                'far fa-calendar' => esc_html__( 'calendar', 'atlets' ),
                'fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'atlets' ),
                'far fa-calendar-alt' => esc_html__( 'calendar-alt', 'atlets' ),
                'fas fa-calendar-check' => esc_html__( 'calendar-check', 'atlets' ),
                'far fa-calendar-check' => esc_html__( 'calendar-check', 'atlets' ),
                'fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'atlets' ),
                'far fa-calendar-minus' => esc_html__( 'calendar-minus', 'atlets' ),
                'fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'atlets' ),
                'far fa-calendar-plus' => esc_html__( 'calendar-plus', 'atlets' ),
                'fas fa-calendar-times' => esc_html__( 'calendar-times', 'atlets' ),
                'far fa-calendar-times' => esc_html__( 'calendar-times', 'atlets' ),
                'fas fa-camera' => esc_html__( 'camera', 'atlets' ),
                'fas fa-camera-retro' => esc_html__( 'camera-retro', 'atlets' ),
                'fas fa-capsules' => esc_html__( 'capsules', 'atlets' ),
                'fas fa-car' => esc_html__( 'car', 'atlets' ),
                'fas fa-caret-down' => esc_html__( 'caret-down', 'atlets' ),
                'fas fa-caret-left' => esc_html__( 'caret-left', 'atlets' ),
                'fas fa-caret-right' => esc_html__( 'caret-right', 'atlets' ),
                'fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'atlets' ),
                'far fa-caret-square-down' => esc_html__( 'caret-square-down', 'atlets' ),
                'fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'atlets' ),
                'far fa-caret-square-left' => esc_html__( 'caret-square-left', 'atlets' ),
                'fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'atlets' ),
                'far fa-caret-square-right' => esc_html__( 'caret-square-right', 'atlets' ),
                'fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'atlets' ),
                'far fa-caret-square-up' => esc_html__( 'caret-square-up', 'atlets' ),
                'fas fa-caret-up' => esc_html__( 'caret-up', 'atlets' ),
                'fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'atlets' ),
                'fas fa-cart-plus' => esc_html__( 'cart-plus', 'atlets' ),
                'fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'atlets' ),
                'fab fa-cc-amex' => esc_html__( 'cc-amex', 'atlets' ),
                'fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'atlets' ),
                'fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'atlets' ),
                'fab fa-cc-discover' => esc_html__( 'cc-discover', 'atlets' ),
                'fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'atlets' ),
                'fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'atlets' ),
                'fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'atlets' ),
                'fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'atlets' ),
                'fab fa-cc-visa' => esc_html__( 'cc-visa', 'atlets' ),
                'fab fa-centercode' => esc_html__( 'centercode', 'atlets' ),
                'fas fa-certificate' => esc_html__( 'certificate', 'atlets' ),
                'fas fa-chart-area' => esc_html__( 'chart-area', 'atlets' ),
                'fas fa-chart-bar' => esc_html__( 'chart-bar', 'atlets' ),
                'far fa-chart-bar' => esc_html__( 'chart-bar', 'atlets' ),
                'fas fa-chart-line' => esc_html__( 'chart-line', 'atlets' ),
                'fas fa-chart-pie' => esc_html__( 'chart-pie', 'atlets' ),
                'fas fa-check' => esc_html__( 'check', 'atlets' ),
                'fas fa-check-circle' => esc_html__( 'check-circle', 'atlets' ),
                'far fa-check-circle' => esc_html__( 'check-circle', 'atlets' ),
                'fas fa-check-square' => esc_html__( 'check-square', 'atlets' ),
                'far fa-check-square' => esc_html__( 'check-square', 'atlets' ),
                'fas fa-chess' => esc_html__( 'chess', 'atlets' ),
                'fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'atlets' ),
                'fas fa-chess-board' => esc_html__( 'chess-board', 'atlets' ),
                'fas fa-chess-king' => esc_html__( 'chess-king', 'atlets' ),
                'fas fa-chess-knight' => esc_html__( 'chess-knight', 'atlets' ),
                'fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'atlets' ),
                'fas fa-chess-queen' => esc_html__( 'chess-queen', 'atlets' ),
                'fas fa-chess-rook' => esc_html__( 'chess-rook', 'atlets' ),
                'fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'atlets' ),
                'fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'atlets' ),
                'fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'atlets' ),
                'fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'atlets' ),
                'fas fa-chevron-down' => esc_html__( 'chevron-down', 'atlets' ),
                'fas fa-chevron-left' => esc_html__( 'chevron-left', 'atlets' ),
                'fas fa-chevron-right' => esc_html__( 'chevron-right', 'atlets' ),
                'fas fa-chevron-up' => esc_html__( 'chevron-up', 'atlets' ),
                'fas fa-child' => esc_html__( 'child', 'atlets' ),
                'fab fa-chrome' => esc_html__( 'chrome', 'atlets' ),
                'fas fa-circle' => esc_html__( 'circle', 'atlets' ),
                'far fa-circle' => esc_html__( 'circle', 'atlets' ),
                'fas fa-circle-notch' => esc_html__( 'circle-notch', 'atlets' ),
                'fas fa-clipboard' => esc_html__( 'clipboard', 'atlets' ),
                'far fa-clipboard' => esc_html__( 'clipboard', 'atlets' ),
                'fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'atlets' ),
                'fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'atlets' ),
                'fas fa-clock' => esc_html__( 'clock', 'atlets' ),
                'far fa-clock' => esc_html__( 'clock', 'atlets' ),
                'fas fa-clone' => esc_html__( 'clone', 'atlets' ),
                'far fa-clone' => esc_html__( 'clone', 'atlets' ),
                'fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'atlets' ),
                'far fa-closed-captioning' => esc_html__( 'closed-captioning', 'atlets' ),
                'fas fa-cloud' => esc_html__( 'cloud', 'atlets' ),
                'fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'atlets' ),
                'fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'atlets' ),
                'fab fa-cloudscale' => esc_html__( 'cloudscale', 'atlets' ),
                'fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'atlets' ),
                'fab fa-cloudversify' => esc_html__( 'cloudversify', 'atlets' ),
                'fas fa-code' => esc_html__( 'code', 'atlets' ),
                'fas fa-code-branch' => esc_html__( 'code-branch', 'atlets' ),
                'fab fa-codepen' => esc_html__( 'codepen', 'atlets' ),
                'fab fa-codiepie' => esc_html__( 'codiepie', 'atlets' ),
                'fas fa-coffee' => esc_html__( 'coffee', 'atlets' ),
                'fas fa-cog' => esc_html__( 'cog', 'atlets' ),
                'fas fa-cogs' => esc_html__( 'cogs', 'atlets' ),
                'fas fa-columns' => esc_html__( 'columns', 'atlets' ),
                'fas fa-comment' => esc_html__( 'comment', 'atlets' ),
                'far fa-comment' => esc_html__( 'comment', 'atlets' ),
                'fas fa-comment-alt' => esc_html__( 'comment-alt', 'atlets' ),
                'far fa-comment-alt' => esc_html__( 'comment-alt', 'atlets' ),
                'fas fa-comment-dots' => esc_html__( 'comment-dots', 'atlets' ),
                'fas fa-comment-slash' => esc_html__( 'comment-slash', 'atlets' ),
                'fas fa-comments' => esc_html__( 'comments', 'atlets' ),
                'far fa-comments' => esc_html__( 'comments', 'atlets' ),
                'fas fa-compass' => esc_html__( 'compass', 'atlets' ),
                'far fa-compass' => esc_html__( 'compass', 'atlets' ),
                'fas fa-compress' => esc_html__( 'compress', 'atlets' ),
                'fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'atlets' ),
                'fab fa-contao' => esc_html__( 'contao', 'atlets' ),
                'fas fa-copy' => esc_html__( 'copy', 'atlets' ),
                'far fa-copy' => esc_html__( 'copy', 'atlets' ),
                'fas fa-copyright' => esc_html__( 'copyright', 'atlets' ),
                'far fa-copyright' => esc_html__( 'copyright', 'atlets' ),
                'fas fa-couch' => esc_html__( 'couch', 'atlets' ),
                'fab fa-cpanel' => esc_html__( 'cpanel', 'atlets' ),
                'fab fa-creative-commons' => esc_html__( 'creative-commons', 'atlets' ),
                'fas fa-credit-card' => esc_html__( 'credit-card', 'atlets' ),
                'far fa-credit-card' => esc_html__( 'credit-card', 'atlets' ),
                'fas fa-crop' => esc_html__( 'crop', 'atlets' ),
                'fas fa-crosshairs' => esc_html__( 'crosshairs', 'atlets' ),
                'fab fa-css3' => esc_html__( 'css3', 'atlets' ),
                'fab fa-css3-alt' => esc_html__( 'css3-alt', 'atlets' ),
                'fas fa-cube' => esc_html__( 'cube', 'atlets' ),
                'fas fa-cubes' => esc_html__( 'cubes', 'atlets' ),
                'fas fa-cut' => esc_html__( 'cut', 'atlets' ),
                'fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'atlets' ),
                'fab fa-d-and-d' => esc_html__( 'd-and-d', 'atlets' ),
                'fab fa-dashcube' => esc_html__( 'dashcube', 'atlets' ),
                'fas fa-database' => esc_html__( 'database', 'atlets' ),
                'fas fa-deaf' => esc_html__( 'deaf', 'atlets' ),
                'fab fa-delicious' => esc_html__( 'delicious', 'atlets' ),
                'fab fa-deploydog' => esc_html__( 'deploydog', 'atlets' ),
                'fab fa-deskpro' => esc_html__( 'deskpro', 'atlets' ),
                'fas fa-desktop' => esc_html__( 'desktop', 'atlets' ),
                'fab fa-deviantart' => esc_html__( 'deviantart', 'atlets' ),
                'fas fa-diagnoses' => esc_html__( 'diagnoses', 'atlets' ),
                'fab fa-digg' => esc_html__( 'digg', 'atlets' ),
                'fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'atlets' ),
                'fab fa-discord' => esc_html__( 'discord', 'atlets' ),
                'fab fa-discourse' => esc_html__( 'discourse', 'atlets' ),
                'fas fa-dna' => esc_html__( 'dna', 'atlets' ),
                'fab fa-dochub' => esc_html__( 'dochub', 'atlets' ),
                'fab fa-docker' => esc_html__( 'docker', 'atlets' ),
                'fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'atlets' ),
                'fas fa-dolly' => esc_html__( 'dolly', 'atlets' ),
                'fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'atlets' ),
                'fas fa-donate' => esc_html__( 'donate', 'atlets' ),
                'fas fa-dot-circle' => esc_html__( 'dot-circle', 'atlets' ),
                'far fa-dot-circle' => esc_html__( 'dot-circle', 'atlets' ),
                'fas fa-dove' => esc_html__( 'dove', 'atlets' ),
                'fas fa-download' => esc_html__( 'download', 'atlets' ),
                'fab fa-draft2digital' => esc_html__( 'draft2digital', 'atlets' ),
                'fab fa-dribbble' => esc_html__( 'dribbble', 'atlets' ),
                'fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'atlets' ),
                'fab fa-dropbox' => esc_html__( 'dropbox', 'atlets' ),
                'fab fa-drupal' => esc_html__( 'drupal', 'atlets' ),
                'fab fa-dyalog' => esc_html__( 'dyalog', 'atlets' ),
                'fab fa-earlybirds' => esc_html__( 'earlybirds', 'atlets' ),
                'fab fa-edge' => esc_html__( 'edge', 'atlets' ),
                'fas fa-edit' => esc_html__( 'edit', 'atlets' ),
                'far fa-edit' => esc_html__( 'edit', 'atlets' ),
                'fas fa-eject' => esc_html__( 'eject', 'atlets' ),
                'fab fa-elementor' => esc_html__( 'elementor', 'atlets' ),
                'fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'atlets' ),
                'fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'atlets' ),
                'fab fa-ember' => esc_html__( 'ember', 'atlets' ),
                'fab fa-empire' => esc_html__( 'empire', 'atlets' ),
                'fas fa-envelope' => esc_html__( 'envelope', 'atlets' ),
                'far fa-envelope' => esc_html__( 'envelope', 'atlets' ),
                'fas fa-envelope-open' => esc_html__( 'envelope-open', 'atlets' ),
                'far fa-envelope-open' => esc_html__( 'envelope-open', 'atlets' ),
                'fas fa-envelope-square' => esc_html__( 'envelope-square', 'atlets' ),
                'fab fa-envira' => esc_html__( 'envira', 'atlets' ),
                'fas fa-eraser' => esc_html__( 'eraser', 'atlets' ),
                'fab fa-erlang' => esc_html__( 'erlang', 'atlets' ),
                'fab fa-ethereum' => esc_html__( 'ethereum', 'atlets' ),
                'fab fa-etsy' => esc_html__( 'etsy', 'atlets' ),
                'fas fa-euro-sign' => esc_html__( 'euro-sign', 'atlets' ),
                'fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'atlets' ),
                'fas fa-exclamation' => esc_html__( 'exclamation', 'atlets' ),
                'fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'atlets' ),
                'fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'atlets' ),
                'fas fa-expand' => esc_html__( 'expand', 'atlets' ),
                'fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'atlets' ),
                'fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'atlets' ),
                'fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'atlets' ),
                'fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'atlets' ),
                'fas fa-eye' => esc_html__( 'eye', 'atlets' ),
                'fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'atlets' ),
                'fas fa-eye-slash' => esc_html__( 'eye-slash', 'atlets' ),
                'far fa-eye-slash' => esc_html__( 'eye-slash', 'atlets' ),
                'fab fa-facebook' => esc_html__( 'facebook', 'atlets' ),
                'fab fa-facebook-f' => esc_html__( 'facebook-f', 'atlets' ),
                'fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'atlets' ),
                'fab fa-facebook-square' => esc_html__( 'facebook-square', 'atlets' ),
                'fas fa-fast-backward' => esc_html__( 'fast-backward', 'atlets' ),
                'fas fa-fast-forward' => esc_html__( 'fast-forward', 'atlets' ),
                'fas fa-fax' => esc_html__( 'fax', 'atlets' ),
                'fas fa-female' => esc_html__( 'female', 'atlets' ),
                'fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'atlets' ),
                'fas fa-file' => esc_html__( 'file', 'atlets' ),
                'far fa-file' => esc_html__( 'file', 'atlets' ),
                'fas fa-file-alt' => esc_html__( 'file-alt', 'atlets' ),
                'far fa-file-alt' => esc_html__( 'file-alt', 'atlets' ),
                'fas fa-file-archive' => esc_html__( 'file-archive', 'atlets' ),
                'far fa-file-archive' => esc_html__( 'file-archive', 'atlets' ),
                'fas fa-file-audio' => esc_html__( 'file-audio', 'atlets' ),
                'far fa-file-audio' => esc_html__( 'file-audio', 'atlets' ),
                'fas fa-file-code' => esc_html__( 'file-code', 'atlets' ),
                'far fa-file-code' => esc_html__( 'file-code', 'atlets' ),
                'fas fa-file-excel' => esc_html__( 'file-excel', 'atlets' ),
                'far fa-file-excel' => esc_html__( 'file-excel', 'atlets' ),
                'fas fa-file-image' => esc_html__( 'file-image', 'atlets' ),
                'far fa-file-image' => esc_html__( 'file-image', 'atlets' ),
                'fas fa-file-medical' => esc_html__( 'file-medical', 'atlets' ),
                'fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'atlets' ),
                'fas fa-file-pdf' => esc_html__( 'file-pdf', 'atlets' ),
                'far fa-file-pdf' => esc_html__( 'file-pdf', 'atlets' ),
                'fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'atlets' ),
                'far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'atlets' ),
                'fas fa-file-video' => esc_html__( 'file-video', 'atlets' ),
                'far fa-file-video' => esc_html__( 'file-video', 'atlets' ),
                'fas fa-file-word' => esc_html__( 'file-word', 'atlets' ),
                'far fa-file-word' => esc_html__( 'file-word', 'atlets' ),
                'fas fa-film' => esc_html__( 'film', 'atlets' ),
                'fas fa-filter' => esc_html__( 'filter', 'atlets' ),
                'fas fa-fire' => esc_html__( 'fire', 'atlets' ),
                'fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'atlets' ),
                'fab fa-firefox' => esc_html__( 'firefox', 'atlets' ),
                'fas fa-first-aid' => esc_html__( 'first-aid', 'atlets' ),
                'fab fa-first-order' => esc_html__( 'first-order', 'atlets' ),
                'fab fa-firstdraft' => esc_html__( 'firstdraft', 'atlets' ),
                'fas fa-flag' => esc_html__( 'flag', 'atlets' ),
                'far fa-flag' => esc_html__( 'flag', 'atlets' ),
                'fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'atlets' ),
                'fas fa-flask' => esc_html__( 'flask', 'atlets' ),
                'fab fa-flickr' => esc_html__( 'flickr', 'atlets' ),
                'fab fa-flipboard' => esc_html__( 'flipboard', 'atlets' ),
                'fab fa-fly' => esc_html__( 'fly', 'atlets' ),
                'fas fa-folder' => esc_html__( 'folder', 'atlets' ),
                'far fa-folder' => esc_html__( 'folder', 'atlets' ),
                'fas fa-folder-open' => esc_html__( 'folder-open', 'atlets' ),
                'far fa-folder-open' => esc_html__( 'folder-open', 'atlets' ),
                'fas fa-font' => esc_html__( 'font', 'atlets' ),
                'fab fa-font-awesome' => esc_html__( 'font-awesome', 'atlets' ),
                'fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'atlets' ),
                'fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'atlets' ),
                'fab fa-fonticons' => esc_html__( 'fonticons', 'atlets' ),
                'fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'atlets' ),
                'fas fa-football-ball' => esc_html__( 'football-ball', 'atlets' ),
                'fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'atlets' ),
                'fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'atlets' ),
                'fab fa-forumbee' => esc_html__( 'forumbee', 'atlets' ),
                'fas fa-forward' => esc_html__( 'forward', 'atlets' ),
                'fab fa-foursquare' => esc_html__( 'foursquare', 'atlets' ),
                'fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'atlets' ),
                'fab fa-freebsd' => esc_html__( 'freebsd', 'atlets' ),
                'fas fa-frown' => esc_html__( 'frown', 'atlets' ),
                'far fa-frown' => esc_html__( 'frown', 'atlets' ),
                'fas fa-futbol' => esc_html__( 'futbol', 'atlets' ),
                'far fa-futbol' => esc_html__( 'futbol', 'atlets' ),
                'fas fa-gamepad' => esc_html__( 'gamepad', 'atlets' ),
                'fas fa-gavel' => esc_html__( 'gavel', 'atlets' ),
                'fas fa-gem' => esc_html__( 'gem', 'atlets' ),
                'far fa-gem' => esc_html__( 'gem', 'atlets' ),
                'fas fa-genderless' => esc_html__( 'genderless', 'atlets' ),
                'fab fa-get-pocket' => esc_html__( 'get-pocket', 'atlets' ),
                'fab fa-gg' => esc_html__( 'gg', 'atlets' ),
                'fab fa-gg-circle' => esc_html__( 'gg-circle', 'atlets' ),
                'fas fa-gift' => esc_html__( 'gift', 'atlets' ),
                'fab fa-git' => esc_html__( 'git', 'atlets' ),
                'fab fa-git-square' => esc_html__( 'git-square', 'atlets' ),
                'fab fa-github' => esc_html__( 'github', 'atlets' ),
                'fab fa-github-alt' => esc_html__( 'github-alt', 'atlets' ),
                'fab fa-github-square' => esc_html__( 'github-square', 'atlets' ),
                'fab fa-gitkraken' => esc_html__( 'gitkraken', 'atlets' ),
                'fab fa-gitlab' => esc_html__( 'gitlab', 'atlets' ),
                'fab fa-gitter' => esc_html__( 'gitter', 'atlets' ),
                'fas fa-glass-martini' => esc_html__( 'glass-martini', 'atlets' ),
                'fab fa-glide' => esc_html__( 'glide', 'atlets' ),
                'fab fa-glide-g' => esc_html__( 'glide-g', 'atlets' ),
                'fas fa-globe' => esc_html__( 'globe', 'atlets' ),
                'fab fa-gofore' => esc_html__( 'gofore', 'atlets' ),
                'fas fa-golf-ball' => esc_html__( 'golf-ball', 'atlets' ),
                'fab fa-goodreads' => esc_html__( 'goodreads', 'atlets' ),
                'fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'atlets' ),
                'fab fa-google' => esc_html__( 'google', 'atlets' ),
                'fab fa-google-drive' => esc_html__( 'google-drive', 'atlets' ),
                'fab fa-google-play' => esc_html__( 'google-play', 'atlets' ),
                'fab fa-google-plus' => esc_html__( 'google-plus', 'atlets' ),
                'fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'atlets' ),
                'fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'atlets' ),
                'fab fa-google-wallet' => esc_html__( 'google-wallet', 'atlets' ),
                'fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'atlets' ),
                'fab fa-gratipay' => esc_html__( 'gratipay', 'atlets' ),
                'fab fa-grav' => esc_html__( 'grav', 'atlets' ),
                'fab fa-gripfire' => esc_html__( 'gripfire', 'atlets' ),
                'fab fa-grunt' => esc_html__( 'grunt', 'atlets' ),
                'fab fa-gulp' => esc_html__( 'gulp', 'atlets' ),
                'fas fa-h-square' => esc_html__( 'h-square', 'atlets' ),
                'fab fa-hacker-news' => esc_html__( 'hacker-news', 'atlets' ),
                'fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'atlets' ),
                'fas fa-hand-holding' => esc_html__( 'hand-holding', 'atlets' ),
                'fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'atlets' ),
                'fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'atlets' ),
                'fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'atlets' ),
                'far fa-hand-lizard' => esc_html__( 'hand-lizard', 'atlets' ),
                'fas fa-hand-paper' => esc_html__( 'hand-paper', 'atlets' ),
                'far fa-hand-paper' => esc_html__( 'hand-paper', 'atlets' ),
                'fas fa-hand-peace' => esc_html__( 'hand-peace', 'atlets' ),
                'far fa-hand-peace' => esc_html__( 'hand-peace', 'atlets' ),
                'fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'atlets' ),
                'far fa-hand-point-down' => esc_html__( 'hand-point-down', 'atlets' ),
                'fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'atlets' ),
                'far fa-hand-point-left' => esc_html__( 'hand-point-left', 'atlets' ),
                'fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'atlets' ),
                'far fa-hand-point-right' => esc_html__( 'hand-point-right', 'atlets' ),
                'fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'atlets' ),
                'far fa-hand-point-up' => esc_html__( 'hand-point-up', 'atlets' ),
                'fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'atlets' ),
                'far fa-hand-pointer' => esc_html__( 'hand-pointer', 'atlets' ),
                'fas fa-hand-rock' => esc_html__( 'hand-rock', 'atlets' ),
                'far fa-hand-rock' => esc_html__( 'hand-rock', 'atlets' ),
                'fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'atlets' ),
                'far fa-hand-scissors' => esc_html__( 'hand-scissors', 'atlets' ),
                'fas fa-hand-spock' => esc_html__( 'hand-spock', 'atlets' ),
                'far fa-hand-spock' => esc_html__( 'hand-spock', 'atlets' ),
                'fas fa-hands' => esc_html__( 'hands', 'atlets' ),
                'fas fa-hands-helping' => esc_html__( 'hands-helping', 'atlets' ),
                'fas fa-handshake' => esc_html__( 'handshake', 'atlets' ),
                'far fa-handshake' => esc_html__( 'handshake', 'atlets' ),
                'fas fa-hashtag' => esc_html__( 'hashtag', 'atlets' ),
                'fas fa-hdd' => esc_html__( 'hdd', 'atlets' ),
                'far fa-hdd' => esc_html__( 'hdd', 'atlets' ),
                'fas fa-heading' => esc_html__( 'heading', 'atlets' ),
                'fas fa-headphones' => esc_html__( 'headphones', 'atlets' ),
                'fas fa-heart' => esc_html__( 'heart', 'atlets' ),
                'far fa-heart' => esc_html__( 'heart', 'atlets' ),
                'fas fa-heartbeat' => esc_html__( 'heartbeat', 'atlets' ),
                'fab fa-hips' => esc_html__( 'hips', 'atlets' ),
                'fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'atlets' ),
                'fas fa-history' => esc_html__( 'history', 'atlets' ),
                'fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'atlets' ),
                'fas fa-home' => esc_html__( 'home', 'atlets' ),
                'fab fa-hooli' => esc_html__( 'hooli', 'atlets' ),
                'fas fa-hospital' => esc_html__( 'hospital', 'atlets' ),
                'far fa-hospital' => esc_html__( 'hospital', 'atlets' ),
                'fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'atlets' ),
                'fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'atlets' ),
                'fab fa-hotjar' => esc_html__( 'hotjar', 'atlets' ),
                'fas fa-hourglass' => esc_html__( 'hourglass', 'atlets' ),
                'far fa-hourglass' => esc_html__( 'hourglass', 'atlets' ),
                'fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'atlets' ),
                'fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'atlets' ),
                'fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'atlets' ),
                'fab fa-houzz' => esc_html__( 'houzz', 'atlets' ),
                'fab fa-html5' => esc_html__( 'html5', 'atlets' ),
                'fab fa-hubspot' => esc_html__( 'hubspot', 'atlets' ),
                'fas fa-i-cursor' => esc_html__( 'i-cursor', 'atlets' ),
                'fas fa-id-badge' => esc_html__( 'id-badge', 'atlets' ),
                'far fa-id-badge' => esc_html__( 'id-badge', 'atlets' ),
                'fas fa-id-card' => esc_html__( 'id-card', 'atlets' ),
                'far fa-id-card' => esc_html__( 'id-card', 'atlets' ),
                'fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'atlets' ),
                'fas fa-image' => esc_html__( 'image', 'atlets' ),
                'far fa-image' => esc_html__( 'image', 'atlets' ),
                'fas fa-images' => esc_html__( 'images', 'atlets' ),
                'far fa-images' => esc_html__( 'images', 'atlets' ),
                'fab fa-imdb' => esc_html__( 'imdb', 'atlets' ),
                'fas fa-inbox' => esc_html__( 'inbox', 'atlets' ),
                'fas fa-indent' => esc_html__( 'indent', 'atlets' ),
                'fas fa-industry' => esc_html__( 'industry', 'atlets' ),
                'fas fa-info' => esc_html__( 'info', 'atlets' ),
                'fas fa-info-circle' => esc_html__( 'info-circle', 'atlets' ),
                'fab fa-instagram' => esc_html__( 'instagram', 'atlets' ),
                'fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'atlets' ),
                'fab fa-ioxhost' => esc_html__( 'ioxhost', 'atlets' ),
                'fas fa-italic' => esc_html__( 'italic', 'atlets' ),
                'fab fa-itunes' => esc_html__( 'itunes', 'atlets' ),
                'fab fa-itunes-note' => esc_html__( 'itunes-note', 'atlets' ),
                'fab fa-java' => esc_html__( 'java', 'atlets' ),
                'fab fa-jenkins' => esc_html__( 'jenkins', 'atlets' ),
                'fab fa-joget' => esc_html__( 'joget', 'atlets' ),
                'fab fa-joomla' => esc_html__( 'joomla', 'atlets' ),
                'fab fa-js' => esc_html__( 'js', 'atlets' ),
                'fab fa-js-square' => esc_html__( 'js-square', 'atlets' ),
                'fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'atlets' ),
                'fas fa-key' => esc_html__( 'key', 'atlets' ),
                'fas fa-keyboard' => esc_html__( 'keyboard', 'atlets' ),
                'far fa-keyboard' => esc_html__( 'keyboard', 'atlets' ),
                'fab fa-keycdn' => esc_html__( 'keycdn', 'atlets' ),
                'fab fa-kickstarter' => esc_html__( 'kickstarter', 'atlets' ),
                'fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'atlets' ),
                'fab fa-korvue' => esc_html__( 'korvue', 'atlets' ),
                'fas fa-language' => esc_html__( 'language', 'atlets' ),
                'fas fa-laptop' => esc_html__( 'laptop', 'atlets' ),
                'fab fa-laravel' => esc_html__( 'laravel', 'atlets' ),
                'fab fa-lastfm' => esc_html__( 'lastfm', 'atlets' ),
                'fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'atlets' ),
                'fas fa-leaf' => esc_html__( 'leaf', 'atlets' ),
                'fab fa-leanpub' => esc_html__( 'leanpub', 'atlets' ),
                'fas fa-lemon' => esc_html__( 'lemon', 'atlets' ),
                'far fa-lemon' => esc_html__( 'lemon', 'atlets' ),
                'fab fa-less' => esc_html__( 'less', 'atlets' ),
                'fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'atlets' ),
                'fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'atlets' ),
                'fas fa-life-ring' => esc_html__( 'life-ring', 'atlets' ),
                'far fa-life-ring' => esc_html__( 'life-ring', 'atlets' ),
                'fas fa-lightbulb' => esc_html__( 'lightbulb', 'atlets' ),
                'far fa-lightbulb' => esc_html__( 'lightbulb', 'atlets' ),
                'fab fa-line' => esc_html__( 'line', 'atlets' ),
                'fas fa-link' => esc_html__( 'link', 'atlets' ),
                'fab fa-linkedin' => esc_html__( 'linkedin', 'atlets' ),
                'fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'atlets' ),
                'fab fa-linode' => esc_html__( 'linode', 'atlets' ),
                'fab fa-linux' => esc_html__( 'linux', 'atlets' ),
                'fas fa-lira-sign' => esc_html__( 'lira-sign', 'atlets' ),
                'fas fa-list' => esc_html__( 'list', 'atlets' ),
                'fas fa-list-alt' => esc_html__( 'list-alt', 'atlets' ),
                'far fa-list-alt' => esc_html__( 'list-alt', 'atlets' ),
                'fas fa-list-ol' => esc_html__( 'list-ol', 'atlets' ),
                'fas fa-list-ul' => esc_html__( 'list-ul', 'atlets' ),
                'fas fa-location-arrow' => esc_html__( 'location-arrow', 'atlets' ),
                'fas fa-lock' => esc_html__( 'lock', 'atlets' ),
                'fas fa-lock-open' => esc_html__( 'lock-open', 'atlets' ),
                'fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'atlets' ),
                'fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'atlets' ),
                'fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'atlets' ),
                'fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'atlets' ),
                'fas fa-low-vision' => esc_html__( 'low-vision', 'atlets' ),
                'fab fa-lyft' => esc_html__( 'lyft', 'atlets' ),
                'fab fa-magento' => esc_html__( 'magento', 'atlets' ),
                'fas fa-magic' => esc_html__( 'magic', 'atlets' ),
                'fas fa-magnet' => esc_html__( 'magnet', 'atlets' ),
                'fas fa-male' => esc_html__( 'male', 'atlets' ),
                'fas fa-map' => esc_html__( 'map', 'atlets' ),
                'far fa-map' => esc_html__( 'map', 'atlets' ),
                'fas fa-map-marker' => esc_html__( 'map-marker', 'atlets' ),
                'fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'atlets' ),
                'fas fa-map-pin' => esc_html__( 'map-pin', 'atlets' ),
                'fas fa-map-signs' => esc_html__( 'map-signs', 'atlets' ),
                'fas fa-mars' => esc_html__( 'mars', 'atlets' ),
                'fas fa-mars-double' => esc_html__( 'mars-double', 'atlets' ),
                'fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'atlets' ),
                'fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'atlets' ),
                'fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'atlets' ),
                'fab fa-maxcdn' => esc_html__( 'maxcdn', 'atlets' ),
                'fab fa-medapps' => esc_html__( 'medapps', 'atlets' ),
                'fab fa-medium' => esc_html__( 'medium', 'atlets' ),
                'fab fa-medium-m' => esc_html__( 'medium-m', 'atlets' ),
                'fas fa-medkit' => esc_html__( 'medkit', 'atlets' ),
                'fab fa-medrt' => esc_html__( 'medrt', 'atlets' ),
                'fab fa-meetup' => esc_html__( 'meetup', 'atlets' ),
                'fas fa-meh' => esc_html__( 'meh', 'atlets' ),
                'far fa-meh' => esc_html__( 'meh', 'atlets' ),
                'fas fa-mercury' => esc_html__( 'mercury', 'atlets' ),
                'fas fa-microchip' => esc_html__( 'microchip', 'atlets' ),
                'fas fa-microphone' => esc_html__( 'microphone', 'atlets' ),
                'fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'atlets' ),
                'fab fa-microsoft' => esc_html__( 'microsoft', 'atlets' ),
                'fas fa-minus' => esc_html__( 'minus', 'atlets' ),
                'fas fa-minus-circle' => esc_html__( 'minus-circle', 'atlets' ),
                'fas fa-minus-square' => esc_html__( 'minus-square', 'atlets' ),
                'far fa-minus-square' => esc_html__( 'minus-square', 'atlets' ),
                'fab fa-mix' => esc_html__( 'mix', 'atlets' ),
                'fab fa-mixcloud' => esc_html__( 'mixcloud', 'atlets' ),
                'fab fa-mizuni' => esc_html__( 'mizuni', 'atlets' ),
                'fas fa-mobile' => esc_html__( 'mobile', 'atlets' ),
                'fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'atlets' ),
                'fab fa-modx' => esc_html__( 'modx', 'atlets' ),
                'fab fa-monero' => esc_html__( 'monero', 'atlets' ),
                'fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'atlets' ),
                'far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'atlets' ),
                'fas fa-moon' => esc_html__( 'moon', 'atlets' ),
                'far fa-moon' => esc_html__( 'moon', 'atlets' ),
                'fas fa-motorcycle' => esc_html__( 'motorcycle', 'atlets' ),
                'fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'atlets' ),
                'fas fa-music' => esc_html__( 'music', 'atlets' ),
                'fab fa-napster' => esc_html__( 'napster', 'atlets' ),
                'fas fa-neuter' => esc_html__( 'neuter', 'atlets' ),
                'fas fa-newspaper' => esc_html__( 'newspaper', 'atlets' ),
                'far fa-newspaper' => esc_html__( 'newspaper', 'atlets' ),
                'fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'atlets' ),
                'fab fa-node' => esc_html__( 'node', 'atlets' ),
                'fab fa-node-js' => esc_html__( 'node-js', 'atlets' ),
                'fas fa-notes-medical' => esc_html__( 'notes-medical', 'atlets' ),
                'fab fa-npm' => esc_html__( 'npm', 'atlets' ),
                'fab fa-ns8' => esc_html__( 'ns8', 'atlets' ),
                'fab fa-nutritionix' => esc_html__( 'nutritionix', 'atlets' ),
                'fas fa-object-group' => esc_html__( 'object-group', 'atlets' ),
                'far fa-object-group' => esc_html__( 'object-group', 'atlets' ),
                'fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'atlets' ),
                'far fa-object-ungroup' => esc_html__( 'object-ungroup', 'atlets' ),
                'fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'atlets' ),
                'fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'atlets' ),
                'fab fa-opencart' => esc_html__( 'opencart', 'atlets' ),
                'fab fa-openid' => esc_html__( 'openid', 'atlets' ),
                'fab fa-opera' => esc_html__( 'opera', 'atlets' ),
                'fab fa-optin-monster' => esc_html__( 'optin-monster', 'atlets' ),
                'fab fa-osi' => esc_html__( 'osi', 'atlets' ),
                'fas fa-outdent' => esc_html__( 'outdent', 'atlets' ),
                'fab fa-page4' => esc_html__( 'page4', 'atlets' ),
                'fab fa-pagelines' => esc_html__( 'pagelines', 'atlets' ),
                'fas fa-paint-brush' => esc_html__( 'paint-brush', 'atlets' ),
                'fab fa-palfed' => esc_html__( 'palfed', 'atlets' ),
                'fas fa-pallet' => esc_html__( 'pallet', 'atlets' ),
                'fas fa-paper-plane' => esc_html__( 'paper-plane', 'atlets' ),
                'far fa-paper-plane' => esc_html__( 'paper-plane', 'atlets' ),
                'fas fa-paperclip' => esc_html__( 'paperclip', 'atlets' ),
                'fas fa-parachute-box' => esc_html__( 'parachute-box', 'atlets' ),
                'fas fa-paragraph' => esc_html__( 'paragraph', 'atlets' ),
                'fas fa-paste' => esc_html__( 'paste', 'atlets' ),
                'fab fa-patreon' => esc_html__( 'patreon', 'atlets' ),
                'fas fa-pause' => esc_html__( 'pause', 'atlets' ),
                'fas fa-pause-circle' => esc_html__( 'pause-circle', 'atlets' ),
                'far fa-pause-circle' => esc_html__( 'pause-circle', 'atlets' ),
                'fas fa-paw' => esc_html__( 'paw', 'atlets' ),
                'fab fa-paypal' => esc_html__( 'paypal', 'atlets' ),
                'fas fa-pen-square' => esc_html__( 'pen-square', 'atlets' ),
                'fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'atlets' ),
                'fas fa-people-carry' => esc_html__( 'people-carry', 'atlets' ),
                'fas fa-percent' => esc_html__( 'percent', 'atlets' ),
                'fab fa-periscope' => esc_html__( 'periscope', 'atlets' ),
                'fab fa-phabricator' => esc_html__( 'phabricator', 'atlets' ),
                'fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'atlets' ),
                'fas fa-phone' => esc_html__( 'phone', 'atlets' ),
                'fas fa-phone-slash' => esc_html__( 'phone-slash', 'atlets' ),
                'fas fa-phone-square' => esc_html__( 'phone-square', 'atlets' ),
                'fas fa-phone-volume' => esc_html__( 'phone-volume', 'atlets' ),
                'fab fa-php' => esc_html__( 'php', 'atlets' ),
                'fab fa-pied-piper' => esc_html__( 'pied-piper', 'atlets' ),
                'fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'atlets' ),
                'fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'atlets' ),
                'fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'atlets' ),
                'fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'atlets' ),
                'fas fa-pills' => esc_html__( 'pills', 'atlets' ),
                'fab fa-pinterest' => esc_html__( 'pinterest', 'atlets' ),
                'fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'atlets' ),
                'fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'atlets' ),
                'fas fa-plane' => esc_html__( 'plane', 'atlets' ),
                'fas fa-play' => esc_html__( 'play', 'atlets' ),
                'fas fa-play-circle' => esc_html__( 'play-circle', 'atlets' ),
                'far fa-play-circle' => esc_html__( 'play-circle', 'atlets' ),
                'fab fa-playstation' => esc_html__( 'playstation', 'atlets' ),
                'fas fa-plug' => esc_html__( 'plug', 'atlets' ),
                'fas fa-plus' => esc_html__( 'plus', 'atlets' ),
                'fas fa-plus-circle' => esc_html__( 'plus-circle', 'atlets' ),
                'fas fa-plus-square' => esc_html__( 'plus-square', 'atlets' ),
                'far fa-plus-square' => esc_html__( 'plus-square', 'atlets' ),
                'fas fa-podcast' => esc_html__( 'podcast', 'atlets' ),
                'fas fa-poo' => esc_html__( 'poo', 'atlets' ),
                'fas fa-pound-sign' => esc_html__( 'pound-sign', 'atlets' ),
                'fas fa-power-off' => esc_html__( 'power-off', 'atlets' ),
                'fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'atlets' ),
                'fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'atlets' ),
                'fas fa-print' => esc_html__( 'print', 'atlets' ),
                'fas fa-procedures' => esc_html__( 'procedures', 'atlets' ),
                'fab fa-product-hunt' => esc_html__( 'product-hunt', 'atlets' ),
                'fab fa-pushed' => esc_html__( 'pushed', 'atlets' ),
                'fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'atlets' ),
                'fab fa-python' => esc_html__( 'python', 'atlets' ),
                'fab fa-qq' => esc_html__( 'qq', 'atlets' ),
                'fas fa-qrcode' => esc_html__( 'qrcode', 'atlets' ),
                'fas fa-question' => esc_html__( 'question', 'atlets' ),
                'fas fa-question-circle' => esc_html__( 'question-circle', 'atlets' ),
                'far fa-question-circle' => esc_html__( 'question-circle', 'atlets' ),
                'fas fa-quidditch' => esc_html__( 'quidditch', 'atlets' ),
                'fab fa-quinscape' => esc_html__( 'quinscape', 'atlets' ),
                'fab fa-quora' => esc_html__( 'quora', 'atlets' ),
                'fas fa-quote-left' => esc_html__( 'quote-left', 'atlets' ),
                'fas fa-quote-right' => esc_html__( 'quote-right', 'atlets' ),
                'fas fa-random' => esc_html__( 'random', 'atlets' ),
                'fab fa-ravelry' => esc_html__( 'ravelry', 'atlets' ),
                'fab fa-react' => esc_html__( 'react', 'atlets' ),
                'fab fa-readme' => esc_html__( 'readme', 'atlets' ),
                'fab fa-rebel' => esc_html__( 'rebel', 'atlets' ),
                'fas fa-recycle' => esc_html__( 'recycle', 'atlets' ),
                'fab fa-red-river' => esc_html__( 'red-river', 'atlets' ),
                'fab fa-reddit' => esc_html__( 'reddit', 'atlets' ),
                'fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'atlets' ),
                'fab fa-reddit-square' => esc_html__( 'reddit-square', 'atlets' ),
                'fas fa-redo' => esc_html__( 'redo', 'atlets' ),
                'fas fa-redo-alt' => esc_html__( 'redo-alt', 'atlets' ),
                'fas fa-registered' => esc_html__( 'registered', 'atlets' ),
                'far fa-registered' => esc_html__( 'registered', 'atlets' ),
                'fab fa-rendact' => esc_html__( 'rendact', 'atlets' ),
                'fab fa-renren' => esc_html__( 'renren', 'atlets' ),
                'fas fa-reply' => esc_html__( 'reply', 'atlets' ),
                'fas fa-reply-all' => esc_html__( 'reply-all', 'atlets' ),
                'fab fa-replyd' => esc_html__( 'replyd', 'atlets' ),
                'fab fa-resolving' => esc_html__( 'resolving', 'atlets' ),
                'fas fa-retweet' => esc_html__( 'retweet', 'atlets' ),
                'fas fa-ribbon' => esc_html__( 'ribbon', 'atlets' ),
                'fas fa-road' => esc_html__( 'road', 'atlets' ),
                'fas fa-rocket' => esc_html__( 'rocket', 'atlets' ),
                'fab fa-rocketchat' => esc_html__( 'rocketchat', 'atlets' ),
                'fab fa-rockrms' => esc_html__( 'rockrms', 'atlets' ),
                'fas fa-rss' => esc_html__( 'rss', 'atlets' ),
                'fas fa-rss-square' => esc_html__( 'rss-square', 'atlets' ),
                'fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'atlets' ),
                'fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'atlets' ),
                'fab fa-safari' => esc_html__( 'safari', 'atlets' ),
                'fab fa-sass' => esc_html__( 'sass', 'atlets' ),
                'fas fa-save' => esc_html__( 'save', 'atlets' ),
                'far fa-save' => esc_html__( 'save', 'atlets' ),
                'fab fa-schlix' => esc_html__( 'schlix', 'atlets' ),
                'fab fa-scribd' => esc_html__( 'scribd', 'atlets' ),
                'fas fa-search' => esc_html__( 'search', 'atlets' ),
                'fas fa-search-minus' => esc_html__( 'search-minus', 'atlets' ),
                'fas fa-search-plus' => esc_html__( 'search-plus', 'atlets' ),
                'fab fa-searchengin' => esc_html__( 'searchengin', 'atlets' ),
                'fas fa-seedling' => esc_html__( 'seedling', 'atlets' ),
                'fab fa-sellcast' => esc_html__( 'sellcast', 'atlets' ),
                'fab fa-sellsy' => esc_html__( 'sellsy', 'atlets' ),
                'fas fa-server' => esc_html__( 'server', 'atlets' ),
                'fab fa-servicestack' => esc_html__( 'servicestack', 'atlets' ),
                'fas fa-share' => esc_html__( 'share', 'atlets' ),
                'fas fa-share-alt' => esc_html__( 'share-alt', 'atlets' ),
                'fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'atlets' ),
                'fas fa-share-square' => esc_html__( 'share-square', 'atlets' ),
                'far fa-share-square' => esc_html__( 'share-square', 'atlets' ),
                'fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'atlets' ),
                'fas fa-shield-alt' => esc_html__( 'shield-alt', 'atlets' ),
                'fas fa-ship' => esc_html__( 'ship', 'atlets' ),
                'fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'atlets' ),
                'fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'atlets' ),
                'fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'atlets' ),
                'fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'atlets' ),
                'fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'atlets' ),
                'fas fa-shower' => esc_html__( 'shower', 'atlets' ),
                'fas fa-sign' => esc_html__( 'sign', 'atlets' ),
                'fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'atlets' ),
                'fas fa-sign-language' => esc_html__( 'sign-language', 'atlets' ),
                'fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'atlets' ),
                'fas fa-signal' => esc_html__( 'signal', 'atlets' ),
                'fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'atlets' ),
                'fab fa-sistrix' => esc_html__( 'sistrix', 'atlets' ),
                'fas fa-sitemap' => esc_html__( 'sitemap', 'atlets' ),
                'fab fa-skyatlas' => esc_html__( 'skyatlas', 'atlets' ),
                'fab fa-skype' => esc_html__( 'skype', 'atlets' ),
                'fab fa-slack' => esc_html__( 'slack', 'atlets' ),
                'fab fa-slack-hash' => esc_html__( 'slack-hash', 'atlets' ),
                'fas fa-sliders-h' => esc_html__( 'sliders-h', 'atlets' ),
                'fab fa-slideshare' => esc_html__( 'slideshare', 'atlets' ),
                'fas fa-smile' => esc_html__( 'smile', 'atlets' ),
                'far fa-smile' => esc_html__( 'smile', 'atlets' ),
                'fas fa-smoking' => esc_html__( 'smoking', 'atlets' ),
                'fab fa-snapchat' => esc_html__( 'snapchat', 'atlets' ),
                'fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'atlets' ),
                'fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'atlets' ),
                'fas fa-snowflake' => esc_html__( 'snowflake', 'atlets' ),
                'far fa-snowflake' => esc_html__( 'snowflake', 'atlets' ),
                'fas fa-sort' => esc_html__( 'sort', 'atlets' ),
                'fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'atlets' ),
                'fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'atlets' ),
                'fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'atlets' ),
                'fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'atlets' ),
                'fas fa-sort-down' => esc_html__( 'sort-down', 'atlets' ),
                'fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'atlets' ),
                'fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'atlets' ),
                'fas fa-sort-up' => esc_html__( 'sort-up', 'atlets' ),
                'fab fa-soundcloud' => esc_html__( 'soundcloud', 'atlets' ),
                'fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'atlets' ),
                'fab fa-speakap' => esc_html__( 'speakap', 'atlets' ),
                'fas fa-spinner' => esc_html__( 'spinner', 'atlets' ),
                'fab fa-spotify' => esc_html__( 'spotify', 'atlets' ),
                'fas fa-square' => esc_html__( 'square', 'atlets' ),
                'far fa-square' => esc_html__( 'square', 'atlets' ),
                'fas fa-square-full' => esc_html__( 'square-full', 'atlets' ),
                'fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'atlets' ),
                'fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'atlets' ),
                'fas fa-star' => esc_html__( 'star', 'atlets' ),
                'far fa-star' => esc_html__( 'star', 'atlets' ),
                'fas fa-star-half' => esc_html__( 'star-half', 'atlets' ),
                'far fa-star-half' => esc_html__( 'star-half', 'atlets' ),
                'fab fa-staylinked' => esc_html__( 'staylinked', 'atlets' ),
                'fab fa-steam' => esc_html__( 'steam', 'atlets' ),
                'fab fa-steam-square' => esc_html__( 'steam-square', 'atlets' ),
                'fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'atlets' ),
                'fas fa-step-backward' => esc_html__( 'step-backward', 'atlets' ),
                'fas fa-step-forward' => esc_html__( 'step-forward', 'atlets' ),
                'fas fa-stethoscope' => esc_html__( 'stethoscope', 'atlets' ),
                'fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'atlets' ),
                'fas fa-sticky-note' => esc_html__( 'sticky-note', 'atlets' ),
                'far fa-sticky-note' => esc_html__( 'sticky-note', 'atlets' ),
                'fas fa-stop' => esc_html__( 'stop', 'atlets' ),
                'fas fa-stop-circle' => esc_html__( 'stop-circle', 'atlets' ),
                'far fa-stop-circle' => esc_html__( 'stop-circle', 'atlets' ),
                'fas fa-stopwatch' => esc_html__( 'stopwatch', 'atlets' ),
                'fab fa-strava' => esc_html__( 'strava', 'atlets' ),
                'fas fa-street-view' => esc_html__( 'street-view', 'atlets' ),
                'fas fa-strikethrough' => esc_html__( 'strikethrough', 'atlets' ),
                'fab fa-stripe' => esc_html__( 'stripe', 'atlets' ),
                'fab fa-stripe-s' => esc_html__( 'stripe-s', 'atlets' ),
                'fab fa-studiovinari' => esc_html__( 'studiovinari', 'atlets' ),
                'fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'atlets' ),
                'fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'atlets' ),
                'fas fa-subscript' => esc_html__( 'subscript', 'atlets' ),
                'fas fa-subway' => esc_html__( 'subway', 'atlets' ),
                'fas fa-suitcase' => esc_html__( 'suitcase', 'atlets' ),
                'fas fa-sun' => esc_html__( 'sun', 'atlets' ),
                'far fa-sun' => esc_html__( 'sun', 'atlets' ),
                'fab fa-superpowers' => esc_html__( 'superpowers', 'atlets' ),
                'fas fa-superscript' => esc_html__( 'superscript', 'atlets' ),
                'fab fa-supple' => esc_html__( 'supple', 'atlets' ),
                'fas fa-sync' => esc_html__( 'sync', 'atlets' ),
                'fas fa-sync-alt' => esc_html__( 'sync-alt', 'atlets' ),
                'fas fa-syringe' => esc_html__( 'syringe', 'atlets' ),
                'fas fa-table' => esc_html__( 'table', 'atlets' ),
                'fas fa-table-tennis' => esc_html__( 'table-tennis', 'atlets' ),
                'fas fa-tablet' => esc_html__( 'tablet', 'atlets' ),
                'fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'atlets' ),
                'fas fa-tablets' => esc_html__( 'tablets', 'atlets' ),
                'fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'atlets' ),
                'fas fa-tag' => esc_html__( 'tag', 'atlets' ),
                'fas fa-tags' => esc_html__( 'tags', 'atlets' ),
                'fas fa-tape' => esc_html__( 'tape', 'atlets' ),
                'fas fa-tasks' => esc_html__( 'tasks', 'atlets' ),
                'fas fa-taxi' => esc_html__( 'taxi', 'atlets' ),
                'fab fa-telegram' => esc_html__( 'telegram', 'atlets' ),
                'fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'atlets' ),
                'fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'atlets' ),
                'fas fa-terminal' => esc_html__( 'terminal', 'atlets' ),
                'fas fa-text-height' => esc_html__( 'text-height', 'atlets' ),
                'fas fa-text-width' => esc_html__( 'text-width', 'atlets' ),
                'fas fa-th' => esc_html__( 'th', 'atlets' ),
                'fas fa-th-large' => esc_html__( 'th-large', 'atlets' ),
                'fas fa-th-list' => esc_html__( 'th-list', 'atlets' ),
                'fab fa-themeisle' => esc_html__( 'themeisle', 'atlets' ),
                'fas fa-thermometer' => esc_html__( 'thermometer', 'atlets' ),
                'fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'atlets' ),
                'fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'atlets' ),
                'fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'atlets' ),
                'fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'atlets' ),
                'fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'atlets' ),
                'fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'atlets' ),
                'far fa-thumbs-down' => esc_html__( 'thumbs-down', 'atlets' ),
                'fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'atlets' ),
                'far fa-thumbs-up' => esc_html__( 'thumbs-up', 'atlets' ),
                'fas fa-thumbtack' => esc_html__( 'thumbtack', 'atlets' ),
                'fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'atlets' ),
                'fas fa-times' => esc_html__( 'times', 'atlets' ),
                'fas fa-times-circle' => esc_html__( 'times-circle', 'atlets' ),
                'far fa-times-circle' => esc_html__( 'times-circle', 'atlets' ),
                'fas fa-tint' => esc_html__( 'tint', 'atlets' ),
                'fas fa-toggle-off' => esc_html__( 'toggle-off', 'atlets' ),
                'fas fa-toggle-on' => esc_html__( 'toggle-on', 'atlets' ),
                'fas fa-trademark' => esc_html__( 'trademark', 'atlets' ),
                'fas fa-train' => esc_html__( 'train', 'atlets' ),
                'fas fa-transgender' => esc_html__( 'transgender', 'atlets' ),
                'fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'atlets' ),
                'fas fa-trash' => esc_html__( 'trash', 'atlets' ),
                'fas fa-trash-alt' => esc_html__( 'trash-alt', 'atlets' ),
                'far fa-trash-alt' => esc_html__( 'trash-alt', 'atlets' ),
                'fas fa-tree' => esc_html__( 'tree', 'atlets' ),
                'fab fa-trello' => esc_html__( 'trello', 'atlets' ),
                'fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'atlets' ),
                'fas fa-trophy' => esc_html__( 'trophy', 'atlets' ),
                'fas fa-truck' => esc_html__( 'truck', 'atlets' ),
                'fas fa-truck-loading' => esc_html__( 'truck-loading', 'atlets' ),
                'fas fa-truck-moving' => esc_html__( 'truck-moving', 'atlets' ),
                'fas fa-tty' => esc_html__( 'tty', 'atlets' ),
                'fab fa-tumblr' => esc_html__( 'tumblr', 'atlets' ),
                'fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'atlets' ),
                'fas fa-tv' => esc_html__( 'tv', 'atlets' ),
                'fab fa-twitch' => esc_html__( 'twitch', 'atlets' ),
                'fab fa-twitter' => esc_html__( 'twitter', 'atlets' ),
                'fab fa-twitter-square' => esc_html__( 'twitter-square', 'atlets' ),
                'fab fa-typo3' => esc_html__( 'typo3', 'atlets' ),
                'fab fa-uber' => esc_html__( 'uber', 'atlets' ),
                'fab fa-uikit' => esc_html__( 'uikit', 'atlets' ),
                'fas fa-umbrella' => esc_html__( 'umbrella', 'atlets' ),
                'fas fa-underline' => esc_html__( 'underline', 'atlets' ),
                'fas fa-undo' => esc_html__( 'undo', 'atlets' ),
                'fas fa-undo-alt' => esc_html__( 'undo-alt', 'atlets' ),
                'fab fa-uniregistry' => esc_html__( 'uniregistry', 'atlets' ),
                'fas fa-universal-access' => esc_html__( 'universal-access', 'atlets' ),
                'fas fa-university' => esc_html__( 'university', 'atlets' ),
                'fas fa-unlink' => esc_html__( 'unlink', 'atlets' ),
                'fas fa-unlock' => esc_html__( 'unlock', 'atlets' ),
                'fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'atlets' ),
                'fab fa-untappd' => esc_html__( 'untappd', 'atlets' ),
                'fas fa-upload' => esc_html__( 'upload', 'atlets' ),
                'fab fa-usb' => esc_html__( 'usb', 'atlets' ),
                'fas fa-user' => esc_html__( 'user', 'atlets' ),
                'far fa-user' => esc_html__( 'user', 'atlets' ),
                'fas fa-user-circle' => esc_html__( 'user-circle', 'atlets' ),
                'far fa-user-circle' => esc_html__( 'user-circle', 'atlets' ),
                'fas fa-user-md' => esc_html__( 'user-md', 'atlets' ),
                'fas fa-user-plus' => esc_html__( 'user-plus', 'atlets' ),
                'fas fa-user-secret' => esc_html__( 'user-secret', 'atlets' ),
                'fas fa-user-times' => esc_html__( 'user-times', 'atlets' ),
                'fas fa-users' => esc_html__( 'users', 'atlets' ),
                'fab fa-ussunnah' => esc_html__( 'ussunnah', 'atlets' ),
                'fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'atlets' ),
                'fas fa-utensils' => esc_html__( 'utensils', 'atlets' ),
                'fab fa-vaadin' => esc_html__( 'vaadin', 'atlets' ),
                'fas fa-venus' => esc_html__( 'venus', 'atlets' ),
                'fas fa-venus-double' => esc_html__( 'venus-double', 'atlets' ),
                'fas fa-venus-mars' => esc_html__( 'venus-mars', 'atlets' ),
                'fab fa-viacoin' => esc_html__( 'viacoin', 'atlets' ),
                'fab fa-viadeo' => esc_html__( 'viadeo', 'atlets' ),
                'fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'atlets' ),
                'fas fa-vial' => esc_html__( 'vial', 'atlets' ),
                'fas fa-vials' => esc_html__( 'vials', 'atlets' ),
                'fab fa-viber' => esc_html__( 'viber', 'atlets' ),
                'fas fa-video' => esc_html__( 'video', 'atlets' ),
                'fas fa-video-slash' => esc_html__( 'video-slash', 'atlets' ),
                'fab fa-vimeo' => esc_html__( 'vimeo', 'atlets' ),
                'fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'atlets' ),
                'fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'atlets' ),
                'fab fa-vine' => esc_html__( 'vine', 'atlets' ),
                'fab fa-vk' => esc_html__( 'vk', 'atlets' ),
                'fab fa-vnv' => esc_html__( 'vnv', 'atlets' ),
                'fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'atlets' ),
                'fas fa-volume-down' => esc_html__( 'volume-down', 'atlets' ),
                'fas fa-volume-off' => esc_html__( 'volume-off', 'atlets' ),
                'fas fa-volume-up' => esc_html__( 'volume-up', 'atlets' ),
                'fab fa-vuejs' => esc_html__( 'vuejs', 'atlets' ),
                'fas fa-warehouse' => esc_html__( 'warehouse', 'atlets' ),
                'fab fa-weibo' => esc_html__( 'weibo', 'atlets' ),
                'fas fa-weight' => esc_html__( 'weight', 'atlets' ),
                'fab fa-weixin' => esc_html__( 'weixin', 'atlets' ),
                'fab fa-whatsapp' => esc_html__( 'whatsapp', 'atlets' ),
                'fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'atlets' ),
                'fas fa-wheelchair' => esc_html__( 'wheelchair', 'atlets' ),
                'fab fa-whmcs' => esc_html__( 'whmcs', 'atlets' ),
                'fas fa-wifi' => esc_html__( 'wifi', 'atlets' ),
                'fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'atlets' ),
                'fas fa-window-close' => esc_html__( 'window-close', 'atlets' ),
                'far fa-window-close' => esc_html__( 'window-close', 'atlets' ),
                'fas fa-window-maximize' => esc_html__( 'window-maximize', 'atlets' ),
                'far fa-window-maximize' => esc_html__( 'window-maximize', 'atlets' ),
                'fas fa-window-minimize' => esc_html__( 'window-minimize', 'atlets' ),
                'far fa-window-minimize' => esc_html__( 'window-minimize', 'atlets' ),
                'fas fa-window-restore' => esc_html__( 'window-restore', 'atlets' ),
                'far fa-window-restore' => esc_html__( 'window-restore', 'atlets' ),
                'fab fa-windows' => esc_html__( 'windows', 'atlets' ),
                'fas fa-wine-glass' => esc_html__( 'wine-glass', 'atlets' ),
                'fas fa-won-sign' => esc_html__( 'won-sign', 'atlets' ),
                'fab fa-wordpress' => esc_html__( 'wordpress', 'atlets' ),
                'fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'atlets' ),
                'fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'atlets' ),
                'fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'atlets' ),
                'fab fa-wpforms' => esc_html__( 'wpforms', 'atlets' ),
                'fas fa-wrench' => esc_html__( 'wrench', 'atlets' ),
                'fas fa-x-ray' => esc_html__( 'x-ray', 'atlets' ),
                'fab fa-xbox' => esc_html__( 'xbox', 'atlets' ),
                'fab fa-xing' => esc_html__( 'xing', 'atlets' ),
                'fab fa-xing-square' => esc_html__( 'xing-square', 'atlets' ),
                'fab fa-y-combinator' => esc_html__( 'y-combinator', 'atlets' ),
                'fab fa-yahoo' => esc_html__( 'yahoo', 'atlets' ),
                'fab fa-yandex' => esc_html__( 'yandex', 'atlets' ),
                'fab fa-yandex-international' => esc_html__( 'yandex-international', 'atlets' ),
                'fab fa-yelp' => esc_html__( 'yelp', 'atlets' ),
                'fas fa-yen-sign' => esc_html__( 'yen-sign', 'atlets' ),
                'fab fa-yoast' => esc_html__( 'yoast', 'atlets' ),
                'fab fa-youtube' => esc_html__( 'youtube', 'atlets' ),
                'fab fa-youtube-square' => esc_html__( 'youtube-square', 'atlets' ),
            ];
        }
    }

    function WglAdminIcon()
    {
        return Wgl_Admin_Icon::get_instance();
    }

    // Call Admin Function
    WglAdminIcon();
}
