<?php

if (!class_exists('RWMB_Loader')) {
    return;
}

class Atlets_Metaboxes
{
    public function __construct()
    {
        // Team Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'team_meta_boxes']);

        // Portfolio Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'portfolio_meta_boxes']);
        add_filter('rwmb_meta_boxes', [$this, 'portfolio_post_settings_meta_boxes']);
        add_filter('rwmb_meta_boxes', [$this, 'portfolio_related_meta_boxes']);

        // Blog Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'blog_settings_meta_boxes']);
        add_filter('rwmb_meta_boxes', [$this, 'blog_meta_boxes']);
        add_filter('rwmb_meta_boxes', [$this, 'blog_related_meta_boxes']);

        // Page Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_layout_meta_boxes']);
        // Colors Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_color_meta_boxes']);
        // Header Builder Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_header_meta_boxes']);
        // Title Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_title_meta_boxes']);
        // Side Panel Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_side_panel_meta_boxes']);
        // Page Markers Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_markers_meta_boxes']);
        // Footer Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_footer_meta_boxes']);
        // Copyright Fields Metaboxes
        add_filter('rwmb_meta_boxes', [$this, 'page_copyright_meta_boxes']);

    }

    public function team_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Team Options', 'atlets'),
            'post_types' => ['team'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Highlighted Info', 'atlets'),
                    'id' => 'department',
                    'type' => 'text',
                    'class' => 'field-inputs'
                ],
                [
                    'name' => esc_html__('Watermark', 'atlets'),
                    'id' => 'watermark_team',
                    'type' => 'text',
                    'class' => 'field-inputs',
                    'std' => esc_html__('skilled team', 'atlets')
                ],
                [
                    'name' => esc_html__('Member Info', 'atlets'),
                    'id' => 'info_items',
                    'type' => 'social',
                    'clone' => true,
                    'sort_clone' => true,
                    'options' => [
                        'name' => [
                            'name' => esc_html__('Name', 'atlets'),
                            'type_input' => 'text'
                        ],
                        'description' => [
                            'name' => esc_html__('Description', 'atlets'),
                            'type_input' => 'text'
                        ],
                        'link' => [
                            'name' => esc_html__('Link', 'atlets'),
                            'type_input' => 'text'
                        ]
                    ]
                ],
                [
                    'name' => esc_html__('Social Icons', 'atlets'),
                    'id' => 'soc_icon',
                    'type' => 'select_icon',
                    'options' => WglAdminIcon()->get_icons_name(),
                    'clone' => true,
                    'sort_clone' => true,
                    'placeholder' => esc_html__('Select an icon', 'atlets'),
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Info Background Image', 'atlets'),
                    'id' => 'mb_info_bg',
                    'type' => 'file_advanced',
                    'max_file_uploads' => 1,
                    'mime_type' => 'image'
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function portfolio_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Portfolio Options', 'atlets'),
            'post_types' => ['portfolio'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Featured Image', 'atlets'),
                    'id' => 'mb_portfolio_featured_image_conditional',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Featured Image Settings', 'atlets'),
                    'id' => 'mb_portfolio_featured_image_type',
                    'type' => 'button_group',
                    'options' => [
                        'off' => esc_html__('Off', 'atlets'),
                        'replace' => esc_html__('Replace', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'off',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_featured_image_conditional', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Featured Image Replace', 'atlets'),
                    'id' => 'mb_portfolio_featured_image_replace',
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_featured_image_conditional', '=', 'custom'],
                            ['mb_portfolio_featured_image_type', '=', 'replace']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_portfolio_title',
                    'name' => esc_html__('Show Title on single', 'atlets'),
                    'type' => 'switch',
                    'std' => 'true'
                ],
                [
                    'id' => 'mb_portfolio_link',
                    'name' => esc_html__('Add Custom Link for Portfolio Grid', 'atlets'),
                    'type' => 'switch'
                ],
                [
                    'name' => esc_html__('Custom Url for Portfolio Grid', 'atlets'),
                    'id' => 'portfolio_custom_url',
                    'type' => 'text',
                    'class' => 'field-inputs',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_link', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Info', 'atlets'),
                    'id' => 'mb_portfolio_info_items',
                    'type' => 'social',
                    'clone' => true,
                    'sort_clone' => true,
                    'desc' => esc_html__('Description', 'atlets'),
                    'options' => [
                        'name' => [
                            'name' => esc_html__('Name', 'atlets'),
                            'type_input' => 'text'
                        ],
                        'description' => [
                            'name' => esc_html__('Description', 'atlets'),
                            'type_input' => 'text'
                        ],
                        'link' => [
                            'name' => esc_html__('Url', 'atlets'),
                            'type_input' => 'text'
                        ]
                    ]
                ],
                [
                    'name' => esc_html__('Categories', 'atlets'),
                    'id' => 'mb_portfolio_single_meta_categories',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'yes' => esc_html__('Use', 'atlets'),
                        'no' => esc_html__('Hide', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Date', 'atlets'),
                    'id' => 'mb_portfolio_single_meta_date',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'yes' => esc_html__('Use', 'atlets'),
                        'no' => esc_html__('Hide', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Tags', 'atlets'),
                    'id' => 'mb_portfolio_above_content_cats',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'yes' => esc_html__('Use', 'atlets'),
                        'no' => esc_html__('Hide', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Share Links', 'atlets'),
                    'id' => 'mb_portfolio_above_content_share',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'yes' => esc_html__('Use', 'atlets'),
                        'no' => esc_html__('Hide', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function portfolio_post_settings_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Portfolio Post Settings', 'atlets'),
            'post_types' => ['portfolio'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Post Layout', 'atlets'),
                    'id' => 'mb_portfolio_post_conditional',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Post Layout Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_post_conditional', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Layout', 'atlets'),
                    'id' => 'mb_portfolio_single_type_layout',
                    'type' => 'button_group',
                    'multiple' => false,
                    'options' => [
                        '1' => esc_html__('Title First', 'atlets'),
                        '2' => esc_html__('Image First', 'atlets')
                    ],
                    'std' => '2',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_post_conditional', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Alignment', 'atlets'),
                    'id' => 'mb_portfolio_single_align',
                    'type' => 'button_group',
                    'multiple' => false,
                    'options' => [
                        'left' => esc_html__('Left', 'atlets'),
                        'center' => esc_html__('Center', 'atlets'),
                        'right' => esc_html__('Right', 'atlets')
                    ],
                    'std' => 'left',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_post_conditional', '=', 'custom']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function portfolio_related_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Related Portfolio', 'atlets'),
            'post_types' => ['portfolio'],
            'context' => 'advanced',
            'fields' => [
                [
                    'id' => 'mb_portfolio_related_switch',
                    'name' => esc_html__('Portfolio Related', 'atlets'),
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'on' => esc_html__('On', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'inline' => true,
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Portfolio Related Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_pf_carousel_r',
                    'name' => esc_html__('Display items carousel for this portfolio post', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Title', 'atlets'),
                    'id' => 'mb_pf_title_r',
                    'type' => 'text',
                    'std' => esc_html__('Related Portfolio', 'atlets'),
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Categories', 'atlets'),
                    'id' => 'mb_pf_cat_r',
                    'multiple' => true,
                    'type' => 'taxonomy_advanced',
                    'taxonomy' => 'portfolio-category',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Columns', 'atlets'),
                    'id' => 'mb_pf_column_r',
                    'type' => 'button_group',
                    'options' => [
                        '2' => esc_html__('2', 'atlets'),
                        '3' => esc_html__('3', 'atlets'),
                        '4' => esc_html__('4', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => '3',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Number of Related Items', 'atlets'),
                    'id' => 'mb_pf_number_r',
                    'type' => 'number',
                    'min' => 0,
                    'step' => 1,
                    'std' => 3,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_portfolio_related_switch', '=', 'on']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function blog_settings_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Post Settings', 'atlets'),
            'post_types' => ['post'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Post Layout Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('Post Layout', 'atlets'),
                    'id' => 'mb_post_layout_conditional',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Post Layout Type', 'atlets'),
                    'id' => 'mb_single_type_layout',
                    'type' => 'button_group',
                    'options' => [
                        '1' => esc_html__('Title First', 'atlets'),
                        '2' => esc_html__('Image First', 'atlets'),
                        '3' => esc_html__('Overlay Image', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => '1',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_post_layout_conditional', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Padding Top', 'atlets'),
                    'id' => 'mb_single_padding_layout_3',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => false,
                        'bottom' => true,
                        'left' => false
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_post_layout_conditional', '=', 'custom'],
                            ['mb_single_type_layout', '=', '3']
                        ]]
                    ],
                    'std' => [
                        'padding-top' => '350',
                        'padding-bottom' => '0'
                    ]
                ],
                [
                    'id' => 'mb_single_apply_animation',
                    'name' => esc_html__('Apply Animation', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_post_layout_conditional', '=', 'custom'],
                            ['mb_single_type_layout', '=', '3']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Featured Image Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('Featured Image', 'atlets'),
                    'id' => 'mb_featured_image_conditional',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Featured Image Settings', 'atlets'),
                    'id' => 'mb_featured_image_type',
                    'type' => 'button_group',
                    'options' => [
                        'off' => esc_html__('Off', 'atlets'),
                        'replace' => esc_html__('Replace', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'off',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_featured_image_conditional', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Featured Image Replace', 'atlets'),
                    'id' => 'mb_featured_image_replace',
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_featured_image_conditional', '=', 'custom'],
                            ['mb_featured_image_type', '=', 'replace']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function blog_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Post Format Layout', 'atlets'),
            'post_types' => ['post'],
            'context' => 'advanced',
            'fields' => [
                // Standard Post Format
                [
                    'name' => esc_html__('Standard Post( Enabled only Featured Image for this post format)', 'atlets'),
                    'id' => 'post_format_standard',
                    'type' => 'static-text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['formatdiv', '=', '0']
                        ]]
                    ]
                ],
                // Gallery Post Format
                [
                    'name' => esc_html__('Gallery Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('Add Images', 'atlets'),
                    'id' => 'post_format_gallery',
                    'type' => 'image_advanced',
                    'max_file_uploads' => ''
                ],
                // Video Post Format
                [
                    'name' => esc_html__('Video Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('Video Style', 'atlets'),
                    'id' => 'post_format_video_style',
                    'type' => 'select',
                    'options' => [
                        'bg_video' => esc_html__('Background Video', 'atlets'),
                        'popup' => esc_html__('Popup', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'bg_video'
                ],
                [
                    'name' => esc_html__('Start Video', 'atlets'),
                    'id' => 'start_video',
                    'type' => 'number',
                    'std' => '0',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['post_format_video_style', '=', 'bg_video']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('End Video', 'atlets'),
                    'id' => 'end_video',
                    'type' => 'number',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['post_format_video_style', '=', 'bg_video']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('oEmbed URL', 'atlets'),
                    'id' => 'post_format_video_url',
                    'type' => 'oembed'
                ],
                // Quote Post Format
                [
                    'name' => esc_html__('Quote Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('Quote Text', 'atlets'),
                    'id' => 'post_format_qoute_text',
                    'type' => 'textarea'
                ],
                [
                    'name' => esc_html__('Author Name', 'atlets'),
                    'id' => 'post_format_qoute_name',
                    'type' => 'text'
                ],
                [
                    'name' => esc_html__('Author Position', 'atlets'),
                    'id' => 'post_format_qoute_position',
                    'type' => 'text'
                ],
                [
                    'name' => esc_html__('Author Avatar', 'atlets'),
                    'id' => 'post_format_qoute_avatar',
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1
                ],
                // Audio Post Format
                [
                    'name' => esc_html__('Audio Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('oEmbed URL', 'atlets'),
                    'id' => 'post_format_audio_url',
                    'type' => 'oembed'
                ],
                // Link Post Format
                [
                    'name' => esc_html__('Link Settings', 'atlets'),
                    'type' => 'wgl_heading'
                ],
                [
                    'name' => esc_html__('URL', 'atlets'),
                    'id' => 'post_format_link_url',
                    'type' => 'url'
                ],
                [
                    'name' => esc_html__('Text', 'atlets'),
                    'id' => 'post_format_link_text',
                    'type' => 'text'
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function blog_related_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Related Blog Post', 'atlets'),
            'post_types' => ['post'],
            'context' => 'advanced',
            'fields' => [

                [
                    'name' => esc_html__('Related Options', 'atlets'),
                    'id' => 'mb_blog_show_r',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Related Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Title', 'atlets'),
                    'id' => 'mb_blog_title_r',
                    'type' => 'text',
                    'std' => esc_html__('Related Posts', 'atlets'),
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Categories', 'atlets'),
                    'id' => 'mb_blog_cat_r',
                    'multiple' => true,
                    'type' => 'taxonomy_advanced',
                    'taxonomy' => 'category',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Columns', 'atlets'),
                    'id' => 'mb_blog_column_r',
                    'type' => 'button_group',
                    'options' => [
                        '12' => esc_html__('1', 'atlets'),
                        '6' => esc_html__('2', 'atlets'),
                        '4' => esc_html__('3', 'atlets'),
                        '3' => esc_html__('4', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => '6',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Number of Related Items', 'atlets'),
                    'id' => 'mb_blog_number_r',
                    'type' => 'number',
                    'min' => 0,
                    'step' => 1,
                    'std' => 2,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_blog_carousel_r',
                    'name' => esc_html__('Display items carousel for this blog post', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_blog_show_r', '=', 'custom']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_layout_meta_boxes($meta_boxes)
    {

        $meta_boxes[] = [
            'title' => esc_html__('Page Layout', 'atlets'),
            'post_types' => ['page', 'post', 'team', 'practice', 'portfolio', 'product'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Page Sidebar Layout', 'atlets'),
                    'id' => 'mb_page_sidebar_layout',
                    'type' => 'wgl_image_select',
                    'options' => [
                        'default' => get_template_directory_uri() . '/core/admin/img/options/1c.png',
                        'none' => get_template_directory_uri() . '/core/admin/img/options/none.png',
                        'left' => get_template_directory_uri() . '/core/admin/img/options/2cl.png',
                        'right' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ],
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Sidebar Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_sidebar_layout', '!=', 'default'],
                            ['mb_page_sidebar_layout', '!=', 'none']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Sidebar', 'atlets'),
                    'id' => 'mb_page_sidebar_def',
                    'type' => 'select',
                    'placeholder' => 'Select a Sidebar',
                    'options' => atlets_get_all_sidebar(),
                    'multiple' => false,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_sidebar_layout', '!=', 'default'],
                            ['mb_page_sidebar_layout', '!=', 'none']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Sidebar Width', 'atlets'),
                    'id' => 'mb_page_sidebar_def_width',
                    'type' => 'button_group',
                    'options' => [
                        '9' => esc_html('25%'),
                        '8' => esc_html('33%')
                    ],
                    'std' => '9',
                    'multiple' => false,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_sidebar_layout', '!=', 'default'],
                            ['mb_page_sidebar_layout', '!=', 'none']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_sticky_sidebar',
                    'name' => esc_html__('Sticky Sidebar On?', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_sidebar_layout', '!=', 'default'],
                            ['mb_page_sidebar_layout', '!=', 'none']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Sidebar Side Gap', 'atlets'),
                    'id' => 'mb_sidebar_gap',
                    'type' => 'select',
                    'options' => [
                        'def' => 'Default',
                        '0' => '0',
                        '15' => '15',
                        '20' => '20',
                        '25' => '25',
                        '30' => '30',
                        '35' => '35',
                        '40' => '40',
                        '45' => '45',
                        '50' => '50'
                    ],
                    'std' => 'def',
                    'multiple' => false,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_sidebar_layout', '!=', 'default'],
                            ['mb_page_sidebar_layout', '!=', 'none']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_color_meta_boxes($meta_boxes)
    {

        $meta_boxes[] = [
            'title' => esc_html__('Page Colors', 'atlets'),
            'post_types' => ['page', 'post', 'team', 'practice', 'portfolio'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Page Colors', 'atlets'),
                    'id' => 'mb_page_colors_switch',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'inline' => true,
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Colors Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Primary Theme Color', 'atlets'),
                    'id' => 'mb_page_theme_color',
                    'type' => 'color',
                    'std' => '#ff6b22',
                    'js_options' => ['defaultColor' => '#ff6b22'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Secondary Theme Color', 'atlets'),
                    'id' => 'page_theme_secondary_color',
                    'type' => 'color',
                    'std' => '#3fd0d4',
                    'js_options' => ['defaultColor' => '#3fd0d4'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Tertiary Theme Color', 'atlets'),
                    'id' => 'page_theme_tertiary_color',
                    'type' => 'color',
                    'std' => '#00172b',
                    'js_options' => ['defaultColor' => '#00172b'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Body Background Color', 'atlets'),
                    'id' => 'mb_body_background_color',
                    'type' => 'color',
                    'std' => '#ffffff',
                    'js_options' => ['defaultColor' => '#ffffff'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Button Idle Color', 'atlets'),
                    'id' => 'page_button_idle_color',
                    'type' => 'color',
                    'std' => '#ff6b22',
                    'js_options' => ['defaultColor' => '#ff6b22'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Button Hover Color', 'atlets'),
                    'id' => 'page_button_hover_color',
                    'type' => 'color',
                    'std' => '#3fd0d4',
                    'js_options' => ['defaultColor' => '#3fd0d4'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Scroll Up Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Button Background Color', 'atlets'),
                    'id' => 'mb_scroll_up_bg_color',
                    'type' => 'color',
                    'std' => '#3fd0d4',
                    'js_options' => ['defaultColor' => '#3fd0d4'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Button Arrow Color', 'atlets'),
                    'id' => 'mb_scroll_up_arrow_color',
                    'type' => 'color',
                    'std' => '#ffffff',
                    'js_options' => ['defaultColor' => '#ffffff'],
                    'validate' => 'color',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_colors_switch', '=', 'custom']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_header_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Header', 'atlets'),
            'post_types' => ['page', 'post', 'portfolio', 'product'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Header Settings', 'atlets'),
                    'id' => 'mb_customize_header_layout',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('default', 'atlets'),
                        'custom' => esc_html__('custom', 'atlets'),
                        'hide' => esc_html__('hide', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Header Template', 'atlets'),
                    'id' => 'mb_header_content_type',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Template', 'atlets'),
                    'id' => 'mb_customize_header',
                    'type' => 'post',
                    'post_type' => 'header',
                    'query_args' => [
                        'post_status' => 'publish',
                        'posts_per_page' => -1
                    ],
                    'multiple' => false,
                    'std' => 'default',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom'],
                            ['mb_header_content_type', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_header_sticky',
                    'name' => esc_html__('Sticky Header', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Sticky Header Template', 'atlets'),
                    'id' => 'mb_sticky_header_content_type',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom'],
                            ['mb_header_sticky', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Template', 'atlets'),
                    'id' => 'mb_customize_sticky_header',
                    'type' => 'post',
                    'post_type' => 'header',
                    'query_args' => [
                        'post_status' => 'publish',
                        'posts_per_page' => -1
                    ],
                    'multiple' => false,
                    'std' => 'default',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom'],
                            ['mb_sticky_header_content_type', '=', 'custom'],
                            ['mb_header_sticky', '=', '1']
                        ]]
                    ]
                ],
                // It is works
                [
                    'id' => 'mb_mobile_menu_header',
                    'name' => esc_html__('Mobile Menu ', 'atlets'),
                    'type' => 'select',
                    'options' => atlets_get_custom_menu(),
                    'multiple' => false,
                    'std' => 'default',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_header_layout', '=', 'custom']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_title_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Page Title', 'atlets'),
            'post_types' => ['page', 'post', 'team', 'practice', 'portfolio', 'product'],
            'context' => 'advanced',
            'fields' => [
                [
                    'id' => 'mb_page_title_switch',
                    'name' => esc_html__('Page Title', 'atlets'),
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'on' => esc_html__('On', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'std' => 'default',
                    'inline' => true,
                    'multiple' => false
                ],
                [
                    'name' => esc_html__('Page Title Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_bg_switch',
                    'name' => esc_html__('Use Background?', 'atlets'),
                    'type' => 'switch',
                    'std' => true,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_bg',
                    'name' => esc_html__('Background', 'atlets'),
                    'type' => 'wgl_background',
                    'image' => '',
                    'position' => 'center bottom',
                    'attachment' => 'scroll',
                    'size' => 'cover',
                    'repeat' => 'no-repeat',
                    'color' => '#00182c',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_bg_switch', '=', true]
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Height', 'atlets'),
                    'id' => 'mb_page_title_height',
                    'type' => 'number',
                    'std' => 400,
                    'min' => 0,
                    'step' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_bg_switch', '=', true]
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Title Alignment', 'atlets'),
                    'id' => 'mb_page_title_align',
                    'type' => 'button_group',
                    'options' => [
                        'left' => esc_html__('left', 'atlets'),
                        'center' => esc_html__('center', 'atlets'),
                        'right' => esc_html__('right', 'atlets')
                    ],
                    'std' => 'center',
                    'multiple' => false,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Paddings Top/Bottom', 'atlets'),
                    'id' => 'mb_page_title_padding',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => false,
                        'bottom' => true,
                        'left' => false
                    ],
                    'std' => [
                        'padding-top' => '76',
                        'padding-bottom' => '80'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Margin Bottom', 'atlets'),
                    'id' => 'mb_page_title_margin',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'margin',
                        'top' => false,
                        'right' => false,
                        'bottom' => true,
                        'left' => false
                    ],
                    'std' => ['margin-bottom' => '50'],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_border_switch',
                    'name' => esc_html__('Border Top Switch', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Border Top Color', 'atlets'),
                    'id' => 'mb_page_title_border_color',
                    'type' => 'color',
                    'std' => '#e5e5e5',
                    'js_options' => ['defaultColor' => '#e5e5e5'],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_border_switch', '=', true]
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_parallax',
                    'name' => esc_html__('Parallax Switch', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Prallax Speed', 'atlets'),
                    'id' => 'mb_page_title_parallax_speed',
                    'type' => 'number',
                    'std' => 0.3,
                    'step' => 0.1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_parallax', '=', true],
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_change_tile_switch',
                    'name' => esc_html__('Custom Page Title', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Title', 'atlets'),
                    'id' => 'mb_page_change_tile',
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_change_tile_switch', '=', '1'],
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_breadcrumbs_switch',
                    'name' => esc_html__('Show Breadcrumbs', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Breadcrumbs Alignment', 'atlets'),
                    'id' => 'mb_page_title_breadcrumbs_align',
                    'type' => 'button_group',
                    'options' => [
                        'left' => esc_html__('left', 'atlets'),
                        'center' => esc_html__('center', 'atlets'),
                        'right' => esc_html__('right', 'atlets')
                    ],
                    'std' => 'center',
                    'multiple' => false,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_breadcrumbs_switch', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Breadcrumbs Full Width', 'atlets'),
                    'id' => 'mb_page_title_breadcrumbs_block_switch',
                    'type' => 'switch',
                    'std' => true,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_breadcrumbs_switch', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Title Typography', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Title Font', 'atlets'),
                    'id' => 'mb_page_title_font',
                    'type' => 'wgl_font',
                    'options' => [
                        'font-size' => true,
                        'line-height' => true,
                        'font-weight' => false,
                        'color' => true
                    ],
                    'std' => [
                        'font-size' => '48',
                        'line-height' => '62',
                        'color' => '#ffffff'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Title Breadcrumbs Font', 'atlets'),
                    'id' => 'mb_page_title_breadcrumbs_font',
                    'type' => 'wgl_font',
                    'options' => [
                        'font-size' => true,
                        'line-height' => true,
                        'font-weight' => false,
                        'color' => true
                    ],
                    'std' => [
                        'font-size' => '14',
                        'line-height' => '24',
                        'color' => '#ffffff'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Responsive Layout', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_resp_switch',
                    'name' => esc_html__('Responsive Layout On/Off', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Screen breakpoint', 'atlets'),
                    'id' => 'mb_page_title_resp_resolution',
                    'type' => 'number',
                    'min' => 1,
                    'step' => 1,
                    'std' => 768,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_resp_switch', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Padding Top/Bottom', 'atlets'),
                    'id' => 'mb_page_title_resp_padding',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => false,
                        'bottom' => true,
                        'left' => false
                    ],
                    'std' => [
                        'padding-top' => '30',
                        'padding-bottom' => '30'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_resp_switch', '=', '1']
                        ]]
                    ]
                ],
	            [
		            'name' => esc_html__('Margin Bottom', 'atlets'),
		            'id' => 'mb_page_title_resp_margin',
		            'type' => 'wgl_offset',
		            'options' => [
			            'mode' => 'margin',
			            'top' => false,
			            'right' => false,
			            'bottom' => true,
			            'left' => false
		            ],
		            'std' => ['margin-bottom' => '10'],
		            'attributes' => [
			            'data-conditional-logic' => [[
				            ['mb_page_title_switch', '=', 'on'],
				            ['mb_page_title_resp_switch', '=', '1']
			            ]]
		            ]
	            ],
                [
                    'name' => esc_html__('Page Title Font', 'atlets'),
                    'id' => 'mb_page_title_resp_font',
                    'type' => 'wgl_font',
                    'options' => [
                        'font-size' => true,
                        'line-height' => true,
                        'font-weight' => false,
                        'color' => true
                    ],
                    'std' => [
                        'font-size' => '38',
                        'line-height' => '48',
                        'color' => '#ffffff'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_resp_switch', '=', '1']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_page_title_resp_breadcrumbs_switch',
                    'name' => esc_html__('Show Breadcrumbs', 'atlets'),
                    'type' => 'switch',
                    'std' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_resp_switch', '=', '1']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Page Title Breadcrumbs Font', 'atlets'),
                    'id' => 'mb_page_title_resp_breadcrumbs_font',
                    'type' => 'wgl_font',
                    'options' => [
                        'font-size' => true,
                        'line-height' => true,
                        'font-weight' => false,
                        'color' => true
                    ],
                    'std' => [
                        'font-size' => '14',
                        'line-height' => '24',
                        'color' => '#ffffff'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_page_title_switch', '=', 'on'],
                            ['mb_page_title_resp_switch', '=', '1'],
                            ['mb_page_title_resp_breadcrumbs_switch', '=', '1']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_side_panel_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Side Panel', 'atlets'),
            'post_types' => ['page'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Side Panel', 'atlets'),
                    'id' => 'mb_customize_side_panel',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'custom' => esc_html__('Custom', 'atlets')
                    ],
                    'multiple' => false,
                    'inline' => true,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Side Panel Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Content Type', 'atlets'),
                    'id' => 'mb_side_panel_content_type',
                    'type' => 'button_group',
                    'options' => [
                        'widgets' => esc_html__('Widgets', 'atlets'),
                        'pages' => esc_html__('Page', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'widgets',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Select a page', 'atlets'),
                    'id' => 'mb_side_panel_page_select',
                    'type' => 'post',
                    'post_type' => 'side_panel',
                    'field_type' => 'select_advanced',
                    'placeholder' => 'Select a page',
                    'query_args' => [
                        'post_status' => 'publish',
                        'posts_per_page' => -1
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom'],
                            ['mb_side_panel_content_type', '=', 'pages']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Paddings', 'atlets'),
                    'id' => 'mb_side_panel_spacing',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => true,
                        'bottom' => true,
                        'left' => true
                    ],
                    'std' => [
                        'padding-top' => '105',
                        'padding-right' => '90',
                        'padding-bottom' => '105',
                        'padding-left' => '90'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Title Color', 'atlets'),
                    'id' => 'mb_side_panel_title_color',
                    'type' => 'color',
                    'std' => '#ffffff',
                    'js_options' => ['defaultColor' => '#ffffff'],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Text Color', 'atlets'),
                    'id' => 'mb_side_panel_text_color',
                    'type' => 'color',
                    'std' => '#313538',
                    'js_options' => ['defaultColor' => '#313538'],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Background Color', 'atlets'),
                    'id' => 'mb_side_panel_bg',
                    'type' => 'color',
                    'std' => '#ffffff',
                    'alpha_channel' => true,
                    'js_options' => ['defaultColor' => '#ffffff'],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Text Align', 'atlets'),
                    'id' => 'mb_side_panel_text_alignment',
                    'type' => 'button_group',
                    'options' => [
                        'left' => esc_html__('Left', 'atlets'),
                        'center' => esc_html__('Center', 'atlets'),
                        'right' => esc_html__('Right', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'center',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Width', 'atlets'),
                    'id' => 'mb_side_panel_width',
                    'type' => 'number',
                    'min' => 0,
                    'step' => 1,
                    'std' => 480,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Position', 'atlets'),
                    'id' => 'mb_side_panel_position',
                    'type' => 'button_group',
                    'options' => [
                        'left' => esc_html__('Left', 'atlets'),
                        'right' => esc_html__('Right', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'right',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_side_panel', '=', 'custom']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_markers_meta_boxes($meta_boxes)
    {
        $new  = array();
        $meta_boxes[] = [
            'title' => esc_html__('Page Markers', 'atlets'),
            'post_types' => ['page'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Page Markers', 'atlets'),
                    'id' => "mb_customize_markers",
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'on' => esc_html__('On', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'multiple' => false,
                    'inline' => true,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Offset Top(in percentage)', 'atlets'),
                    'id' => 'mb_page_marker_offset',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'margin',
                        'top' => true,
                        'right' => false,
                        'bottom' => false,
                        'left' => false
                    ],
                    'std' => [
                        'margin-top' => '40'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_1',
                    'name' => esc_html__('Add Marker 1', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_1",
                    'name' => esc_html__('Marker Image 1', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_1', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_1',
                    'name' => esc_html__('Marker Title 1', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_1', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_1',
                    'name' => esc_html__('Marker Link 1', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_1', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_2',
                    'name' => esc_html__('Add Marker 2', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_2",
                    'name' => esc_html__('Marker Image 2', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_2', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_2',
                    'name' => esc_html__('Marker title 2', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_2', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_2',
                    'name' => esc_html__('Marker Link 2', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_2', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_3',
                    'name' => esc_html__('Add Marker 3', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_3",
                    'name' => esc_html__('Marker Image 3', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_3', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_3',
                    'name' => esc_html__('Marker Title 3', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_3', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_3',
                    'name' => esc_html__('Marker Link 3', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_3', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_4',
                    'name' => esc_html__('Add Marker 4', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_4",
                    'name' => esc_html__('Marker Image 4', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_4', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_4',
                    'name' => esc_html__('Marker Title 4', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_4', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_4',
                    'name' => esc_html__('Marker Link 4', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_4', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_5',
                    'name' => esc_html__('Add Marker 5', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_5",
                    'name' => esc_html__('Marker Image 5', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_5', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_5',
                    'name' => esc_html__('Marker Title 5', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_5', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_5',
                    'name' => esc_html__('Marker Link 5', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_5', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_add_marker_6',
                    'name' => esc_html__('Add Marker 6', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => "mb_marker_image_6",
                    'name' => esc_html__('Marker Image 6', 'atlets'),
                    'type' => 'image_advanced',
                    'max_file_uploads' => 1,
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_6', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_title_6',
                    'name' => esc_html__('Marker Title 6', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_6', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_marker_link_6',
                    'name' => esc_html__('Marker Link 6', 'atlets'),
                    'type' => 'text',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_add_marker_6', '=', '1'],
                            ['mb_customize_markers', '=', 'on']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_footer_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Footer', 'atlets'),
            'post_types' => ['page'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Footer', 'atlets'),
                    'id' => 'mb_footer_switch',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'on' => esc_html__('On', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Footer Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Content Type', 'atlets'),
                    'id' => 'mb_footer_content_type',
                    'type' => 'button_group',
                    'options' => [
                        'widgets' => esc_html__('Widgets', 'atlets'),
                        'pages' => esc_html__('Page', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'pages',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Select a page', 'atlets'),
                    'id' => 'mb_footer_page_select',
                    'type' => 'post',
                    'post_type' => 'footer',
                    'field_type' => 'select_advanced',
                    'placeholder' => 'Select a page',
                    'query_args' => [
                        'post_status' => 'publish',
                        'posts_per_page' => -1
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on'],
                            ['mb_footer_content_type', '=', 'pages']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Paddings', 'atlets'),
                    'id' => 'mb_footer_spacing',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => true,
                        'bottom' => true,
                        'left' => true
                    ],
                    'std' => [
                        'padding-top' => '0',
                        'padding-right' => '0',
                        'padding-bottom' => '0',
                        'padding-left' => '0'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on'],
                            ['mb_footer_content_type', '=', 'widgets']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Background', 'atlets'),
                    'id' => 'mb_footer_bg',
                    'type' => 'wgl_background',
                    'image' => '',
                    'position' => 'center center',
                    'attachment' => 'scroll',
                    'size' => 'cover',
                    'repeat' => 'no-repeat',
                    'color' => '#ffffff',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on'],
                            ['mb_footer_content_type', '=', 'widgets']
                        ]]
                    ]
                ],
                [
                    'id' => 'mb_footer_add_border',
                    'name' => esc_html__('Add Border Top', 'atlets'),
                    'type' => 'switch',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on'],
                            ['mb_footer_content_type', '=', 'widgets']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Border Color', 'atlets'),
                    'id' => 'mb_footer_border_color',
                    'type' => 'color',
                    'std' => '#e5e5e5',
                    'alpha_channel' => true,
                    'js_options' => [
                        'defaultColor' => '#e5e5e5'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_footer_switch', '=', 'on'],
                            ['mb_footer_add_border', '=', '1']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }

    public function page_copyright_meta_boxes($meta_boxes)
    {
        $meta_boxes[] = [
            'title' => esc_html__('Copyright', 'atlets'),
            'post_types' => ['page'],
            'context' => 'advanced',
            'fields' => [
                [
                    'name' => esc_html__('Copyright', 'atlets'),
                    'id' => 'mb_copyright_switch',
                    'type' => 'button_group',
                    'options' => [
                        'default' => esc_html__('Default', 'atlets'),
                        'on' => esc_html__('On', 'atlets'),
                        'off' => esc_html__('Off', 'atlets')
                    ],
                    'multiple' => false,
                    'std' => 'default'
                ],
                [
                    'name' => esc_html__('Copyright Settings', 'atlets'),
                    'type' => 'wgl_heading',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_copyright_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Editor', 'atlets'),
                    'id' => 'mb_copyright_editor',
                    'type' => 'textarea',
                    'cols' => 20,
                    'rows' => 3,
                    'std' => 'Copyright © 2021 Atlets by WebGeniusLab. All Rights Reserved',
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_copyright_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Text Color', 'atlets'),
                    'id' => 'mb_copyright_text_color',
                    'type' => 'color',
                    'std' => '#838383',
                    'js_options' => [
                        'defaultColor' => '#838383'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_copyright_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Background Color', 'atlets'),
                    'id' => 'mb_copyright_bg_color',
                    'type' => 'color',
                    'std' => '#171a1e',
                    'js_options' => [
                        'defaultColor' => '#171a1e'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_copyright_switch', '=', 'on']
                        ]]
                    ]
                ],
                [
                    'name' => esc_html__('Paddings', 'atlets'),
                    'id' => 'mb_copyright_spacing',
                    'type' => 'wgl_offset',
                    'options' => [
                        'mode' => 'padding',
                        'top' => true,
                        'right' => false,
                        'bottom' => true,
                        'left' => false
                    ],
                    'std' => [
                        'padding-top' => '10',
                        'padding-bottom' => '10'
                    ],
                    'attributes' => [
                        'data-conditional-logic' => [[
                            ['mb_copyright_switch', '=', 'on']
                        ]]
                    ]
                ]
            ]
        ];
        return $meta_boxes;
    }
}

new Atlets_Metaboxes();
