<?php

if (!class_exists('Atlets_Core')) {
    return;
}

if (!function_exists('wgl_get_redux_icons')) {
    function wgl_get_redux_icons()
    {
        return WglAdminIcon()->get_icons_name(true);
    }

    add_filter('redux/font-icons', 'wgl_get_redux_icons');
}

if (!function_exists('atlets_redux_get_custom_menu')) {
    function atlets_redux_get_custom_menu()
    {
        $taxonomies = [];

        $menus = get_terms('nav_menu');
        foreach ($menus as $key => $value) {
            $taxonomies[$value->name] = $value->name;
        }
        return $taxonomies;
    }
}

if (!function_exists('atlets_quick_tip')) {
    /**
     * Display HTML of QuickTip element.
     *
     * @since 1.0.0
     *
     * @param string $tip
     * @param bool   $echo
     * @param array  $options
     *
     * @return string
     */
    function atlets_quick_tip($tip, $echo = false, $options = [])
    {
        $tip = sprintf(
            '<span class="atlets-tip">'
            . '<i class="tip-icon el el-question-sign"></i>'
            . '<span class="tip-content">%s</span>'
            . '</span>',
            $tip
        );

        if ($echo) {
            echo esc_html($tip);
            return;
        }

        return $tip;
    }
}

//* This is theme option name where all the Redux data is stored.
$theme_slug = 'atlets_set';

/**
 * Set all the possible arguments for Redux
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$theme = wp_get_theme();

Redux::setArgs($theme_slug, [
    'opt_name' => $theme_slug, //* This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'), //* Name that appears at the top of your panel
    'display_version' => $theme->get('Version'), //* Version that appears at the top of your panel
    'menu_type' => 'menu', //* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true, //* Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Theme Options', 'atlets'),
    'page_title' => esc_html__('Theme Options', 'atlets'),
    'google_api_key' => '', //* You will need to generate a Google API key to use this feature. Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_update_weekly' => false, //* Set it you want google fonts to update weekly. A google_api_key value is required.
    'async_typography' => false, //* Must be defined to add google fonts to the typography module
    'admin_bar' => true, //* Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-admin-generic', //* Choose an icon for the admin bar menu
    'admin_bar_priority' => 50, //* Choose an priority for the admin bar menu
    'global_variable' => '', //* Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    'update_notice' => true, //* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    'page_priority' => 3, //* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'wgl-dashboard-panel', //* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options', //* Permissions needed to access the options panel.
    'menu_icon' => 'dashicons-admin-generic', //* Specify a custom URL to an icon
    'last_tab' => '', //* Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes', //* Icon displayed in the admin panel next to your menu_title
    'page_slug' => 'wgl-theme-options-panel', //* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true, //* On load save the defaults to DB before user clicks save or not
    'default_show' => false, //* If true, shows the default value next to each field that is not the default value.
    'default_mark' => '', //* What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true, //* Shows the Import/Export panel when not used as a field.
    'transient_time' => 60 * MINUTE_IN_SECONDS, //* Show the time the page took to load, etc
    'output' => true, //* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true, //* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '', //* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
]);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'general',
        'title' => esc_html__('General', 'atlets'),
        'icon' => 'el el-cog',
        'fields' => [
            [
                'id' => 'use_minified',
                'title' => esc_html__('Use minified css/js files', 'atlets'),
                'type' => 'switch',
                'desc' => esc_html__('Speed up your site load.', 'atlets'),
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
            ],
            [
                'id' => 'preloader-start',
                'title' => esc_html__('Preloader', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'preloader',
                'title' => esc_html__('Preloader', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'preloader_background',
                'title' => esc_html__('Preloader Background', 'atlets'),
                'type' => 'color',
                'required' => ['preloader', '=', '1'],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'preloader_color',
                'title' => esc_html__('Preloader Color', 'atlets'),
                'type' => 'color',
                'required' => ['preloader', '=', '1'],
                'transparent' => false,
                'default' => '#ff7029',
            ],
            [
                'id' => 'preloader-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'search_settings',
                'type' => 'section',
                'title' => esc_html__('Search', 'atlets'),
                'indent' => true,
            ],
            [
                'id' => 'search_style',
                'title' => esc_html__('Choose search style', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'standard' => esc_html__('Standard', 'atlets'),
                    'alt' => esc_html__('Full Page Width', 'atlets'),
                ],
                'default' => 'standard',
            ],
            [
                'id' => 'search_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'scroll_up_settings',
                'title' => esc_html__('Scroll Up Button', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'scroll_up',
                'title' => esc_html__('Button', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Disable', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'scroll_up_appearance',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'switch',
                'required' => ['scroll_up', '=', true],
                'on' => esc_html__('Text', 'atlets'),
                'off' => esc_html__('Icon', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'scroll_up_arrow_color',
                'title' => esc_html__('Text/Icon Color', 'atlets'),
                'type' => 'color',
                'required' => ['scroll_up', '=', true],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'scroll_up_bg_color',
                'title' => esc_html__('Background Color', 'atlets'),
                'type' => 'color',
                'required' => ['scroll_up', '=', true],
                'transparent' => false,
                'default' => '#29B3B7',
            ],
            [
                'id' => 'scroll_up_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
        ],
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'editors-option',
        'title' => esc_html__('Custom JS', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'custom_js',
                'title' => esc_html__('Custom JS', 'atlets'),
                'type' => 'ace_editor',
                'subtitle' => esc_html__('Paste your JS code here.', 'atlets'),
                'mode' => 'javascript',
                'theme' => 'chrome',
                'default' => ''
            ],
            [
                'id' => 'header_custom_js',
                'title' => esc_html__('Custom JS', 'atlets'),
                'type' => 'ace_editor',
                'subtitle' => esc_html__('Code to be added inside HEAD tag', 'atlets'),
                'mode' => 'html',
                'theme' => 'chrome',
                'default' => ''
            ],
        ],
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'header_section',
        'title' => esc_html__('Header', 'atlets'),
        'icon' => 'fas fa-window-maximize',
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Logo', 'atlets'),
        'id' => 'logo',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'header_logo',
                'type' => 'media',
                'title' => esc_html__('Header Logo', 'atlets')
            ],
            [
                'id' => 'logo_height_custom',
                'type' => 'switch',
                'title' => esc_html__('Enable Logo Height', 'atlets'),
                'default' => false
            ],
            [
                'id' => 'logo_height',
                'type' => 'dimensions',
                'units' => 'px',
                'units_extended' => false,
                'title' => esc_html__('Logo Height', 'atlets'),
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
                'required' => ['logo_height_custom', '=', '1']
            ],
            [
                'id' => 'logo_sticky',
                'type' => 'media',
                'title' => esc_html__('Sticky Logo', 'atlets')
            ],
            [
                'id' => 'sticky_logo_height_custom',
                'type' => 'switch',
                'title' => esc_html__('Enable Sticky Logo Height', 'atlets'),
                'default' => false
            ],
            [
                'id' => 'sticky_logo_height',
                'type' => 'dimensions',
                'units' => 'px',
                'units_extended' => false,
                'title' => esc_html__('Sticky Logo Height', 'atlets'),
                'height' => true,
                'width' => false,
                'default' => ['height' => ''],
                'required' => [
                    ['sticky_logo_height_custom', '=', '1']
                ]
            ],
            [
                'id' => 'logo_mobile',
                'type' => 'media',
                'title' => esc_html__('Mobile Logo', 'atlets')
            ],
            [
                'id' => 'mobile_logo_height_custom',
                'type' => 'switch',
                'title' => esc_html__('Enable Mobile Logo Height', 'atlets'),
                'default' => false
            ],
            [
                'id' => 'mobile_logo_height',
                'type' => 'dimensions',
                'units' => 'px',
                'units_extended' => false,
                'title' => esc_html__('Mobile Logo Height', 'atlets'),
                'height' => true,
                'width' => false,
                'default' => ['height' => ''],
                'required' => [
                    ['mobile_logo_height_custom', '=', '1']
                ]
            ],
            [
                'id' => 'logo_mobile_menu',
                'type' => 'media',
                'title' => esc_html__('Mobile Menu Logo', 'atlets')
            ],
            [
                'id' => 'mobile_logo_menu_height_custom',
                'type' => 'switch',
                'title' => esc_html__('Enable Mobile Menu Logo Height', 'atlets'),
                'default' => false
            ],
            [
                'id' => 'mobile_logo_menu_height',
                'type' => 'dimensions',
                'units' => 'px',
                'units_extended' => false,
                'title' => esc_html__('Mobile Menu Logo Height', 'atlets'),
                'height' => true,
                'width' => false,
                'default' => ['height' => ''],
                'required' => [
                    ['mobile_logo_menu_height_custom', '=', '1']
                ]
            ]
        ]
    ]
);

$header_builder_items = [
    'default' => [
        'html1' => ['title' => esc_html__('HTML 1', 'atlets'), 'settings' => true],
        'html2' => ['title' => esc_html__('HTML 2', 'atlets'), 'settings' => true],
        'html3' => ['title' => esc_html__('HTML 3', 'atlets'), 'settings' => true],
        'html4' => ['title' => esc_html__('HTML 4', 'atlets'), 'settings' => true],
        'html5' => ['title' => esc_html__('HTML 5', 'atlets'), 'settings' => true],
        'html6' => ['title' => esc_html__('HTML 6', 'atlets'), 'settings' => true],
        'html7' => ['title' => esc_html__('HTML 7', 'atlets'), 'settings' => true],
        'html8' => ['title' => esc_html__('HTML 8', 'atlets'), 'settings' => true],
        'delimiter1' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'delimiter2' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'delimiter3' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'delimiter4' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'delimiter5' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'delimiter6' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
        'spacer1' => ['title' => esc_html__('Spacer 1', 'atlets'), 'settings' => true],
        'spacer2' => ['title' => esc_html__('Spacer 2', 'atlets'), 'settings' => true],
        'spacer3' => ['title' => esc_html__('Spacer 3', 'atlets'), 'settings' => true],
        'spacer4' => ['title' => esc_html__('Spacer 4', 'atlets'), 'settings' => true],
        'spacer5' => ['title' => esc_html__('Spacer 5', 'atlets'), 'settings' => true],
        'spacer6' => ['title' => esc_html__('Spacer 6', 'atlets'), 'settings' => true],
        'spacer7' => ['title' => esc_html__('Spacer 7', 'atlets'), 'settings' => true],
        'spacer8' => ['title' => esc_html__('Spacer 8', 'atlets'), 'settings' => true],
        'button1' => ['title' => esc_html__('Button', 'atlets'), 'settings' => true],
        'button2' => ['title' => esc_html__('Button', 'atlets'), 'settings' => true],
        'wpml' => ['title' => esc_html__('WPML/Polylang', 'atlets'), 'settings' => false],
        'cart' => ['title' => esc_html__('Cart', 'atlets'), 'settings' => true],
        'login' => ['title' => esc_html__('Login', 'atlets'), 'settings' => false],
        'side_panel' => ['title' => esc_html__('Side Panel', 'atlets'), 'settings' => true],
    ],
    'mobile' => [
        'html1' => esc_html__('HTML 1', 'atlets'),
        'html2' => esc_html__('HTML 2', 'atlets'),
        'html3' => esc_html__('HTML 3', 'atlets'),
        'html4' => esc_html__('HTML 4', 'atlets'),
        'html5' => esc_html__('HTML 5', 'atlets'),
        'html6' => esc_html__('HTML 6', 'atlets'),
        'spacer1' => esc_html__('Spacer 1', 'atlets'),
        'spacer2' => esc_html__('Spacer 2', 'atlets'),
        'spacer3' => esc_html__('Spacer 3', 'atlets'),
        'spacer4' => esc_html__('Spacer 4', 'atlets'),
        'spacer5' => esc_html__('Spacer 5', 'atlets'),
        'spacer6' => esc_html__('Spacer 6', 'atlets'),
        'side_panel' => esc_html__('Side Panel', 'atlets'),
        'wpml' => esc_html__('WPML/Polylang', 'atlets'),
        'cart' => esc_html__('Cart', 'atlets'),
        'login' => esc_html__('Login', 'atlets'),
    ],
    'mobile_drawer' => [
        'html1' => esc_html__('HTML 1', 'atlets'),
        'html2' => esc_html__('HTML 2', 'atlets'),
        'html3' => esc_html__('HTML 3', 'atlets'),
        'html4' => esc_html__('HTML 4', 'atlets'),
        'html5' => esc_html__('HTML 5', 'atlets'),
        'html6' => esc_html__('HTML 6', 'atlets'),
        'wpml' => esc_html__('WPML/Polylang', 'atlets'),
        'spacer1' => esc_html__('Spacer 1', 'atlets'),
        'spacer2' => esc_html__('Spacer 2', 'atlets'),
        'spacer3' => esc_html__('Spacer 3', 'atlets'),
        'spacer4' => esc_html__('Spacer 4', 'atlets'),
        'spacer5' => esc_html__('Spacer 5', 'atlets'),
        'spacer6' => esc_html__('Spacer 6', 'atlets'),
    ],
];

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Header Builder', 'atlets'),
        'id' => 'header-customize',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'header_switch',
                'title' => esc_html__('Header', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Disable', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'header_type',
                'type' => 'select',
                'title' => esc_html__('Layout Building Tool', 'atlets'),
                'desc' => esc_html__('Custom Builder allows create templates within Elementor environment.', 'atlets'),
                'options' => [
                    'default' => esc_html__('Default Builder', 'atlets'),
                    'custom' => esc_html__('Custom Builder ( Recommended )', 'atlets')
                ],
                'default' => 'default',
                'required' => ['header_switch', '=', '1'],
            ],
            [
                'id' => 'header_page_select',
                'type' => 'select',
                'title' => esc_html__('Header Template', 'atlets'),
                'required' => ['header_type', '=', 'custom'],
                'desc' => sprintf(
                    '%s <a href="%s" target="_blank">%s</a> %s',
                    esc_html__('Selected Template will be used for all pages by default. You can edit/create Header Template in the', 'atlets'),
                    admin_url('edit.php?post_type=header'),
                    esc_html__('Header Templates', 'atlets'),
                    esc_html__('dashboard tab.', 'atlets')
                ),
                'data' => 'posts',
                'args' => [
                    'post_type' => 'header',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'bottom_header_layout',
                'type' => 'custom_header_builder',
                'title' => esc_html__('Header Builder', 'atlets'),
                'required' => ['header_type', '=', 'default'],
                'compiler' => 'true',
                'full_width' => true,
                'default' => [
                    'items' => $header_builder_items['default'],
                    'Top Left area' => [],
                    'Top Center area' => [],
                    'Top Right area' => [],
                    'Middle Left area' => [
                        'spacer1' => ['title' => esc_html__('Spacer 1', 'atlets'), 'settings' => true],
                        'logo' => ['title' => esc_html__('Logo', 'atlets'), 'settings' => false],
                    ],
                    'Middle Center area' => [
                        'menu' => ['title' => esc_html__('Menu', 'atlets'), 'settings' => false],
                    ],
                    'Middle Right area' => [
                        'html1' => ['title' => esc_html__('HTML 1', 'atlets'), 'settings' => true],
                        'delimiter1' => ['title' => esc_html__('|', 'atlets'), 'settings' => true],
                        'item_search' => ['title' => esc_html__('Search', 'atlets'), 'settings' => true],
                        'spacer2' => ['title' => esc_html__('Spacer 2', 'atlets'), 'settings' => true],
                    ],
                    'Bottom Left area' => [],
                    'Bottom Center area' => [],
                    'Bottom Right area' => [],
                ],
            ],
            [
                'id' => 'bottom_header_spacer1',
                'title' => esc_html__('Header Spacer 1 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 50],
            ],
            [
                'id' => 'bottom_header_spacer2',
                'title' => esc_html__('Header Spacer 2 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 50],
            ],
            [
                'id' => 'bottom_header_spacer3',
                'title' => esc_html__('Header Spacer 3 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer4',
                'title' => esc_html__('Header Spacer 4 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer5',
                'title' => esc_html__('Header Spacer 5 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer6',
                'title' => esc_html__('Header Spacer 6 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer7',
                'title' => esc_html__('Header Spacer 7 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer8',
                'title' => esc_html__('Header Spacer 8 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_item_search_custom',
                'title' => esc_html__('Customize Search', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_item_search_color_txt',
                'title' => esc_html__('Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_item_search_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33,1)'
                ],
            ],
            [
                'id' => 'bottom_header_item_search_hover_color_txt',
                'title' => esc_html__('Hover Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_item_search_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_item_search_custom_sticky',
                'type' => 'switch',
                'title' => esc_html__('Customize Sticky Search', 'atlets'),
                'default' => false,
                'required' => ['header_type', '=', 'default']
            ],
            [
                'id' => 'bottom_header_item_search_color_txt_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Icon Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33,1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_item_search_custom_sticky', '=', '1']
            ],
            [
                'id' => 'bottom_header_item_search_hover_color_txt_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Icon Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_item_search_custom_sticky', '=', '1']
            ],
            [
                'id' => 'bottom_header_cart_custom',
                'title' => esc_html__('Customize cart', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_cart_color_txt',
                'title' => esc_html__('Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33,1)'
                ],
            ],
            [
                'id' => 'bottom_header_cart_hover_color_txt',
                'title' => esc_html__('Hover Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_cart_custom_sticky',
                'title' => esc_html__('Customize Sticky cart', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_cart_color_txt_sticky',
                'title' => esc_html__('Sticky Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom_sticky', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33,1)'
                ],
            ],
            [
                'id' => 'bottom_header_cart_hover_color_txt_sticky',
                'title' => esc_html__('Sticky Hover Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom_sticky', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter1_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 50],
            ],
            [
                'id' => 'bottom_header_delimiter1_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter1_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#000000',
                    'alpha' => '0.1',
                    'rgba' => 'rgba(0, 0, 0, 0.1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter1_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '20',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter1_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter1_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter1_sticky_custom', '=', '1'],
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
                'mode' => 'background',
            ],
            [
                'id' => 'bottom_header_delimiter1_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter1_sticky_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter2_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter2_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter2_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter2_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter2_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter2_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter2_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter2_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter2_sticky_custom', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter3_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter3_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter3_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter3_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter3_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter3_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter3_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter3_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter3_sticky_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter4_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter4_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter4_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter4_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter4_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter4_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter4_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter4_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter4_sticky_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter5_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter5_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter5_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter5_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter5_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter5_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter5_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter5_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter5_sticky_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter6_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter6_width',
                'title' => esc_html__('Delimiter Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_type', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter6_bg',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter6_margin',
                'title' => esc_html__('Delimiter Spacing', 'atlets'),
                'type' => 'spacing',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter6_sticky_custom',
                'title' => esc_html__('Customize Sticky Delimiter', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_delimiter6_sticky_color',
                'title' => esc_html__('Delimiter Background', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_delimiter6_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter6_sticky_height',
                'title' => esc_html__('Delimiter Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['bottom_header_delimiter6_sticky_custom', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_button1_title',
                'title' => esc_html__('Button Text', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
                'default' => esc_html__('Get Ticket', 'atlets'),
            ],
            [
                'id' => 'bottom_header_button1_link',
                'title' => esc_html__('Link', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'bottom_header_button1_target',
                'title' => esc_html__('Open link in a new tab', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => true,
            ],
            [
                'id' => 'bottom_header_button1_size',
                'title' => esc_html__('Button Size', 'atlets'),
                'type' => 'select',
                'required' => ['header_type', '=', 'default'],
                'options' => [
                    's' => esc_html__('Small', 'atlets'),
                    'm' => esc_html__('Medium', 'atlets'),
                    'l' => esc_html__('Large', 'atlets'),
                    'xl' => esc_html__('Extra Large', 'atlets')
                ],
                'default' => 's',
            ],
            [
                'id' => 'bottom_header_button1_radius',
                'title' => esc_html__('Button Border Radius', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
                'desc' => esc_html__('Value in pixels.', 'atlets'),
                'default' => '0',
            ],
            [
                'id' => 'bottom_header_button1_custom',
                'title' => esc_html__('Customize Button', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_button1_color_txt',
                'title' => esc_html__('Text Color Idle', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_color_txt',
                'title' => esc_html__('Text Color Hover', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_bg',
                'title' => esc_html__('Background Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_bg',
                'title' => esc_html__('Hover Background Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_border',
                'title' => esc_html__('Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_border',
                'title' => esc_html__('Hover Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_custom_sticky',
                'title' => esc_html__('Customize Sticky Button', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_button1_color_txt_sticky',
                'title' => esc_html__('Sticky Text Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom_sticky', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_color_txt_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Text Color', 'atlets'),
                'required' => ['bottom_header_button1_custom_sticky', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_bg_sticky',
                'title' => esc_html__('Sticky Background Color', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'required' => ['bottom_header_button1_custom_sticky', '=', '1'],
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_bg_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Background Color', 'atlets'),
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button1_custom_sticky', '=', '1']
            ],
            [
                'id' => 'bottom_header_button1_border_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Border Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button1_custom_sticky', '=', '1']
            ],
            [
                'id' => 'bottom_header_button1_hover_border_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Border Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button1_custom_sticky', '=', '1']
            ],
            [
                'id' => 'bottom_header_button2_title',
                'title' => esc_html__('Button Text', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
                'default' => esc_html__('Get Ticket', 'atlets'),
            ],
            [
                'id' => 'bottom_header_button2_link',
                'title' => esc_html__('Link', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'bottom_header_button2_target',
                'title' => esc_html__('Open link in a new tab', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => true,
            ],
            [
                'id' => 'bottom_header_button2_size',
                'title' => esc_html__('Button Size', 'atlets'),
                'type' => 'select',
                'required' => ['header_type', '=', 'default'],
                'options' => [
                    's' => esc_html__('Small', 'atlets'),
                    'm' => esc_html__('Medium', 'atlets'),
                    'l' => esc_html__('Large', 'atlets'),
                    'xl' => esc_html__('Extra Large', 'atlets')
                ],
                'default' => 'm',
            ],
            [
                'id' => 'bottom_header_button2_radius',
                'title' => esc_html__('Button Border Radius', 'atlets'),
                'type' => 'text',
                'required' => ['header_type', '=', 'default'],
                'desc' => esc_html__('Value in pixels.', 'atlets'),
                'default' => '0',
            ],
            [
                'id' => 'bottom_header_button2_custom',
                'title' => esc_html__('Customize Button', 'atlets'),
                'type' => 'switch',
                'required' => ['header_type', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_button2_color_txt',
                'title' => esc_html__('Text Color Idle', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_color_txt',
                'title' => esc_html__('Text Color Hover', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_bg',
                'title' => esc_html__('Background Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_bg',
                'title' => esc_html__('Hover Background Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_border',
                'title' => esc_html__('Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_border',
                'title' => esc_html__('Hover Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_custom_sticky',
                'type' => 'switch',
                'title' => esc_html__('Customize Sticky Button', 'atlets'),
                'default' => false,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'bottom_header_button2_color_txt_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Text Color', 'atlets'),
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_button2_hover_color_txt_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Text Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_button2_bg_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Background Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_button2_hover_bg_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Background Color', 'atlets'),
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_button2_border_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Border Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_button2_hover_border_sticky',
                'type' => 'color_rgba',
                'title' => esc_html__('Sticky Hover Border Color', 'atlets'),
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
                'mode' => 'background',
                'required' => ['bottom_header_button2_custom_sticky', '=', '1'],
            ],
            [
                'id' => 'bottom_header_bar_html1_editor',
                'title' => esc_html__('HTML Element 1 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'bottom_header_bar_html2_editor',
                'title' => esc_html__('HTML Element 2 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html3_editor',
                'title' => esc_html__('HTML Element 3 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html4_editor',
                'title' => esc_html__('HTML Element 4 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html5_editor',
                'title' => esc_html__('HTML Element 5 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html6_editor',
                'title' => esc_html__('HTML Element 6 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html7_editor',
                'title' => esc_html__('HTML Element 7 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html8_editor',
                'title' => esc_html__('HTML Element 8 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_side_panel_color',
                'title' => esc_html__('Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'bottom_header_side_panel_background',
                'title' => esc_html__('Background Icon', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_type', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'bottom_header_side_panel_sticky_custom',
                'type' => 'switch',
                'title' => esc_html__('Customize Sticky Icon', 'atlets'),
                'default' => false,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'bottom_header_side_panel_sticky_color',
                'title' => esc_html__('Icon Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_side_panel_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_side_panel_sticky_background',
                'title' => esc_html__('Background Icon', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_side_panel_sticky_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#00182B',
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)'
                ],
            ],
            [
                'id' => 'header_top-start',
                'title' => esc_html__('Header Top Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_top_full_width',
                'title' => esc_html__('Full Width Header', 'atlets'),
                'type' => 'switch',
                'subtitle' => esc_html__('Set header content in full width', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'header_top_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_top_max_width',
                'title' => esc_html__('Max Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_top_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_top_height',
                'title' => esc_html__('Header Top Height', 'atlets'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 40],
            ],
            [
                'id' => 'header_top_background_image',
                'title' => esc_html__('Header Top Background Image', 'atlets'),
                'type' => 'media',
            ],
            [
                'id' => 'header_top_background',
                'title' => esc_html__('Header Top Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_top_color',
                'title' => esc_html__('Header Top Text Color', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '.5',
                    'rgba' => 'rgba(254,254,254,0.5)',
                    'color' => '#fefefe',
                ],
            ],
            [
                'id' => 'header_top_bottom_border',
                'type' => 'switch',
                'title' => esc_html__('Set Header Top Bottom Border', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'header_top_border_height',
                'title' => esc_html__('Header Top Border Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_top_bottom_border', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_top_bottom_border_color',
                'title' => esc_html__('Header Top Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_top_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,0.2)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_top-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_middle-start',
                'title' => esc_html__('Header Middle Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_middle_full_width',
                'type' => 'switch',
                'title' => esc_html__('Full Width Middle Header', 'atlets'),
                'subtitle' => esc_html__('Set header content in full width', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'header_middle_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_middle_max_width',
                'title' => esc_html__('Max Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_middle_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_middle_height',
                'title' => esc_html__('Header Middle Height', 'atlets'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 96],
            ],
            [
                'id' => 'header_middle_background_image',
                'title' => esc_html__('Header Middle Background Image', 'atlets'),
                'type' => 'media',
            ],
            [
                'id' => 'header_middle_background',
                'title' => esc_html__('Header Middle Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'header_middle_color',
                'title' => esc_html__('Header Middle Text Color', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'color' => '#212121',
                    'alpha' => '1',
                    'rgba' => 'rgba(33,33,33,1)'
                ],
            ],
            [
                'id' => 'header_middle_bottom_border',
                'title' => esc_html__('Set Header Middle Bottom Border', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_middle_border_height',
                'title' => esc_html__('Header Middle Border Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_middle_bottom_border', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_middle_bottom_border_color',
                'title' => esc_html__('Header Middle Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_middle_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#f5f5f5',
                    'alpha' => '1',
                    'rgba' => 'rgba(245,245,245,1)'
                ],
            ],
            [
                'id' => 'header_middle-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_bottom-start',
                'title' => esc_html__('Header Bottom Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_bottom_full_width',
                'title' => esc_html__('Full Width Bottom Header', 'atlets'),
                'type' => 'switch',
                'subtitle' => esc_html__('Set header content in full width', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'header_bottom_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_bottom_max_width',
                'title' => esc_html__('Max Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_bottom_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_bottom_height',
                'title' => esc_html__('Header Bottom Height', 'atlets'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'header_bottom_background_image',
                'title' => esc_html__('Header Bottom Background Image', 'atlets'),
                'type' => 'media',
            ],
            [
                'id' => 'header_bottom_background',
                'title' => esc_html__('Header Bottom Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'header_bottom_color',
                'title' => esc_html__('Header Bottom Text Color', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '.5',
                    'rgba' => 'rgba(254,254,254,0.5)',
                    'color' => '#fefefe',
                ],
            ],
            [
                'id' => 'header_bottom_bottom_border',
                'title' => esc_html__('Set Header Bottom Border', 'atlets'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'header_bottom_border_height',
                'title' => esc_html__('Header Bottom Border Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_bottom_bottom_border', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_bottom_bottom_border_color',
                'title' => esc_html__('Header Bottom Border Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['header_bottom_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,0.2)'
                ],
            ],
            [
                'id' => 'header_bottom-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-left-start',
                'title' => esc_html__('Top Left Column Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_left_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_left_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_left_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-center-start',
                'type' => 'section',
                'title' => esc_html__('Top Center Column Options', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_top_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_center_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-center-start',
                'type' => 'section',
                'title' => esc_html__('Top Center Column Options', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_top_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_center_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-right-start',
                'title' => esc_html__('Top Right Column Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_right_horz',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'header_column_top_right_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_right_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-left-start',
                'title' => esc_html__('Middle Left Column Options', 'atlets'),
                'type' => 'section',
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_middle_left_horz',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_middle_left_vert',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_middle_left_display',
                'title' => esc_html__('Display', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-middle-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-center-start',
                'title' => esc_html__('Middle Center Column Options', 'atlets'),
                'type' => 'section',
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_middle_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left',
            ],
            [
                'id' => 'header_column_middle_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_middle_center_display',
                'title' => esc_html__('Display', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-middle-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-center-start',
                'type' => 'section',
                'title' => esc_html__('Middle Center Column Options', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_middle_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets')
                ],
                'default' => 'left',
            ],
            [
                'id' => 'header_column_middle_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets')
                ],
                'default' => 'middle',
            ],
            [
                'id' => 'header_column_middle_center_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets')
                ],
                'default' => 'normal',
            ],
            [
                'id' => 'header_column-middle-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-right-start',
                'title' => esc_html__('Middle Right Column Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_middle_right_horz',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'right',
            ],
            [
                'id' => 'header_column_middle_right_vert',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle',
            ],
            [
                'id' => 'header_column_middle_right_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal',
            ],
            [
                'id' => 'header_column-middle-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-left-start',
                'title' => esc_html__('Bottom Left Column Options', 'atlets'),
                'type' => 'section',
                'required' => ['header_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_bottom_left_horz',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_bottom_left_vert',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_left_display',
                'title' => esc_html__('Display', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-center-start',
                'type' => 'section',
                'title' => esc_html__('Bottom Center Column Options', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_bottom_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_bottom_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_center_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-right-start',
                'type' => 'section',
                'title' => esc_html__('Bottom Right Column Options', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_column_bottom_right_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'atlets'),
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'header_column_bottom_right_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'atlets'),
                'options' => [
                    'top' => esc_html__('Top', 'atlets'),
                    'middle' => esc_html__('Middle', 'atlets'),
                    'bottom' => esc_html__('Bottom', 'atlets'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_right_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'atlets'),
                'options' => [
                    'normal' => esc_html__('Normal', 'atlets'),
                    'grow' => esc_html__('Grow', 'atlets'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_row_settings-start',
                'type' => 'section',
                'title' => esc_html__('Header Settings', 'atlets'),
                'indent' => true,
                'required' => ['header_type', '=', 'default'],
            ],
            [
                'id' => 'header_shadow',
                'type' => 'switch',
                'title' => esc_html__('Header Bottom Shadow', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'header_on_bg',
                'title' => esc_html__('Over content', 'atlets'),
                'type' => 'switch',
                'subtitle' => esc_html__('Display header template over the content.', 'atlets'),
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'lavalamp_active',
                'type' => 'switch',
                'title' => esc_html__('Lavalamp Marker', 'atlets'),
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'sub_menu_background',
                'type' => 'color_rgba',
                'title' => esc_html__('Sub Menu Background', 'atlets'),
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'sub_menu_color',
                'title' => esc_html__('Sub Menu Text Color', 'atlets'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#00182B',
            ],
            [
                'id' => 'header_sub_menu_bottom_border',
                'type' => 'switch',
                'title' => esc_html__('Sub Menu Bottom Border', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'header_sub_menu_border_height',
                'title' => esc_html__('Sub Menu Border Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['header_sub_menu_bottom_border', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_sub_menu_bottom_border_color',
                'type' => 'color_rgba',
                'title' => esc_html__('Sub Menu Border Color', 'atlets'),
                'required' => ['header_sub_menu_bottom_border', '=', '1'],
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(0, 0, 0, 0.08)'
                ],
                'mode' => 'background',
            ],
            [
                'id' => 'header_mobile_queris',
                'title' => esc_html__('Mobile Header Switch Breakpoint', 'atlets'),
                'type' => 'slider',
                'display_value' => 'text',
                'min' => 400,
                'max' => 1920,
                'default' => 1200,
            ],
            [
                'id' => 'header_row_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Header Sticky', 'atlets'),
        'id' => 'header_builder_sticky',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'header_sticky',
                'title' => esc_html__('Header Sticky', 'atlets'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'header_sticky-start',
                'title' => esc_html__('Sticky Settings', 'atlets'),
                'type' => 'section',
                'required' => ['header_sticky', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'header_sticky_page_select',
                'title' => esc_html__('Header Sticky Template', 'atlets'),
                'type' => 'select',
                'required' => ['header_sticky', '=', '1'],
                'desc' => sprintf(
                    '%s <a href="%s" target="_blank">%s</a> %s',
                    esc_html__('Selected Template will be used for all pages by default. You can edit/create Header Template in the', 'atlets'),
                    admin_url('edit.php?post_type=header'),
                    esc_html__('Header Templates', 'atlets'),
                    esc_html__('dashboard tab.', 'atlets')
                ),
                'data' => 'posts',
                'args' => [
                    'post_type' => 'header',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'header_sticky_style',
                'type' => 'select',
                'title' => esc_html__('Appearance', 'atlets'),
                'options' => [
                    'standard' => esc_html__('Always Visible', 'atlets'),
                    'scroll_up' => esc_html__('Visible while scrolling upwards', 'atlets'),
                ],
                'default' => 'standard'
            ],
            [
                'id' => 'header_sticky-end',
                'type' => 'section',
                'required' => ['header_sticky', '=', '1'],
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Header Mobile', 'atlets'),
        'id' => 'header_builder_mobile',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'mobile_header',
                'title' => esc_html__('Mobile Header', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Custom', 'atlets'),
                'off' => esc_html__('Default', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'header_mobile_appearance-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'required' => ['mobile_header', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'header_mobile_height',
                'title' => esc_html__('Header Height', 'atlets'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => '100'],
            ],
            [
                'id' => 'mobile_sticky',
                'title' => esc_html__('Mobile Sticky Header', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'mobile_over_content',
                'title' => esc_html__('Header Over Content', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'custom_mobile_menu',
                'title' => esc_html__('Custom Mobile Menu', 'atlets'),
                'type' => 'switch',
                'default' => false
            ],
            [
                'id' => 'mobile_menu',
                'title' => esc_html__('Mobile Menu', 'atlets'),
                'type' => 'select',
                'required' => ['custom_mobile_menu', '=', '1'],
                'select2' => ['allowClear' => false],
                'options' => atlets_redux_get_custom_menu(),
            ],
            [
                'id' => 'header_mobile_appearance-end',
                'type' => 'section',
                'indent' => false
            ],
            [
                'id' => 'header_mobile_general-start',
                'title' => esc_html__('General', 'atlets'),
                'type' => 'section',
                'required' => ['mobile_header', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'mobile_background',
                'title' => esc_html__('Header Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43, 1)',
                    'color' => '#00182B',
                ],
            ],
            [
                'id' => 'mobile_color',
                'title' => esc_html__('Header Text Color', 'atlets'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'header_mobile_general-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_mobile_menu-start',
                'title' => esc_html__('Menu', 'atlets'),
                'type' => 'section',
                'required' => ['mobile_header', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'mobile_position',
                'title' => esc_html__('Menu Occurrence', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left',
            ],
            [
                'id' => 'mobile_sub_menu_color',
                'title' => esc_html__('Menu Text Color', 'atlets'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'mobile_sub_menu_background',
                'title' => esc_html__('Menu Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43,1)',
                    'color' => '#00182B',
                ],
            ],
            [
                'id' => 'mobile_sub_menu_overlay',
                'title' => esc_html__('Menu Overlay', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(0,24,43,0.3)',
                    'color' => '#00182b4d',
                ],
            ],
            [
                'id' => 'header_mobile_menu-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'mobile_header_layout',
                'title' => esc_html__('Mobile Header Order', 'atlets'),
                'type' => 'sorter',
                'required' => ['mobile_header', '=', '1'],
                'desc' => esc_html__('Organize the layout of the mobile header', 'atlets'),
                'compiler' => 'true',
                'full_width' => true,
                'options' => [
                    'items' => $header_builder_items['mobile'],
                    'Left align side' => [
                        'menu' => esc_html__('Hamburger Menu', 'atlets'),
                    ],
                    'Center align side' => [
                        'logo' => esc_html__('Logo', 'atlets'),
                    ],
                    'Right align side' => [
                        'item_search' => esc_html__('Search', 'atlets'),
                    ],
                ],
            ],
            [
                'id' => 'mobile_content_header_layout',
                'title' => esc_html__('Mobile Drawer Content', 'atlets'),
                'type' => 'sorter',
                'required' => ['mobile_header', '=', '1'],
                'desc' => esc_html__('Organize the layout of the mobile header', 'atlets'),
                'compiler' => 'true',
                'full_width' => true,
                'options' => [
                    'items' => $header_builder_items['mobile_drawer'],
                    'Left align side' => [
                        'logo' => esc_html__('Logo', 'atlets'),
                        'menu' => esc_html__('Menu', 'atlets'),
                        'item_search' => esc_html__('Search', 'atlets'),
                    ],
                ],
                'default' => [
                    'items' => $header_builder_items['mobile_drawer'],
                    'Left align side' => [
                        'logo' => esc_html__('Logo', 'atlets'),
                        'menu' => esc_html__('Menu', 'atlets'),
                        'item_search' => esc_html__('Search', 'atlets'),
                    ],
                ],
            ],
            [
                'id' => 'mobile_header_bar_html1_editor',
                'title' => esc_html__('HTML Element 1 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html2_editor',
                'title' => esc_html__('HTML Element 2 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html3_editor',
                'title' => esc_html__('HTML Element 3 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html4_editor',
                'title' => esc_html__('HTML Element 4 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html5_editor',
                'title' => esc_html__('HTML Element 5 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html6_editor',
                'title' => esc_html__('HTML Element 6 Editor', 'atlets'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_spacer1',
                'title' => esc_html__('Spacer 1 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer2',
                'title' => esc_html__('Spacer 2 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer3',
                'title' => esc_html__('Spacer 3 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer4',
                'title' => esc_html__('Spacer 4 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer5',
                'title' => esc_html__('Spacer 5 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer6',
                'title' => esc_html__('Spacer 6 Width', 'atlets'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Page Title', 'atlets'),
        'id' => 'page_title',
        'icon' => 'el el-home-alt'
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'page_title_settings',
        'title' => esc_html__('General', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_switch',
                'title' => esc_html__('Use Page Titles?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'page_title-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'atlets'),
                'type' => 'background',
                'required' => ['page_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-image' => '',
                    'background-repeat' => 'no-repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center bottom',
                    'background-color' => '#00182c',
                ],
            ],
            [
                'id' => 'page_title_height',
                'title' => esc_html__('Height', 'atlets'),
                'type' => 'dimensions',
                'required' => ['page_title_bg_switch', '=', true],
                'height' => true,
                'width' => false,
                'default' => ['height' => 400],
            ],
            [
                'id' => 'page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'atlets'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
                'default' => [
                    'padding-top' => '76',
                    'padding-bottom' => '80',
                ],
            ],
            [
                'id' => 'page_title_margin',
                'title' => esc_html__('Margin Bottom', 'atlets'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'bottom' => true,
                'top' => false,
                'left' => false,
                'right' => false,
                'default' => ['margin-bottom' => '50'],
            ],
            [
                'id' => 'page_title_align',
                'title' => esc_html__('Title Alignment', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => 'Left',
                    'center' => 'Center',
                    'right' => 'Right'
                ],
                'default' => 'center',
            ],
            [
                'id' => 'page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'page_title_breadcrumbs_block_switch',
                'title' => esc_html__('Breadcrumbs Full Width', 'atlets'),
                'type' => 'switch',
                'required' => ['page_title_breadcrumbs_switch', '=', true],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'page_title_breadcrumbs_align',
                'title' => esc_html__('Breadcrumbs Alignment', 'atlets'),
                'type' => 'button_set',
                'required' => ['page_title_breadcrumbs_block_switch', '=', true],
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'page_title_parallax',
                'title' => esc_html__('Parallax Effect', 'atlets'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'page_title_parallax_speed',
                'title' => esc_html__('Parallax Speed', 'atlets'),
                'type' => 'spinner',
                'required' => ['page_title_parallax', '=', '1'],
                'min' => '-5',
                'max' => '5',
                'step' => '0.1',
                'default' => '0.3',
            ],
            [
                'id' => 'page_title-end',
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'page_title_typography',
        'title' => esc_html__('Typography', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_font',
                'title' => esc_html__('Page Title Font', 'atlets'),
                'type' => 'custom_typography',
                'font-size' => true,
                'google' => false,
                'font-weight' => false,
                'font-family' => false,
                'font-style' => false,
                'color' => true,
                'line-height' => true,
                'font-backup' => false,
                'text-align' => false,
                'all_styles' => false,
                'default' => [
                    'font-size' => '48px',
                    'line-height' => '62px',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'page_title_breadcrumbs_font',
                'title' => esc_html__('Page Title Breadcrumbs Font', 'atlets'),
                'type' => 'custom_typography',
                'font-size' => true,
                'google' => false,
                'font-weight' => false,
                'font-family' => false,
                'font-style' => false,
                'color' => true,
                'line-height' => true,
                'font-backup' => false,
                'text-align' => false,
                'all_styles' => false,
                'default' => [
                    'font-size' => '14px',
                    'color' => '#ffffff',
                    'line-height' => '24px',
                ],
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Responsive', 'atlets'),
        'id' => 'page_title_responsive',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_resp_switch',
                'title' => esc_html__('Responsive Settings', 'atlets'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'page_title_resp_resolution',
                'title' => esc_html__('Screen breakpoint', 'atlets'),
                'type' => 'slider',
                'required' => ['page_title_resp_switch', '=', '1'],
                'desc' => esc_html__('Use responsive settings on screens smaller then choosed breakpoint.', 'atlets'),
                'display_value' => 'text',
                'min' => 1,
                'max' => 1700,
                'step' => 1,
                'default' => 768,
            ],
            [
                'id' => 'page_title_resp_padding',
                'title' => esc_html__('Page Title Paddings', 'atlets'),
                'type' => 'spacing',
                'required' => ['page_title_resp_switch', '=', '1'],
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
                'default' => [
                    'padding-top' => '60',
                    'padding-bottom' => '60',
                ],
            ],
	        [
		        'id' => 'page_title_resp_margin',
		        'title' => esc_html__('Margin Bottom', 'atlets'),
		        'type' => 'spacing',
		        'required' => ['page_title_resp_switch', '=', '1'],
		        'mode' => 'margin',
		        'all' => false,
		        'bottom' => true,
		        'top' => false,
		        'left' => false,
		        'right' => false,
		        'default' => ['margin-bottom' => '10'],
	        ],
            [
                'id' => 'page_title_resp_font',
                'title' => esc_html__('Page Title Font', 'atlets'),
                'type' => 'custom_typography',
                'required' => ['page_title_resp_switch', '=', '1'],
                'google' => false,
                'all_styles' => false,
                'font-family' => false,
                'font-style' => false,
                'font-size' => true,
                'font-weight' => false,
                'font-backup' => false,
                'line-height' => true,
                'text-align' => false,
                'color' => true,
                'default' => [
                    'font-size' => '38px',
                    'line-height' => '48px',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'page_title_resp_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'atlets'),
                'type' => 'switch',
                'required' => ['page_title_resp_switch', '=', '1'],
                'default' => true,
            ],
            [
                'id' => 'page_title_resp_breadcrumbs_font',
                'title' => esc_html__('Breadcrumbs Font', 'atlets'),
                'type' => 'custom_typography',
                'required' => ['page_title_resp_breadcrumbs_switch', '=', '1'],
                'google' => false,
                'all_styles' => false,
                'font-family' => false,
                'font-style' => false,
                'font-size' => true,
                'font-weight' => false,
                'font-backup' => false,
                'line-height' => true,
                'text-align' => false,
                'color' => true,
                'default' => [
                    'font-size' => '14px',
                    'color' => '#ffffff',
                    'line-height' => '24px',
                ],
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'footer',
        'title' => esc_html__('Footer', 'atlets'),
        'icon' => 'fas fa-window-maximize rotate-180',
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'footer_settings',
        'title' => esc_html__('General', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'footer_switch',
                'title' => esc_html__('Footer', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Disable', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'footer-start',
                'title' => esc_html__('Footer Settings', 'atlets'),
                'type' => 'section',
                'required' => ['footer_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'footer_content_type',
                'title' => esc_html__('Content Type', 'atlets'),
                'type' => 'select',
                'options' => [
                    'widgets' => esc_html__('Get Widgets', 'atlets'),
                    'pages' => esc_html__('Get Pages', 'atlets'),
                ],
                'default' => 'pages',
            ],
            [
                'id' => 'footer_page_select',
                'title' => esc_html__('Page Select', 'atlets'),
                'type' => 'select',
                'required' => ['footer_content_type', '=', 'pages'],
                'data' => 'posts',
                'args' => [
                    'post_type' => 'footer',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'widget_columns',
                'title' => esc_html__('Columns', 'atlets'),
                'type' => 'button_set',
                'required' => ['footer_content_type', '=', 'widgets'],
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ],
                'default' => '4',
            ],
            [
                'id' => 'widget_columns_2',
                'title' => esc_html__('Columns Layout', 'atlets'),
                'type' => 'image_select',
                'required' => ['widget_columns', '=', '2'],
                'options' => [
                    '6-6' => [
                        'alt' => '50-50',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/50-50.png'
                    ],
                    '3-9' => [
                        'alt' => '25-75',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-75.png'
                    ],
                    '9-3' => [
                        'alt' => '75-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/75-25.png'
                    ],
                    '4-8' => [
                        'alt' => '33-66',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/33-66.png'
                    ],
                    '8-4' => [
                        'alt' => '66-33',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/66-33.png'
                    ]
                ],
                'default' => '6-6',
            ],
            [
                'id' => 'widget_columns_3',
                'title' => esc_html__('Columns Layout', 'atlets'),
                'type' => 'image_select',
                'required' => ['widget_columns', '=', '3'],
                'options' => [
                    '4-4-4' => [
                        'alt' => '33-33-33',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/33-33-33.png'
                    ],
                    '3-3-6' => [
                        'alt' => '25-25-50',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-25-50.png'
                    ],
                    '3-6-3' => [
                        'alt' => '25-50-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-50-25.png'
                    ],
                    '6-3-3' => [
                        'alt' => '50-25-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/50-25-25.png'
                    ],
                ],
                'default' => '4-4-4',
            ],
            [
                'id' => 'footer_spacing',
                'title' => esc_html__('Paddings', 'atlets'),
                'type' => 'spacing',
                'required' => ['footer_content_type', '=', 'widgets'],
                'output' => ['.wgl-footer'],
                'all' => false,
                'mode' => 'padding',
                'units' => 'px',
                'default' => [
                    'padding-top' => '50px',
                    'padding-right' => '0px',
                    'padding-bottom' => '0px',
                    'padding-left' => '0px'
                ],
            ],
            [
                'id' => 'footer_full_width',
                'title' => esc_html__('Full Width On/Off', 'atlets'),
                'type' => 'switch',
                'required' => ['footer_content_type', '=', 'widgets'],
                'default' => false,
            ],
            [
                'id' => 'footer-end',
                'type' => 'section',
                'required' => ['footer_switch', '=', '1'],
                'indent' => false,
            ],
            [
                'id' => 'footer-start-styles',
                'title' => esc_html__('Footer Styling', 'atlets'),
                'type' => 'section',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'indent' => true,
            ],
            [
                'id' => 'footer_bg_image',
                'title' => esc_html__('Background Image', 'atlets'),
                'type' => 'background',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'footer_align',
                'title' => esc_html__('Content Align', 'atlets'),
                'type' => 'button_set',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'footer_bg_color',
                'title' => esc_html__('Background Color', 'atlets'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#1f242c',
            ],
            [
                'id' => 'footer_heading_color',
                'title' => esc_html__('Headings color', 'atlets'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'footer_text_color',
                'title' => esc_html__('Content color', 'atlets'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'footer_add_border',
                'title' => esc_html__('Add Border Top', 'atlets'),
                'type' => 'switch',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_content_type', '=', 'widgets'],
                ],
                'default' => false,
            ],
            [
                'id' => 'footer_border_color',
                'title' => esc_html__('Border color', 'atlets'),
                'type' => 'color',
                'required' => ['footer_add_border', '=', '1'],
                'transparent' => false,
                'default' => '#e5e5e5',
            ],
            [
                'id' => 'footer-end-styles',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'copyright',
        'title' => esc_html__('Copyright', 'atlets'),
        'icon' => 'el el-brush'
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Settings', 'atlets'),
        'id' => 'copyright-settings',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'copyright_switch',
                'type' => 'switch',
                'title' => esc_html__('Copyright', 'atlets'),
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Disable', 'atlets'),
                'default' => true
            ],
            [
                'id' => 'copyright-start',
                'type' => 'section',
                'title' => esc_html__('Copyright Settings', 'atlets'),
                'indent' => true,
                'required' => ['copyright_switch', '=', '1'],
            ],
            [
                'id' => 'copyright_editor',
                'title' => esc_html__('Editor', 'atlets'),
                'type' => 'editor',
                'required' => ['copyright_switch', '=', '1'],
                'args' => [
                    'wpautop' => false,
                    'media_buttons' => false,
                    'textarea_rows' => 2,
                    'teeny' => false,
                    'quicktags' => true,
                ],
                'default' => '<p>Copyright © 2021 Atlets by <a href="https://themeforest.net/user/webgeniuslab" rel="noopener noreferrer" target="_blank">WebGeniusLab</a>. All Rights Reserved</p>',
            ],
            [
                'id' => 'copyright_text_color',
                'title' => esc_html__('Text Color', 'atlets'),
                'type' => 'color',
                'required' => ['copyright_switch', '=', '1'],
                'transparent' => false,
                'default' => '#9f9f9f',
            ],
            [
                'id' => 'copyright_bg_color',
                'title' => esc_html__('Background Color', 'atlets'),
                'type' => 'color',
                'required' => ['copyright_switch', '=', '1'],
                'transparent' => false,
                'default' => '#1f242c',
            ],
            [
                'id' => 'copyright_spacing',
                'type' => 'spacing',
                'title' => esc_html__('Paddings', 'atlets'),
                'required' => ['copyright_switch', '=', '1'],
                'mode' => 'padding',
                'left' => false,
                'right' => false,
                'all' => false,
                'default' => [
                    'padding-top' => '20',
                    'padding-bottom' => '20',
                ],
            ],
            [
                'id' => 'copyright-end',
                'type' => 'section',
                'required' => ['footer_switch', '=', '1'],
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'blog-option',
        'title' => esc_html__('Blog', 'atlets'),
        'icon' => 'el el-bullhorn',
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'blog-list-option',
        'title' => esc_html__('Archive', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'blog_list_page_title-start',
                'title' => esc_html__('Page Title', 'atlets'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'post_archive_page_title_bg_image',
                'title' => esc_html__('Background Image', 'atlets'),
                'type' => 'background',
                'background-color' => false,
                'preview_media' => true,
                'preview' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'blog_list_page_title-end',
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => false,
            ],
            [
                'id' => 'blog_list_sidebar-start',
                'title' => esc_html__('Sidebar', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'blog_list_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'atlets'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'blog_list_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'atlets'),
                'type' => 'select',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'blog_list_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'atlets'),
                'type' => 'button_set',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => '25%',
                    '8' => '33%',
                ],
                'default' => '9',
            ],
            [
                'id' => 'blog_list_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'blog_list_sidebar_gap',
                'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                'type' => 'select',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'options' => [
                    'def' => esc_html__('Default', 'atlets'),
                    '0' => '0',
                    '15' => '15',
                    '20' => '20',
                    '25' => '25',
                    '30' => '30',
                    '35' => '35',
                    '40' => '40',
                    '45' => '45',
                    '50' => '50',
                ],
                'default' => 'def',
            ],
            [
                'id' => 'blog_list_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_list_appearance-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'blog_list_columns',
                'title' => esc_html__('Columns in Archive', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    '12' => esc_html__('One', 'atlets'),
                    '6' => esc_html__('Two', 'atlets'),
                    '4' => esc_html__('Three', 'atlets'),
                    '3' => esc_html__('Four', 'atlets'),
                ],
                'default' => '12',
            ],
            [
                'id' => 'blog_list_likes',
                'title' => esc_html__('Likes', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_share',
                'title' => esc_html__('Shares', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_media',
                'title' => esc_html__('Hide Media?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_title',
                'title' => esc_html__('Hide Title?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_content',
                'title' => esc_html__('Hide Content?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_post_listing_content',
                'title' => esc_html__('Limit the characters amount in Content?', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_hide_content', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_letter_count',
                'title' => esc_html__('Limit amount of characters to be displayed.', 'atlets'),
                'type' => 'text',
                'required' => ['blog_post_listing_content', '=', true],
                'default' => '85',
            ],
            [
                'id' => 'blog_list_read_more',
                'title' => esc_html__('Hide Read More Button?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta',
                'title' => esc_html__('Hide all post-meta?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta_author',
                'title' => esc_html__('Hide post-meta author?', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'blog_list_meta_comments',
                'title' => esc_html__('Hide post-meta comments?', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'blog_list_meta_categories',
                'title' => esc_html__('Hide post-meta categories?', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta_date',
                'title' => esc_html__('Hide post-meta date?', 'atlets'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'blog-single-option',
        'title' => esc_html__('Single', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'single_type_layout',
                'title' => esc_html__('Default Post Layout', 'atlets'),
                'type' => 'button_set',
                'desc' => esc_html__('Note: each Post can be separately customized within its Metaboxes section.', 'atlets'),
                'options' => [
                    '1' => esc_html__('Title First', 'atlets'),
                    '2' => esc_html__('Image First', 'atlets'),
                    '3' => esc_html__('Overlay Image', 'atlets')
                ],
                'default' => '3'
            ],
            [
                'id' => 'blog_single_page_title-start',
                'title' => esc_html__('Page Title', 'atlets'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'blog_title_conditional',
                'title' => esc_html__('Page Title Text', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'atlets'),
                'off' => esc_html__('Post Title', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_single_page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'post_single_page_title_bg_image',
                'title' => esc_html__('Background Image', 'atlets'),
                'type' => 'background',
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '#00182c',
                ],
            ],
            [
                'id' => 'single_padding_layout_3',
                'type' => 'spacing',
                'title' => esc_html__('Padding Top/Bottom', 'atlets'),
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'right' => false,
                'bottom' => true,
                'left' => false,
                'desc' => esc_html__('Note: this setting affects only the "Overlay Image" post layout.', 'atlets'),
                'default' => [
                    'padding-top' => '350',
                    'padding-bottom' => '0',
                ],
            ],
            [
                'id' => 'blog_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_sidebar-start',
                'type' => 'section',
                'title' => esc_html__('Sidebar', 'atlets'),
                'indent' => true,
            ],
            [
                'id' => 'single_sidebar_layout',
                'type' => 'image_select',
                'title' => esc_html__('Sidebar Layout', 'atlets'),
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'right'
            ],
            [
                'id' => 'single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'atlets'),
                'type' => 'select',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
                'default' => 'sidebar_main-sidebar',
            ],
            [
                'id' => 'single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'atlets'),
                'type' => 'button_set',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => '25%',
                    '8' => '33%',
                ],
                'default' => '9',
            ],
            [
                'id' => 'single_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'atlets'),
                'type' => 'switch',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'default' => true,
            ],
            [
                'id' => 'single_sidebar_gap',
                'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                'type' => 'select',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'options' => [
                    'def' => esc_html__('Default', 'atlets'),
                    '0' => '0',
                    '15' => '15',
                    '20' => '20',
                    '25' => '25',
                    '30' => '30',
                    '35' => '35',
                    '40' => '40',
                    '45' => '45',
                    '50' => '50',
                ],
                'default' => 'def',
            ],
            [
                'id' => 'blog_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_appearance-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'featured_image_type',
                'title' => esc_html__('Featured Image', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'default' => esc_html__('Default', 'atlets'),
                    'off' => esc_html__('Off', 'atlets'),
                    'replace' => esc_html__('Replace', 'atlets')
                ],
                'default' => 'default'
            ],
            [
                'id' => 'featured_image_replace',
                'title' => esc_html__('Image To Replace On', 'atlets'),
                'type' => 'media',
                'required' => ['featured_image_type', '=', 'replace'],
            ],
            [
                'id' => 'single_apply_animation',
                'title' => esc_html__('Apply Animation?', 'atlets'),
                'type' => 'switch',
                'required' => ['single_type_layout', '=', '3'],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'single_likes',
                'type' => 'switch',
                'title' => esc_html__('Likes', 'atlets'),
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_views',
                'title' => esc_html__('Views', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_share',
                'title' => esc_html__('Shares', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_author_info',
                'title' => esc_html__('Author Info', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_meta',
                'title' => esc_html__('Hide all post-meta?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_author',
                'title' => esc_html__('Hide post-meta author?', 'atlets'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'single_meta_comments',
                'title' => esc_html__('Hide post-meta comments?', 'atlets'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'single_meta_categories',
                'title' => esc_html__('Hide post-meta categories?', 'atlets'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_date',
                'title' => esc_html__('Hide post-meta date?', 'atlets'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_tags',
                'title' => esc_html__('Hide tags?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'blog_single_appearance-end',
                'type' => 'section',
                'indent' => false
            ]
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'blog-single-related-option',
        'title' => esc_html__('Related', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'single_related_posts',
                'title' => esc_html__('Related Posts', 'atlets'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'blog_title_r',
                'title' => esc_html__('Related Section Title', 'atlets'),
                'type' => 'text',
                'required' => ['single_related_posts', '=', '1'],
                'default' => esc_html__('Related Posts', 'atlets'),
            ],
            [
                'id' => 'blog_cat_r',
                'title' => esc_html__('Select Categories', 'atlets'),
                'type' => 'select',
                'required' => ['single_related_posts', '=', '1'],
                'multi' => true,
                'data' => 'categories',
                'width' => '20%',
            ],
            [
                'id' => 'blog_column_r',
                'title' => esc_html__('Columns', 'atlets'),
                'type' => 'button_set',
                'required' => ['single_related_posts', '=', '1'],
                'options' => [
                    '12' => '1',
                    '6' => '2',
                    '4' => '3',
                    '3' => '4'
                ],
                'default' => '6',
            ],
            [
                'id' => 'blog_number_r',
                'title' => esc_html__('Number of Related Items', 'atlets'),
                'type' => 'text',
                'required' => ['single_related_posts', '=', '1'],
                'default' => '2',
            ],
            [
                'id' => 'blog_carousel_r',
                'title' => esc_html__('Display items in the carousel', 'atlets'),
                'type' => 'switch',
                'required' => ['single_related_posts', '=', '1'],
                'default' => true,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'portfolio-option',
        'title' => esc_html__('Portfolio', 'atlets'),
        'icon' => 'el el-picture',
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'portfolio-list-option',
        'title' => esc_html__('Archive', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_slug',
                'title' => esc_html__('Portfolio Slug', 'atlets'),
                'type' => 'text',
                'default' => 'portfolio',
            ],
            [
                'id' => 'portfolio_archive_page_title_bg_image',
                'title' => esc_html__('Archive Page Title Background Image', 'atlets'),
                'type' => 'background',
                'background-color' => false,
                'preview_media' => true,
                'preview' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ]
            ],
            [
                'id' => 'portfolio_list_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'atlets'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'portfolio_list_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'atlets'),
                'type' => 'select',
                'required' => ['portfolio_list_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'portfolio_list_appearance-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_list_columns',
                'title' => esc_html__('Columns in Archive', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    '1' => esc_html__('One', 'atlets'),
                    '2' => esc_html__('Two', 'atlets'),
                    '3' => esc_html__('Three', 'atlets'),
                    '4' => esc_html__('Four', 'atlets'),
                ],
                'default' => '3',
            ],
            [
                'id' => 'portfolio_list_show_filter',
                'title' => esc_html__('Filter', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_list_filter_cats',
                'title' => esc_html__('Select Categories', 'atlets'),
                'type' => 'select',
                'required' => ['portfolio_list_show_filter', '=', '1'],
                'multi' => true,
                'data' => 'terms',
                'args' => ['taxonomies' => 'portfolio-category'],
            ],
            [
                'id' => 'portfolio_list_show_title',
                'title' => esc_html__('Title', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_list_show_content',
                'title' => esc_html__('Content', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_list_show_cat',
                'title' => esc_html__('Categories', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_list_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'portfolio-single-option',
        'title' => esc_html__('Single', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_single_layout-start',
                'title' => esc_html__('Layout', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_single_type_layout',
                'title' => esc_html__('Portfolio Single Layout', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    '1' => esc_html__('Title First', 'atlets'),
                    '2' => esc_html__('Image First', 'atlets'),
                ],
                'default' => '2',
            ],
            [
                'id' => 'portfolio_single_layout-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_post_title-start',
                'title' => esc_html__('Page Title', 'atlets'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', true],
                'indent' => true,
            ],
            [
                'id' => 'portfolio_title_conditional',
                'title' => esc_html__('Post Title Text', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'atlets'),
                'off' => esc_html__('Post Title', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_title_align',
                'title' => esc_html__('Title Alignment', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'portfolio_single_breadcrumbs_align',
                'title' => esc_html__('Breadcrumbs Alignment', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'portfolio_single_breadcrumbs_block_switch',
                'title' => esc_html__('Breadcrumbs Full Width', 'atlets'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'atlets'),
                'type' => 'background',
                'required' => ['portfolio_single_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
            [
                'id' => 'portfolio_single_page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'atlets'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => 'portfolio_single_page_title_margin',
                'title' => esc_html__('Margin Bottom', 'atlets'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'bottom' => true,
                'top' => false,
                'left' => false,
                'right' => false,
                'default' => ['margin-bottom' => '32'],
            ],
            [
                'id' => 'portfolio_single_post_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_sidebar-start',
                'title' => esc_html__('Sidebar', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_single_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'atlets'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'portfolio_single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'atlets'),
                'type' => 'select',
                'data' => 'sidebars',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'portfolio_single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'atlets'),
                'type' => 'button_set',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => '25%',
                    '8' => '33%',
                ],
                'default' => '8',
            ],
            [
                'id' => 'portfolio_single_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_sidebar_gap',
                'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                'type' => 'select',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'options' => [
                    'def' => esc_html__('Default', 'atlets'),
                    '0' => '0',
                    '15' => '15',
                    '20' => '20',
                    '25' => '25',
                    '30' => '30',
                    '35' => '35',
                    '40' => '40',
                    '45' => '45',
                    '50' => '50',
                ],
                'default' => 'def',
            ],
            [
                'id' => 'portfolio_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_appearance-start',
                'title' => esc_html__('Appearance', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_single_align',
                'title' => esc_html__('Content Alignment', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets')
                ],
                'default' => 'left'
            ],
            [
                'id' => 'portfolio_above_content_cats',
                'title' => esc_html__('Tags', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_above_content_share',
                'title' => esc_html__('Shares', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_meta_likes',
                'title' => esc_html__('Likes', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_meta',
                'title' => esc_html__('Hide all post-meta?', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'atlets'),
                'off' => esc_html__('No', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_author',
                'title' => esc_html__('Post-meta author', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_comments',
                'title' => esc_html__('Post-meta comments', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_categories',
                'title' => esc_html__('Post-meta categories', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_date',
                'title' => esc_html__('Post-meta date', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'portfolio-related-option',
        'title' => esc_html__('Related Posts', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_related_switch',
                'type' => 'switch',
                'title' => esc_html__('Related Posts', 'atlets'),
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'pf_title_r',
                'title' => esc_html__('Title', 'atlets'),
                'type' => 'text',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => esc_html__('Related Projects', 'atlets'),
            ],
            [
                'id' => 'pf_carousel_r',
                'title' => esc_html__('Display items carousel for this portfolio post', 'atlets'),
                'type' => 'switch',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => true,
            ],
            [
                'id' => 'pf_column_r',
                'title' => esc_html__('Related Columns', 'atlets'),
                'type' => 'button_set',
                'required' => ['portfolio_related_switch', '=', '1'],
                'options' => [
                    '2' => esc_html__('Two', 'atlets'),
                    '3' => esc_html__('Three', 'atlets'),
                    '4' => esc_html__('Four', 'atlets'),
                ],
                'default' => '3',
            ],
            [
                'id' => 'pf_number_r',
                'title' => esc_html__('Number of Related Items', 'atlets'),
                'type' => 'text',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => '3',
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'portfolio-advanced',
        'title' => esc_html__('Advanced', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_archives',
                'title' => esc_html__('Portfolio Archives', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'atlets'),
                'off' => esc_html__('Disabled', 'atlets'),
                'default' => true,
                'desc' => sprintf(
                    wp_kses(
                        __('Archive pages list all the portfolio posts you have created. This option will disable only the post\'s archive page(s). The post\'s single view will still be displayed. Note: you will need to <a href="%s">refresh your permalinks</a> after this option has been enabled.', 'atlets'),
                        [
                            'a' => ['href' => true, 'target' => true],
                        ]
                    ),
                    esc_url(admin_url('options-permalink.php'))
                ),
            ],
            [
                'id' => 'portfolio_singular',
                'title' => esc_html__('Portfolio Single', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'atlets'),
                'off' => esc_html__('Disabled', 'atlets'),
                'default' => true,
                'desc' => esc_html__('By default, all portfolio posts have single views enabled. This creates a specific URL on your website for that post. Selecting "Disabled" will prevent the single view post being publicly displayed.', 'atlets'),
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'team-option',
        'title' => esc_html__('Team', 'atlets'),
        'icon' => 'el el-user',
        'fields' => [
            [
                'id' => 'team_slug',
                'title' => esc_html__('Team Slug', 'atlets'),
                'type' => 'text',
                'default' => 'team',
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'team-single-option',
        'title' => esc_html__('Single', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'team_title_conditional',
                'title' => esc_html__('Page Title Text', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'atlets'),
                'off' => esc_html__('Post Title', 'atlets'),
                'default' => true,
            ],
            [
                'id' => 'team_single_page_title_bg_image',
                'title' => esc_html__('Single Page Title Background Image', 'atlets'),
                'type' => 'background',
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'team-advanced',
        'title' => esc_html__('Advanced', 'atlets'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'team_archives',
                'title' => esc_html__('Team Archives', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'atlets'),
                'off' => esc_html__('Disabled', 'atlets'),
                'default' => true,
                'desc' => sprintf(
                    wp_kses(
                        __('Archive pages list all the team posts you have created. This option will disable only the post\'s archive page(s). The post\'s single view will still be displayed. Note: you will need to <a href="%s">refresh your permalinks</a> after this option has been enabled.', 'atlets'),
                        [
                            'a' => ['href' => true, 'target' => true],
                        ]
                    ),
                    esc_url(admin_url('options-permalink.php'))
                ),
            ],
            [
                'id' => 'team_singular',
                'title' => esc_html__('Team Single', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'atlets'),
                'off' => esc_html__('Disabled', 'atlets'),
                'default' => true,
                'desc' => esc_html__('By default, all team posts have single views enabled. This creates a specific URL on your website for that post. Selecting "Disabled" will prevent the single view post being publicly displayed.', 'atlets'),
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'title' => esc_html__('Page 404', 'atlets'),
        'id' => '404-option',
        'icon' => 'el el-error',
        'fields' => [
            [
                'id' => '404_page_type',
                'title' => esc_html__('Layout Building Tool', 'atlets'),
                'type' => 'select',
                'desc' => esc_html__('Custom Template allows create templates within Elementor environment.', 'atlets'),
                'options' => [
                    'default' => esc_html__('Default', 'atlets'),
                    'custom' => esc_html__('Custom Template', 'atlets'),
                ],
                'default' => 'default',
            ],
            [
                'id' => '404_template_select',
                'type' => 'select',
                'title' => esc_html__('404 Template', 'atlets'),
                'required' => ['404_page_type', '=', 'custom'],
                'data' => 'posts',
                'desc' => sprintf(
                    '%s <a href="%s" target="_blank">%s</a> %s',
                    esc_html__('Selected Template will be used for 404 page by default. You can edit/create Template in the', 'atlets'),
                    admin_url('edit.php?post_type=elementor_library&tabs_group=library'),
                    esc_html__('Saved Templates', 'atlets'),
                    esc_html__('dashboard tab.', 'atlets')
                ),
                'args' => [
                    'post_type' => 'elementor_library',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => '404_show_header',
                'type' => 'switch',
                'title' => esc_html__('Header Section', 'atlets'),
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => '404_page_title_switcher',
                'title' => esc_html__('Page Title Section', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => '404_post_title-start',
                'type' => 'section',
                'required' => ['404_page_title_switcher', '=', true],
                'indent' => true,
            ],
            [
                'id' => '404_custom_title_switch',
                'title' => esc_html__('Page Title Text', 'atlets'),
                'type' => 'switch',
                'required' => ['404_page_title_switcher', '=', true],
                'on' => esc_html__('Custom', 'atlets'),
                'off' => esc_html__('Default', 'atlets'),
                'default' => false,
            ],
            [
                'id' => '404_page_title_text',
                'title' => esc_html__('Custom Page Title Text', 'atlets'),
                'type' => 'text',
                'required' => ['404_custom_title_switch', '=', true],
            ],
            [
                'id' => '404_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'atlets'),
                'type' => 'switch',
                'required' => ['404_page_title_switcher', '=', true],
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
            [
                'id' => '404_page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'atlets'),
                'type' => 'background',
                'required' => ['404_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
            [
                'id' => '404_page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'atlets'),
                'type' => 'spacing',
                'required' => ['404_title_bg_switch', '=', true],
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'bottom' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => '404_page_title_margin',
                'title' => esc_html__('Margin Bottom', 'atlets'),
                'type' => 'spacing',
                'required' => ['404_title_bg_switch', '=', true],
                'mode' => 'margin',
                'all' => false,
                'top' => false,
                'bottom' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => '404_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => '404_content-start',
                'title' => esc_html__('Content Section', 'atlets'),
                'type' => 'section',
                'required' => ['404_page_type', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => '404_page_main_bg_image',
                'title' => esc_html__('Section Background Image/Color', 'atlets'),
                'type' => 'background',
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'no-repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'right top',
                    'background-color' => '#ffffff',
                ],
            ],
            [
                'id' => '404_particles',
                'title' => esc_html__('Section Particles Animation', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
            ],
            [
                'id' => '404_content-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => '404_show_footer',
                'title' => esc_html__('Footer Section', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Hide', 'atlets'),
                'default' => true,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'side_panel',
        'title' => esc_html__('Side Panel', 'atlets'),
        'icon' => 'dashicons dashicons-menu-alt3',
        'fields' => [
            [
                'id' => 'side_panel_enable',
                'title' => esc_html__('Side Panel', 'atlets'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'atlets'),
                'off' => esc_html__('Disable', 'atlets'),
                'default' => false,
            ],
            [
                'id' => 'side_panel-start',
                'title' => esc_html__('Side Panel Settings', 'atlets'),
                'type' => 'section',
                'required' => ['side_panel_enable', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'side_panel_content_type',
                'title' => esc_html__('Content Type', 'atlets'),
                'type' => 'select',
                'options' => [
                    'widgets' => esc_html__('Get Widgets', 'atlets'),
                    'pages' => esc_html__('Get Pages', 'atlets'),
                ],
                'default' => 'pages',
            ],
            [
                'id' => 'side_panel_page_select',
                'title' => esc_html__('Page Select', 'atlets'),
                'type' => 'select',
                'required' => ['side_panel_content_type', '=', 'pages'],
                'data' => 'posts',
                'args' => [
                    'post_type' => 'side_panel',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'side_panel_spacing',
                'title' => esc_html__('Paddings', 'atlets'),
                'type' => 'spacing',
                'output' => ['#side-panel .side-panel_sidebar'],
                'mode' => 'padding',
                'units' => 'px',
                'all' => false,
                'default' => [
                    'padding-top' => '40px',
                    'padding-right' => '50px',
                    'padding-bottom' => '40px',
                    'padding-left' => '50px',
                ],
            ],
            [
                'id' => 'side_panel_title_color',
                'title' => esc_html__('Title Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['side_panel_content_type', '=', 'widgets'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'side_panel_text_color',
                'title' => esc_html__('Text Color', 'atlets'),
                'type' => 'color_rgba',
                'required' => ['side_panel_content_type', '=', 'widgets'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(204,204,204,1)',
                    'color' => '#cccccc',
                ],
            ],
            [
                'id' => 'side_panel_bg',
                'title' => esc_html__('Background', 'atlets'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'side_panel_text_alignment',
                'title' => esc_html__('Text Align', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'center' => esc_html__('Center', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'left',
            ],
            [
                'id' => 'side_panel_width',
                'title' => esc_html__('Width', 'atlets'),
                'type' => 'dimensions',
                'width' => true,
                'height' => false,
                'default' => ['width' => 375],
            ],
            [
                'id' => 'side_panel_position',
                'title' => esc_html__('Position', 'atlets'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'atlets'),
                    'right' => esc_html__('Right', 'atlets'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'side_panel-end',
                'type' => 'section',
                'required' => ['side_panel_enable', '=', '1'],
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'layout_options',
        'title' => esc_html__('Sidebars', 'atlets'),
        'icon' => 'fas fa-columns',
        'fields' => [
            [
                'id' => 'sidebars',
                'title' => esc_html__('Register Sidebars', 'atlets'),
                'type' => 'multi_text',
                'validate' => 'no_html',
                'add_text' => esc_html__('Add Sidebar', 'atlets'),
                'default' => ['Main Sidebar'],
            ],
            [
                'id' => 'sidebars-start',
                'title' => esc_html__('Sidebar Settings', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'page_sidebar_layout',
                'title' => esc_html__('Page Sidebar Layout', 'atlets'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'atlets'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'page_sidebar_def',
                'title' => esc_html__('Page Sidebar', 'atlets'),
                'type' => 'select',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'page_sidebar_def_width',
                'title' => esc_html__('Page Sidebar Width', 'atlets'),
                'type' => 'button_set',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => '25%',
                    '8' => '33%',
                ],
                'default' => '9',
            ],
            [
                'id' => 'page_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'atlets'),
                'type' => 'switch',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'page_sidebar_gap',
                'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                'type' => 'select',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'options' => [
                    'def' => esc_html__('Default', 'atlets'),
                    '0' => '0',
                    '15' => '15',
                    '20' => '20',
                    '25' => '25',
                    '30' => '30',
                    '35' => '35',
                    '40' => '40',
                    '45' => '45',
                    '50' => '50',
                ],
                'default' => 'def',
            ],
            [
                'id' => 'sidebars-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::setSection(
    $theme_slug,
    [
        'id' => 'page_marker',
        'title' => esc_html__('Page Marker', 'atlets'),
        'icon' => 'el el-share-alt',
        'fields' => [
            [
                'id' => 'show_page_marker',
                'type' => 'switch',
                'title' => esc_html__('Show Page Marker on Pages On/Off', 'atlets'),
                'default' => false
            ],
            [
                'id' => 'page_marker_offset',
                'title' => esc_html__('Offset Top', 'atlets'),
                'type' => 'spacing',
                'required' => ['show_page_marker', '=', '1'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => true,
                'left' => false,
                'right' => false,
                'desc' => esc_html__('Measurement units defined as "percents" while position fixed is enabled, and as "pixels" while position is off.', 'atlets'),
                'default' => ['margin-bottom' => '40%'],
            ],
            [
                'id' => 'add_marker_1',
                'title' => esc_html__('Add Marker 1', 'atlets'),
                'type' => 'switch',
                'required' => ['show_page_marker', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'marker_image_1',
                'title' => esc_html__('Marker Image 1', 'atlets'),
                'type' => 'media',
                'required' => ['add_marker_1', '=', '1'],
            ],
            [
                'id' => 'marker_title_1',
                'title' => esc_html__('Marker Title 1', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_1', '=', '1'],
            ],
            [
                'id' => 'marker_link_1',
                'title' => esc_html__('Marker Link 1', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_1', '=', '1'],
                'default' => '#',
            ],
            [
                'id' => 'add_marker_2',
                'title' => esc_html__('Add Marker 2', 'atlets'),
                'type' => 'switch',
                'required' => ['show_page_marker', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'marker_image_2',
                'title' => esc_html__('Marker Image 2', 'atlets'),
                'type' => 'media',
                'required' => ['add_marker_2', '=', '1'],
            ],
            [
                'id' => 'marker_title_2',
                'title' => esc_html__('Marker Title 2', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_2', '=', '1'],
            ],
            [
                'id' => 'marker_link_2',
                'title' => esc_html__('Marker Link 2', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_2', '=', '1'],
                'default' => '#',
            ],
            [
                'id' => 'add_marker_3',
                'title' => esc_html__('Add Marker 3', 'atlets'),
                'type' => 'switch',
                'required' => ['show_page_marker', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'marker_image_3',
                'title' => esc_html__('Marker Image 3', 'atlets'),
                'type' => 'media',
                'required' => ['add_marker_3', '=', '1'],
            ],
            [
                'id' => 'marker_title_3',
                'title' => esc_html__('Marker Title 3', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_3', '=', '1'],
            ],
            [
                'id' => 'marker_link_3',
                'title' => esc_html__('Marker Link 3', 'atlets'),
                'type' => 'text',
                'required' => ['add_marker_3', '=', '1'],
                'default' => '#',
            ],
            [
                'id' => 'add_marker_4',
                'title' => esc_html__('Add Marker 4', 'atlets'),
                'type' => 'switch',
                'required' => ['show_page_marker', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'marker_image_4',
                'title' => esc_html__('Marker Image 4', 'atlets'),
                'type' => 'media',
                'required' => ['add_marker_4', '=', '1'],
            ],
            [
                'id' => 'marker_title_4',
                'type' => 'text',
                'title' => esc_html__('Marker Title 4', 'atlets'),
                'required' => ['add_marker_4', '=', '1'],
            ],
            [
                'id' => 'marker_link_4',
                'type' => 'text',
                'title' => esc_html__('Marker Link 4', 'atlets'),
                'required' => ['add_marker_4', '=', '1'],
                'default' => '#',
            ],
            [
                'id' => 'add_marker_5',
                'type' => 'switch',
                'title' => esc_html__('Add Marker 5', 'atlets'),
                'default' => false,
                'required' => ['show_page_marker', '=', '1'],
            ],
            [
                'id' => 'marker_image_5',
                'type' => 'media',
                'title' => esc_html__('Marker Image 5', 'atlets'),
                'required' => ['add_marker_5', '=', '1'],
            ],
            [
                'id' => 'marker_title_5',
                'type' => 'text',
                'title' => esc_html__('Marker Title 5', 'atlets'),
                'required' => ['add_marker_5', '=', '1'],
            ],
            [
                'id' => 'marker_link_5',
                'type' => 'text',
                'title' => esc_html__('Marker Link 5', 'atlets'),
                'required' => ['add_marker_5', '=', '1'],
                'default' => '#',
            ],
            [
                'id' => 'add_marker_6',
                'type' => 'switch',
                'title' => esc_html__('Add Marker 6', 'atlets'),
                'default' => false,
                'required' => ['show_page_marker', '=', '1'],
            ],
            [
                'id' => 'marker_image_6',
                'type' => 'media',
                'title' => esc_html__('Marker Image 6', 'atlets'),
                'required' => ['add_marker_6', '=', '1'],
            ],
            [
                'id' => 'marker_title_6',
                'type' => 'text',
                'title' => esc_html__('Marker Title 6', 'atlets'),
                'required' => ['add_marker_6', '=', '1'],
            ],
            [
                'id' => 'marker_link_6',
                'type' => 'text',
                'title' => esc_html__('Marker Link 6', 'atlets'),
                'required' => ['add_marker_6', '=', '1'],
                'default' => '#'
            ]
        ]
    ]
);


Redux::setSection(
    $theme_slug,
    [
        'id' => 'color_options_color',
        'title' => esc_html__('Color Settings', 'atlets'),
        'icon' => 'el-icon-tint',
        'fields' => [
            [
                'id' => 'color_options_color-start',
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'theme-primary-color',
                'title' => esc_html__('Primary Theme Color', 'atlets'),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#ff7029',
            ],
            [
                'id' => 'theme-secondary-color',
                'title' => esc_html__('Secondary Theme Color', 'atlets'),
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#29B3B7',
            ],
            [
                'id' => 'theme-tertiary-color',
                'title' => esc_html__('Tertiary Theme Color', 'atlets'),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#00172b',
            ],
            [
                'id' => 'body-background-color',
                'title' => esc_html__('Body Background Color', 'atlets'),
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#ffffff',
            ],
            [
                'id' => 'color_options_color-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'button_options_color-start',
                'title' => esc_html__('Button Color Options', 'atlets'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'button-idle-color',
                'type' => 'color',
                'title' => esc_html__('Button Idle Color', 'atlets'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#ff6b22',
            ],
            [
                'id' => 'button-hover-color',
                'type' => 'color',
                'title' => esc_html__('Button Hover Color', 'atlets'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#29b3b7',
            ],
            [
                'id' => 'button_options_color-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

//* ↓ Typography Config
Redux::setSection(
    $theme_slug,
    [
        'id' => 'Typography',
        'title' => esc_html__('Typography', 'atlets'),
        'icon' => 'el-icon-font',
    ]
);

$typography = [];
$main_typography = [
    [
        'id' => 'main-font',
        'title' => esc_html__('Content Font', 'atlets'),
        'color' => true,
        'line-height' => true,
        'font-size' => true,
        'subsets' => false,
        'all_styles' => true,
        'font-weight-multi' => true,
        'defs' => [
            'font-size' => '16px',
            'line-height' => '30px',
            'color' => '#33393e',
            'font-family' => 'Nunito Sans',
            'font-weight' => '400',
            'font-weight-multi' => '500,600,700,800',
        ],
    ],
    [
        'id' => 'header-font',
        'title' => esc_html__('Headings Font', 'atlets'),
        'font-size' => false,
        'line-height' => false,
        'color' => true,
        'subsets' => false,
        'all_styles' => true,
        'font-weight-multi' => true,
        'defs' => [
            'google' => true,
            'color' => '#00172b',
            'font-family' => 'Livvic',
            'font-weight' => '700',
            'font-weight-multi' => '400,500,600'
        ],
    ],
    [
        'id' => 'additional-font',
        'title' => esc_html__('Additional Font', 'atlets'),
        'font-size' => false,
        'line-height' => false,
        'color' => true,
        'subsets' => false,
        'all_styles' => true,
        'font-weight-multi' => true,
        'defs' => [
            'google' => true,
            'color' => '#00172b',
            'font-family' => 'Caveat',
            'font-weight' => '700',
            'font-weight-multi' => '700',
        ],
    ]
];
foreach ($main_typography as $key => $value) {
    array_push($typography, [
        'id' => $value['id'],
        'type' => 'custom_typography',
        'title' => $value['title'],
        'color' => $value['color'] ?? '',
        'line-height' => $value['line-height'],
        'font-size' => $value['font-size'],
        'subsets' => $value['subsets'],
        'all_styles' => $value['all_styles'],
        'font-weight-multi' => $value['font-weight-multi'] ?? '',
        'subtitle' => $value['subtitle'] ?? '',
        'google' => true,
        'font-style' => true,
        'font-backup' => false,
        'text-align' => false,
        'default' => $value['defs'],
    ]);
}

Redux::setSection(
    $theme_slug,
    [
        'id' => 'main_typography',
        'title' => esc_html__('Main Content', 'atlets'),
        'subsection' => true,
        'fields' => $typography,
    ]
);

//* ↓ Menu Typography
$menu_typography = [
    [
        'id' => 'menu-font',
        'title' => esc_html__('Menu Font', 'atlets'),
        'color' => false,
        'line-height' => true,
        'font-size' => true,
        'subsets' => true,
        'defs' => [
            'google' => true,
            'font-family' => 'Livvic',
            'font-size' => '14px',
            'font-weight' => '600',
            'line-height' => '26px',
        ]
    ],
    [
        'id' => 'sub-menu-font',
        'title' => esc_html__('Submenu Font', 'atlets'),
        'color' => false,
        'line-height' => true,
        'font-size' => true,
        'subsets' => true,
        'defs' => [
            'google' => true,
            'font-family' => 'Livvic',
            'font-size' => '16px',
            'font-weight' => '600',
            'line-height' => '26px',
        ]
    ]
];
$menu_typography_array = [];
foreach ($menu_typography as $key => $value) {
    array_push($menu_typography_array, [
        'id' => $value['id'],
        'type' => 'custom_typography',
        'title' => $value['title'],
        'color' => $value['color'],
        'line-height' => $value['line-height'],
        'font-size' => $value['font-size'],
        'subsets' => $value['subsets'],
        'google' => true,
        'font-style' => true,
        'font-backup' => false,
        'text-align' => false,
        'all_styles' => false,
        'default' => $value['defs'],
    ]);
}

Redux::setSection(
    $theme_slug,
    [
        'id' => 'main_menu_typography',
        'title' => esc_html__('Menu', 'atlets'),
        'subsection' => true,
        'fields' => $menu_typography_array
    ]
);
//* ↑ menu typography

//* ↓ Headings Typography
$headings = [
    [
        'id' => 'header-h1',
        'title' => esc_html__('‹h1›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '48px',
            'line-height' => '60px',
            'font-weight' => '700',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h2',
        'title' => esc_html__('‹h2›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '40px',
            'line-height' => '60px',
            'font-weight' => '700',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h3',
        'title' => esc_html__('‹h3›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '36px',
            'line-height' => '50px',
            'font-weight' => '700',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h4',
        'title' => esc_html__('‹h4›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '30px',
            'line-height' => '40px',
            'font-weight' => '700',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h5',
        'title' => esc_html__('‹h5›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '24px',
            'line-height' => '38px',
            'font-weight' => '700',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h6',
        'title' => esc_html__('‹h6›', 'atlets'),
        'defs' => [
            'font-family' => 'Livvic',
            'font-size' => '18px',
            'line-height' => '32px',
            'font-weight' => '600',
            'text-transform' => 'none',
        ],
    ],
];
$headings_array = [];
foreach ($headings as $key => $heading) {
    array_push($headings_array, [
        'id' => $heading['id'],
        'type' => 'custom_typography',
        'title' => $heading['title'],
        'google' => true,
        'font-backup' => false,
        'font-size' => true,
        'line-height' => true,
        'color' => false,
        'word-spacing' => false,
        'letter-spacing' => true,
        'text-align' => false,
        'text-transform' => true,
        'default' => $heading['defs'],
    ]);
}

Redux::setSection(
    $theme_slug,
    [
        'id' => 'main_headings_typography',
        'title' => esc_html__('Headings', 'atlets'),
        'subsection' => true,
        'fields' => $headings_array
    ]
);

if (class_exists('WooCommerce')) {
    Redux::setSection(
        $theme_slug,
        [
            'id' => 'shop-option',
            'title' => esc_html__('Shop', 'atlets'),
            'icon' => 'el-icon-shopping-cart',
            'fields' => []
        ]
    );

    Redux::setSection(
        $theme_slug,
        [
            'id' => 'shop-catalog-option',
            'title' => esc_html__('Catalog', 'atlets'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_catalog_page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'atlets'),
                    'type' => 'background',
                    'required' => ['page_title_switch', '=', true],
                    'preview' => false,
                    'preview_media' => true,
                    'background-color' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ]
                ],
                [
                    'id' => 'shop_catalog_sidebar-start',
                    'title' => esc_html__('Sidebar Settings', 'atlets'),
                    'type' => 'section',
                    'indent' => true,
                ],
                [
                    'id' => 'shop_catalog_sidebar_layout',
                    'title' => esc_html__('Sidebar Layout', 'atlets'),
                    'type' => 'image_select',
                    'options' => [
                        'none' => [
                            'alt' => esc_html__('None', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                        ],
                        'left' => [
                            'alt' => esc_html__('Left', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                        ],
                        'right' => [
                            'alt' => esc_html__('Right', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                        ],
                    ],
                    'default' => 'left',
                ],
                [
                    'id' => 'shop_catalog_sidebar_def',
                    'title' => esc_html__('Shop Catalog Sidebar', 'atlets'),
                    'type' => 'select',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'data' => 'sidebars',
                ],
                [
                    'id' => 'shop_catalog_sidebar_def_width',
                    'title' => esc_html__('Shop Sidebar Width', 'atlets'),
                    'type' => 'button_set',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'options' => [
                        '9' => '25%',
                        '8' => '33%',
                    ],
                    'default' => '9',
                ],
                [
                    'id' => 'shop_catalog_sidebar_sticky',
                    'title' => esc_html__('Sticky Sidebar', 'atlets'),
                    'type' => 'switch',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'default' => false,
                ],
                [
                    'id' => 'shop_catalog_sidebar_gap',
                    'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                    'type' => 'select',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'options' => [
                        'def' => esc_html__('Default', 'atlets'),
                        '0' => '0',
                        '15' => '15',
                        '20' => '20',
                        '25' => '25',
                        '30' => '30',
                        '35' => '35',
                        '40' => '40',
                        '45' => '45',
                        '50' => '50',
                    ],
                    'default' => 'def',
                ],
                [
                    'id' => 'shop_catalog_sidebar-end',
                    'type' => 'section',
                    'indent' => false,
                ],
                [
                    'id' => 'shop_column',
                    'title' => esc_html__('Shop Column', 'atlets'),
                    'type' => 'button_set',
                    'options' => [
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4'
                    ],
                    'default' => '3',
                ],
                [
                    'id' => 'shop_products_per_page',
                    'title' => esc_html__('Products per page', 'atlets'),
                    'type' => 'spinner',
                    'min' => '1',
                    'max' => '100',
                    'step' => '1',
                    'default' => '12',
                ],
                [
                    'id' => 'use_animation_shop',
                    'title' => esc_html__('Use Animation Shop?', 'atlets'),
                    'type' => 'switch',
                    'default' => true,
                ],
                [
                    'id' => 'shop_catalog_animation_style',
                    'title' => esc_html__('Animation Style', 'atlets'),
                    'type' => 'select',
                    'required' => ['use_animation_shop', '=', true],
                    'select2' => ['allowClear' => false],
                    'options' => [
                        'fade-in' => esc_html__('Fade In', 'atlets'),
                        'slide-top' => esc_html__('Slide Top', 'atlets'),
                        'slide-bottom' => esc_html__('Slide Bottom', 'atlets'),
                        'slide-left' => esc_html__('Slide Left', 'atlets'),
                        'slide-right' => esc_html__('Slide Right', 'atlets'),
                        'zoom' => esc_html__('Zoom', 'atlets'),
                    ],
                    'default' => 'slide-left',
                ],
            ]
        ]
    );

    Redux::setSection(
        $theme_slug,
        [
            'id' => 'shop-single-option',
            'title' => esc_html__('Single', 'atlets'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_single_post_title-start',
                    'title' => esc_html__('Page Title Settings', 'atlets'),
                    'type' => 'section',
                    'required' => ['page_title_switch', '=', true],
                    'indent' => true,
                ],
                [
                    'id' => 'shop_title_conditional',
                    'title' => esc_html__('Page Title Text', 'atlets'),
                    'type' => 'switch',
                    'on' => esc_html__('Post Type Name', 'atlets'),
                    'off' => esc_html__('Post Title', 'atlets'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single_title_align',
                    'title' => esc_html__('Title Alignment', 'atlets'),
                    'type' => 'button_set',
                    'options' => [
                        'left' => esc_html__('Left', 'atlets'),
                        'center' => esc_html__('Center', 'atlets'),
                        'right' => esc_html__('Right', 'atlets'),
                    ],
                    'default' => 'center',
                ],
                [
                    'id' => 'shop_single_breadcrumbs_block_switch',
                    'title' => esc_html__('Breadcrumbs Display', 'atlets'),
                    'type' => 'switch',
                    'required' => ['page_title_breadcrumbs_switch', '=', true],
                    'on' => esc_html__('Block', 'atlets'),
                    'off' => esc_html__('Inline', 'atlets'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single_breadcrumbs_align',
                    'title' => esc_html__('Title Breadcrumbs Alignment', 'atlets'),
                    'type' => 'button_set',
                    'required' => [
                        ['page_title_breadcrumbs_switch', '=', true],
                        ['shop_single_breadcrumbs_block_switch', '=', true]
                    ],
                    'options' => [
                        'left' => esc_html__('Left', 'atlets'),
                        'center' => esc_html__('Center', 'atlets'),
                        'right' => esc_html__('Right', 'atlets'),
                    ],
                    'default' => 'center',
                ],
                [
                    'id' => 'shop_single_title_bg_switch',
                    'title' => esc_html__('Use Background Image/Color?', 'atlets'),
                    'type' => 'switch',
                    'on' => esc_html__('Use', 'atlets'),
                    'off' => esc_html__('Hide', 'atlets'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single_page_title_bg_image',
                    'title' => esc_html__('Background Image/Color', 'atlets'),
                    'type' => 'background',
                    'required' => ['shop_single_title_bg_switch', '=', true],
                    'preview' => false,
                    'preview_media' => true,
                    'background-color' => true,
                    'transparent' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
                [
                    'id' => 'shop_single_page_title_padding',
                    'title' => esc_html__('Paddings Top/Bottom', 'atlets'),
                    'type' => 'spacing',
                    'mode' => 'padding',
                    'all' => false,
                    'bottom' => true,
                    'top' => true,
                    'left' => false,
                    'right' => false,
                ],
                [
                    'id' => 'shop_single_page_title_margin',
                    'title' => esc_html__('Margin Bottom', 'atlets'),
                    'type' => 'spacing',
                    'mode' => 'margin',
                    'all' => false,
                    'bottom' => true,
                    'top' => false,
                    'left' => false,
                    'right' => false,
                    'default' => ['margin-bottom' => '47'],
                ],
                [
                    'id' => 'shop_single_page_title_border_switch',
                    'title' => esc_html__('Enable Border Top?', 'atlets'),
                    'type' => 'switch',
                    'default' => false,
                ],
                [
                    'id' => 'shop_single_page_title_border_color',
                    'title' => esc_html__('Border Top Color', 'atlets'),
                    'type' => 'color_rgba',
                    'required' => ['shop_single_page_title_border_switch', '=', true],
                    'default' => [
                        'color' => '#e5e5e5',
                        'alpha' => '1',
                        'rgba' => 'rgba(229,229,229,1)'
                    ],
                ],
                [
                    'id' => 'shop_single_post_title-end',
                    'type' => 'section',
                    'indent' => false,
                ],
                [
                    'id' => 'shop_single_sidebar-start',
                    'title' => esc_html__('Sidebar Settings', 'atlets'),
                    'type' => 'section',
                    'indent' => true,
                ],
                [
                    'id' => 'shop_single_sidebar_layout',
                    'title' => esc_html__('Sidebar Layout', 'atlets'),
                    'type' => 'image_select',
                    'options' => [
                        'none' => [
                            'alt' => esc_html__('None', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                        ],
                        'left' => [
                            'alt' => esc_html__('Left', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                        ],
                        'right' => [
                            'alt' => esc_html__('Right', 'atlets'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                        ],
                    ],
                    'default' => 'none',
                ],
                [
                    'id' => 'shop_single_sidebar_def',
                    'title' => esc_html__('Sidebar Template', 'atlets'),
                    'type' => 'select',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'data' => 'sidebars',
                ],
                [
                    'id' => 'shop_single_sidebar_def_width',
                    'title' => esc_html__('Sidebar Width', 'atlets'),
                    'type' => 'button_set',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'options' => [
                        '9' => '25%',
                        '8' => '33%',
                    ],
                    'default' => '9',
                ],
                [
                    'id' => 'shop_single_sidebar_sticky',
                    'title' => esc_html__('Sticky Sidebar', 'atlets'),
                    'type' => 'switch',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'default' => false,
                ],
                [
                    'id' => 'shop_single_sidebar_gap',
                    'title' => esc_html__('Sidebar Side Gap', 'atlets'),
                    'type' => 'select',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'options' => [
                        'def' => esc_html__('Default', 'atlets'),
                        '0' => '0',
                        '15' => '15',
                        '20' => '20',
                        '25' => '25',
                        '30' => '30',
                        '35' => '35',
                        '40' => '40',
                        '45' => '45',
                        '50' => '50',
                    ],
                    'default' => 'def',
                ],
                [
                    'id' => 'shop_single_sidebar-end',
                    'type' => 'section',
                    'indent' => false,
                ],
                [
                    'id' => 'shop_single_share',
                    'type' => 'switch',
                    'title' => esc_html__('Share On/Off', 'atlets'),
                    'default' => false,
                ]
            ]
        ]
    );

    Redux::setSection(
        $theme_slug,
        [
            'title' => esc_html__('Related', 'atlets'),
            'id' => 'shop-related-option',
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_related_columns',
                    'title' => esc_html__('Related products column', 'atlets'),
                    'type' => 'button_set',
                    'options' => [
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                    ],
                    'default' => '4',
                ],
                [
                    'id' => 'shop_r_products_per_page',
                    'title' => esc_html__('Related products per page', 'atlets'),
                    'type' => 'spinner',
                    'min' => '1',
                    'max' => '100',
                    'step' => '1',
                    'default' => '4',
                ],
            ]
        ]
    );

    Redux::setSection(
        $theme_slug,
        [
            'title' => esc_html__('Cart', 'atlets'),
            'id' => 'shop-cart-option',
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_cart_page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'atlets'),
                    'type' => 'background',
                    'required' => ['page_title_switch', '=', true],
                    'background-color' => false,
                    'preview_media' => true,
                    'preview' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
            ]
        ]
    );

    Redux::setSection(
        $theme_slug,
        [
            'id' => 'shop-checkout-option',
            'title' => esc_html__('Checkout', 'atlets'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_checkout_page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'atlets'),
                    'type' => 'background',
                    'background-color' => false,
                    'preview_media' => true,
                    'preview' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
            ]
        ]
    );
}

$advanced_fields = [
    [
        'id' => 'advanced_warning',
        'title' => esc_html__('Attention! This tab stores functionality that can harm site reliability.', 'atlets'),
        'type' => 'info',
        'desc' => esc_html__('Site troublefree operation is not ensured, if any of the following options is changed.', 'atlets'),
        'style' => 'critical',
        'icon' => 'el el-warning-sign',
    ],
    [
        'id' => 'advanced_divider',
        'type' => 'divide'
    ],
    [
        'id' => 'advanced-wp-start',
        'title' => esc_html__('WordPress', 'atlets'),
        'type' => 'section',
        'indent' => true,
    ],
    [
        'id' => 'disable_wp_gutenberg',
        'title' => esc_html__('Gutenberg Stylesheet', 'atlets'),
        'type' => 'switch',
        'desc' => esc_html__('Dequeue CSS files.', 'atlets') . atlets_quick_tip(
            strip_tags(__('Eliminates <code>wp-block-library-css</code> stylesheet. <br>Before disabling ensure that Gutenberg editor is not used anywhere throughout the site.', 'atlets'), '<code><br>')
        ),
        'on' => esc_html__('Dequeue', 'atlets'),
        'off' => esc_html__('Default', 'atlets'),
    ],
    [
        'id' => 'wordpress_widgets',
        'title' => esc_html__('WordPress Widgets', 'atlets'),
        'type' => 'switch',
        'on' => esc_html__('Classic', 'atlets'),
        'off' => esc_html__('Gutenberg', 'atlets'),
        'default' => true,
    ],
    [
        'id' => 'advanced-wp-end',
        'type' => 'section',
        'indent' => false,
    ],
];

if (class_exists('Elementor\Plugin')) {
    $advanced_elementor = [
        [
            'id' => 'advanced-elementor-start',
            'title' => esc_html__('Elementor', 'atlets'),
            'type' => 'section',
            'indent' => true,
        ],
        [
            'id' => 'disable_elementor_googlefonts',
            'title' => esc_html__('Google Fonts', 'atlets'),
            'type' => 'switch',
            'desc' => esc_html__('Dequeue font pack.', 'atlets') . atlets_quick_tip(sprintf(
                '%s <a href="%s" target="_blank">%s</a>%s',
                esc_html__('See: ', 'atlets'),
                esc_url('https://docs.elementor.com/article/286-speed-up-a-slow-site'),
                esc_html__('Optimizing a Slow Site w/ Elementor', 'atlets'),
                strip_tags(__('<br>Note: breaks all fonts selected within <code>Group_Control_Typography</code> (if any). Has no affect on <code>Theme Options->Typography</code> fonts.', 'atlets'), '<br><code>')
            )),
            'on' => esc_html__('Disable', 'atlets'),
            'off' => esc_html__('Default', 'atlets')
        ],
        [
            'id' => 'disable_elementor_fontawesome',
            'title' => esc_html__('Font Awesome Pack', 'atlets'),
            'type' => 'switch',
            'desc' => esc_html__('Dequeue icon pack.', 'atlets')
                . atlets_quick_tip(esc_html__('Note: Font Awesome is essential for Atlets Theme. Disable only if it already enqueued by some other plugin.', 'atlets')),
            'on' => esc_html__('Disable', 'atlets'),
            'off' => esc_html__('Default', 'atlets'),
        ],
        [
            'id' => 'advanced-elelemntor-end',
            'type' => 'section',
            'indent' => false,
        ],
    ];
    array_push($advanced_fields, ...$advanced_elementor);
}

if (class_exists('WooCommerce')) {

    $advanced_woo = [
        [
            'id' => 'advanced-woocommerce-start',
            'title' => esc_html__('WooCommerce', 'atlets'),
            'type' => 'section',
            'indent' => true,
        ],
        [
            'id' => 'disable_woocommerce_block',
            'title' => esc_html__('WooCommerce blocks', 'atlets'),
            'type' => 'switch',
            'desc' => esc_html__('Dequeue CSS files.', 'atlets') . atlets_quick_tip(
                strip_tags(__('Eliminates <code>wc-block-style</code> stylesheet.', 'atlets'), '<code><br>')
            ),
            'on' => esc_html__('Disable', 'atlets'),
            'off' => esc_html__('Default', 'atlets'),
        ],
        [
            'id' => 'advanced-woocommerce-end',
            'type' => 'section',
            'indent' => false,
        ],
    ];
    array_push($advanced_fields, ...$advanced_woo);
}

Redux::setSection(
    $theme_slug,
    [
        'id' => 'advanced',
        'title' => esc_html__('Advanced', 'atlets'),
        'icon' => 'el el-warning-sign',
        'fields' => $advanced_fields
    ]
);
