<?php

// Class Theme Helper
require_once get_theme_file_path('/core/class/theme-helper.php');

// Class Walker comments
require_once get_theme_file_path('/core/class/walker-comment.php');

// Class Walker Mega Menu
require_once get_theme_file_path('/core/class/walker-mega-menu.php');

// Class Theme Cats Meta
require_once get_theme_file_path('/core/class/theme-cat-meta.php');

// Class Single Post
require_once get_theme_file_path('/core/class/single-post.php');

// Class Tinymce
require_once get_theme_file_path('/core/class/tinymce-icon.php');

// Class Theme Autoload
require_once get_theme_file_path('/core/class/theme-autoload.php');

// Class Theme Dashboard
require_once get_theme_file_path('/core/class/theme-panel.php');

// Class Theme Verify
require_once get_theme_file_path('/core/class/theme-verify.php');

// Class Theme Elementor Pro Support
if (class_exists('\ElementorPro\Modules\ThemeBuilder\Module')) {
    require_once get_theme_file_path('/core/class/theme-elementor-pro-support.php');
}

function atlets_content_width()
{
    if (!isset($content_width)) {
        $content_width = 940;
    }
}
add_action('after_setup_theme', 'atlets_content_width', 0);


function atlets_theme_slug_setup()
{
    add_theme_support('title-tag');
}
add_action('after_setup_theme', 'atlets_theme_slug_setup');

add_action('init', 'atlets_page_init');
if (!function_exists('atlets_page_init')) {
    function atlets_page_init()
    {
        add_post_type_support('page', 'excerpt');
    }
}

if (!function_exists('atlets_main_menu')) {
    function atlets_main_menu($location = "")
    {
        wp_nav_menu([
            'theme_location'  => 'main_menu',
            'menu'  => $location,
            'container' => '',
            'container_class' => '',
            'after' => '',
            'link_before' => '<span>',
            'link_after' => '</span>',
            'walker' => new Atlets_Mega_Menu_Waker()
        ]);
    }
}

// Return all sidebars
if (!function_exists('atlets_get_all_sidebar')) {
    function atlets_get_all_sidebar()
    {
        global $wp_registered_sidebars;
        $out = [];

        if (empty($wp_registered_sidebars)) return;

        foreach ($wp_registered_sidebars as $sidebar_id => $sidebar) :
            $out[$sidebar_id] = $sidebar['name'];
        endforeach;

        return $out;
    }
}

if (!function_exists('atlets_get_custom_menu')) {
    function atlets_get_custom_menu()
    {
        $taxonomies = [];

        $menus = get_terms('nav_menu');
        foreach ($menus as $value) {
            $taxonomies[$value->name] = $value->name;
        }
        return $taxonomies;
    }
}

function atlets_get_attachment($attachment_id)
{
    $attachment = get_post($attachment_id);
    return [
        'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
        'caption' => $attachment->post_excerpt,
        'description' => $attachment->post_content,
        'href' => get_permalink($attachment->ID),
        'src' => $attachment->guid,
        'title' => $attachment->post_title
    ];
}

if (!function_exists('atlets_reorder_comment_fields')) {
    function atlets_reorder_comment_fields($fields)
    {
        $new_fields = [];

        $myorder = ['author', 'email', 'url', 'comment'];

        foreach ($myorder as $key) {
            $new_fields[$key] = isset($fields[$key]) ? $fields[$key] : "";
            unset($fields[$key]);
        }

        if ($fields) {
            foreach ($fields as $key => $val) {
                $new_fields[$key] = $val;
            }
        }

        return $new_fields;
    }
}
add_filter('comment_form_fields', 'atlets_reorder_comment_fields');


if (!function_exists('atlets_header_enable')) {
    function atlets_header_enable() {

        $header_switch = Atlets_Theme_Helper::get_option('header_switch');
        if(empty($header_switch)) return false;

        $id = !is_archive() ? get_queried_object_id() : 0;
        // Don't render header if in metabox set to hide it.
        if (
            class_exists('RWMB_Loader')
            && $id !== 0
            && rwmb_meta('mb_customize_header_layout') == 'hide'
        ) {
            return false;
        }

        //hide if 404 page
        $page_not_found = Atlets_Theme_Helper::get_option('404_show_header');
        if (is_404() && !(bool) $page_not_found) return;

        return true;
    }
}

add_filter('atlets/header/enable', 'atlets_header_enable');

if (!function_exists('atlets_page_title_enable')) {
    function atlets_page_title_enable()
    {
        $id = !is_archive() ? get_queried_object_id() : 0;

        $output['mb_page_title_switch'] = '';
        if (is_404()) {
            $output['page_title_switch'] = Atlets_Theme_Helper::get_option('404_page_title_switcher') ? 'on' : 'off';
        } else {
            $output['page_title_switch'] = Atlets_Theme_Helper::get_option('page_title_switch') ? 'on' : 'off';
            if (class_exists('RWMB_Loader') && $id !== 0) {
                $output['mb_page_title_switch'] = rwmb_meta('mb_page_title_switch');
            }
        }

        $output['single'] = ['type' => '', 'layout' => ''];

        /**
         * Check the Post Type
         *
         * Aimed to prevent Page Title rendering for the following pages:
         *	- blog single type 3;
         *
         * @since 1.0.0
         */
        if (
            get_post_type($id) == 'post'
            && is_single()
        ) {
            $output['single']['type'] = 'post';
            $output['single']['layout'] = Atlets_Theme_Helper::get_mb_option('single_type_layout', 'mb_post_layout_conditional', 'custom');
            if ($output['single']['layout'] === '3') {
                $output['page_title_switch'] = 'off';
            }
        }

        if (isset($output['mb_page_title_switch']) && $output['mb_page_title_switch'] == 'on') {
            $output['page_title_switch'] = 'on';
        }

        if (
            is_home()
            || is_front_page()
            || isset($output['mb_page_title_switch']) && $output['mb_page_title_switch'] == 'off'
        ) {
            $output['page_title_switch'] = 'off';
        }

        return $output;
    }
}

add_filter('atlets/page_title/enable', 'atlets_page_title_enable');

if (!function_exists('atlets_footer_enable')) {
    function atlets_footer_enable()
    {
        $output = [];
        $output['footer_switch'] = Atlets_Theme_Helper::get_option('footer_switch');
        $output['copyright_switch'] = Atlets_Theme_Helper::get_option('copyright_switch');

        if (class_exists('RWMB_Loader') && get_queried_object_id() !== 0) {
            $output['mb_footer_switch'] = rwmb_meta('mb_footer_switch');
            $output['mb_copyright_switch'] = rwmb_meta('mb_copyright_switch');

            if ($output['mb_footer_switch'] == 'on') {
                $output['footer_switch'] = true;
            } elseif ($output['mb_footer_switch'] == 'off') {
                $output['footer_switch'] = false;
            }

            if ($output['mb_copyright_switch'] == 'on') {
                $output['copyright_switch'] = true;
            } elseif ($output['mb_copyright_switch'] == 'off') {
                $output['copyright_switch'] = false;
            }
        }

        // Hide on 404 page
        $page_not_found = Atlets_Theme_Helper::get_option('404_show_footer');
        if (is_404() && !$page_not_found) $output['footer_switch'] = $output['copyright_switch'] = false;

        return $output;
    }
}

add_filter('atlets/footer/enable', 'atlets_footer_enable');

add_action('atlets/preloader', 'Atlets_Theme_Helper::preloader');

if (!function_exists('atlets_after_main_content')) {
    function atlets_after_main_content()
    {
        global $atlets_dynamic_css;

        $scroll_up = Atlets_Theme_Helper::get_option('scroll_up');
        $scroll_up_as_text = Atlets_Theme_Helper::get_option('scroll_up_appearance');
        $scroll_up_text = Atlets_Theme_Helper::get_option('scroll_up_text');

        if ($scroll_up) {
            echo '<div id="scroll_up" class="flaticon flaticon-arrow-right">',
                $scroll_up_as_text ? $scroll_up_text : '',
                '</div>';
        }

        $markers = Atlets_Theme_Helper::get_option('show_page_marker');
		if (class_exists( 'RWMB_Loader' ) && get_queried_object_id() !== 0) {

            if(rwmb_meta('mb_customize_markers') === 'on'){
                $markers = 1;
            }elseif(rwmb_meta('mb_customize_markers') === 'off'){
                $markers = 0;
            }
        }

		if( !empty($markers) &&  function_exists('wgl_theme_helper') ){
			echo wgl_theme_helper()->render_page_marker();
        }

        if (!empty($atlets_dynamic_css['style'])) {
            echo '<span id="atlets-footer-inline-css" class="dynamic_styles-footer" style="display: none;">',
                Atlets_Theme_Helper::render_html($atlets_dynamic_css['style']),
                '</span>';
        }
    }
}

add_action('atlets/after_main_content', 'atlets_after_main_content');

function atlets_mce_buttons_2($buttons)
{
    array_unshift($buttons, 'styleselect');
    return $buttons;
}
add_filter('mce_buttons_2', 'atlets_mce_buttons_2');


function atlets_tiny_mce_before_init($settings)
{
    $settings['theme_advanced_blockformats'] = 'p,h1,h2,h3,h4';
    $h_font_color = Atlets_Theme_Helper::get_option('header-font')['color'];
    $primary_color = Atlets_Theme_Helper::get_option('theme-primary-color');

    $style_formats = [
        [
            'title' => esc_html__('Dropcap', 'atlets'),
            'items' => [
                [
                    'title' => esc_html__('Primary Text Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'dropcap-bg primary',
                ], [
                    'title' => esc_html__('Primary Background Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'dropcap-bg primary alt',
                ], [
                    'title' => esc_html__('Secondary Text Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'dropcap-bg secondary',
                ], [
                    'title' => esc_html__('Secondary Background Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'dropcap-bg secondary alt',
                ],
            ],
        ],
        [
            'title' => esc_html__('Highlighter', 'atlets'),
            'items' => [
                [
                    'title' => esc_html__('Primary Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'highlighter primary',
                ], [
                    'title' => esc_html__('Secondary Color', 'atlets'),
                    'inline' => 'span',
                    'classes' => 'highlighter secondary',
                ],
            ],
        ],
        [
            'title' => esc_html__('Font Weight', 'atlets'),
            'items' => [
                [
                    'title' => esc_html__('Default', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => 'inherit'],
                ], [
                    'title' => esc_html__('Lightest (100)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '100'],
                ], [
                    'title' => esc_html__('Lighter (200)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '200'],
                ], [
                    'title' => esc_html__('Light (300)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '300'],
                ], [
                    'title' => esc_html__('Normal (400)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '400'],
                ], [
                    'title' => esc_html__('Medium (500)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '500'],
                ], [
                    'title' => esc_html__('Semi-Bold (600)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '600'],
                ], [
                    'title' => esc_html__('Bold (700)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '700'],
                ], [
                    'title' => esc_html__('Bolder (800)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '800'],
                ], [
                    'title' => esc_html__('Extra Bold (900)', 'atlets'),
                    'inline' => 'span',
                    'styles' => ['font-weight' => '900'],
                ],
            ]
        ],
	    [
		    'title' => esc_html__('Font Family', 'atlets'),
		    'items' => [
			    [
				    'title' => esc_html__('Content Font', 'atlets'),
				    'inline' => 'span',
				    'classes' => 'content-font',
			    ], [
				    'title' => esc_html__('Headings Font', 'atlets'),
				    'inline' => 'span',
				    'classes' => 'theme-header-font',
			    ], [
				    'title' => esc_html__('Additional Font', 'atlets'),
				    'inline' => 'span',
				    'classes' => 'additional-font',
			    ],
		    ]
	    ],
        [
            'title' => esc_html__('List Style', 'atlets'),
            'items' => [
                [
                    'title' => esc_html__('Dot', 'atlets'),
                    'selector' => 'ul',
                    'classes' => 'atlets_list atlets_dot',
                ], [
                    'title' => esc_html__('Check', 'atlets'),
                    'selector' => 'ul',
                    'classes' => 'atlets_list atlets_check',
                ], [
                    'title' => esc_html__('Check Primary Color', 'atlets'),
                    'selector' => 'ul',
                    'classes' => 'atlets_list atlets_check primary_color',
                ], [
                    'title' => esc_html__('Plus', 'atlets'),
                    'selector' => 'ul',
                    'classes' => 'atlets_list atlets_plus',
                ], [
                    'title' => esc_html__('Hyphen', 'atlets'),
                    'selector' => 'ul',
                    'classes' => 'atlets_list atlets_hyphen',
                ], [
		            'title' => esc_html__('Right Style', 'atlets'),
		            'selector' => 'ul.atlets_list',
		            'classes' => 'icon_right',
	            ], [
		            'title' => esc_html__('Disable Line - Lighter', 'atlets'),
		            'selector' => 'ul.atlets_list li',
		            'classes' => 'atlets_disable',
	            ], [
		            'title' => esc_html__('Disable Line - Darker', 'atlets'),
		            'selector' => 'ul.atlets_list li',
		            'classes' => 'atlets_disable_dark',
	            ], [
		            'title' => esc_html__('No List Style', 'atlets'),
		            'selector' => 'ul',
		            'classes' => 'no-list-style',
	            ],
            ]
        ],
    ];

    $settings['style_formats'] = str_replace('"', "'", json_encode($style_formats));
    $settings['extended_valid_elements'] = 'span[*],a[*],i[*]';
    return $settings;
}
add_filter('tiny_mce_before_init', 'atlets_tiny_mce_before_init');

function atlets_theme_add_editor_styles()
{
    add_editor_style('css/font-awesome-5.min.css');
}
add_action('current_screen', 'atlets_theme_add_editor_styles');

function atlets_categories_postcount_filter($variable)
{
    if (strpos($variable, '</a> (')) {
        $variable = str_replace('</a> (', '<span class="post_count">', $variable);
        $variable = str_replace('</a>&nbsp;(', '<span class="post_count">', $variable);
        $variable = str_replace(')', '</span></a>', $variable);
    } else {
        $variable = str_replace('</a> <span class="count">(', '<span class="post_count">', $variable);
        $variable = str_replace(')', '</span></a>', $variable);
    }

    $pattern1 = '/cat-item-\d+/';
    preg_match_all($pattern1, $variable, $matches);
    if (isset($matches[0])) {
        foreach ($matches[0] as $value) {
            $int = (int) str_replace('cat-item-', '', $value);
            $icon_image_id = get_term_meta($int, 'category-icon-image-id', true);
            if (!empty($icon_image_id)) {
                $icon_image = wp_get_attachment_image_src($icon_image_id, 'full');
                $icon_image_alt = get_post_meta($icon_image_id, '_wp_attachment_image_alt', true);
                $replacement = '$1<img class="cats_item-image" src="' . esc_url($icon_image[0]) . '" alt="' . (!empty($icon_image_alt) ? esc_attr($icon_image_alt) : "") . '"/>';
                $pattern = '/(cat-item-' . $int . '+.*?><a.*?>)/';
                $variable = preg_replace($pattern, $replacement, $variable);
            }
        }
    }

    return $variable;
}
add_filter('wp_list_categories', 'atlets_categories_postcount_filter');
add_filter('woocommerce_layered_nav_term_html', 'atlets_categories_postcount_filter');

function atlets_render_archive_widgets(
    $link_html,
    $url,
    $text,
    $format,
    $before,
    $after
) {
    $text = wptexturize($text);
    $url  = esc_url($url);

    if ('link' == $format) {
        $link_html = "\t<link rel='archives' title='" . esc_attr($text) . "' href='$url' />\n";
    } elseif ('option' == $format) {
        $link_html = "\t<option value='$url'>$before $text $after</option>\n";
    } elseif ('html' == $format) {

        $after = str_replace('(', '', $after);
        $after = str_replace(' ', '', $after);
        $after = str_replace('&nbsp;', '', $after);
        $after = str_replace(')', '', $after);

        $after = !empty($after) ? " <span class='post_count'>" . esc_html($after) . "</span> " : "";

        $link_html = "<li>" . esc_html($before) . "<a href='" . esc_url($url) . "'>" . esc_html($text) . $after . "</a></li>";
    } else { // custom
        $link_html = "\t$before<a href='$url'>$text</a>$after\n";
    }

    return $link_html;
}
add_filter('get_archives_link', 'atlets_render_archive_widgets', 10, 6);

// Add image size
if (function_exists('add_image_size')) {
    add_image_size('atlets-850-730', 850, 730, true);
}

// Woocommerce Init
if (class_exists('WooCommerce')) {
    require_once get_theme_file_path('/woocommerce/woocommerce-init.php');
}

add_filter('atlets/enqueue_shortcode_css', 'atlets_render_css');
function atlets_render_css($styles)
{
    global $atlets_dynamic_css;
    if (!isset($atlets_dynamic_css['style'])) {
        $atlets_dynamic_css = [];
        $atlets_dynamic_css['style'] = $styles;
    } else {
        $atlets_dynamic_css['style'] .= $styles;
    }
}

/* Add Custom Image Link field to media uploader for WGL Gallery module */
function attachment_custom_link_field($form_fields, $post)
{
    $form_fields['custom_image_link'] = array(
        'label' => esc_html__('Custom Image Link','atlets'),
        'input' => 'text',
        'value' => get_post_meta($post->ID, 'custom_image_link', true),
        'helps' => esc_html__('This option works only for the WGL Gallery module.','atlets'),
    );
    return $form_fields;
}
add_filter('attachment_fields_to_edit', 'attachment_custom_link_field', 10, 2);
/* Save values of Custom Image Link in media uploader */
function attachment_custom_link_field_save($post, $attachment)
{
    if (isset($attachment['custom_image_link']))
        update_post_meta($post['ID'], 'custom_image_link', $attachment['custom_image_link']);

    return $post;
}

add_filter('attachment_fields_to_save', 'attachment_custom_link_field_save', 10, 2);

/**
 * Add a pingback url auto-discovery for single posts, pages or attachments.
 */
function atlets_pingback_header()
{
    if (is_singular() && pings_open()) {
        echo '<link rel="pingback" href="', esc_url(get_bloginfo('pingback_url')), '">';
    }
}
add_action('wp_head', 'atlets_pingback_header');

add_filter( 'wpcf7_autop_or_not', '__return_false');
