<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Atlets
 * @since 1.0
 * @version 1.0
 */

get_header();

$sb = Atlets_Theme_Helper::render_sidebars();
$row_class = $sb['row_class'];
$column = $sb['column'];
$container_class = $sb['container_class'];

// Render
echo '<div class="wgl-container', apply_filters('atlets_container_class', $container_class), '">';
    echo '<div class="row', apply_filters('atlets_row_class', $row_class), '">';

        echo '<div id="main-content" class="wgl_col-', apply_filters('atlets_column_class', $column), '">';
            get_template_part('templates/post/posts-list');
            echo Atlets_Theme_Helper::pagination();
        echo '</div>';

        // Sidebar
        echo !empty($sb['content']) ? $sb['content'] : "";

    echo '</div>';
echo '</div>';

get_footer();
