<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage Atlets
 * @since 1.0
 * @version 1.0
 */

get_header();

$sb = Atlets_Theme_Helper::render_sidebars();
$container_class = $sb['container_class'];
$row_class = $sb['row_class'];
$column = $sb['column'];

?>
<div class="wgl-container<?php echo apply_filters('atlets_container_class', $container_class); ?>">
    <div class="row<?php echo apply_filters('atlets_row_class', $row_class); ?>">
        <div id='main-content' class="wgl_col-<?php echo apply_filters('atlets_column_class', $column); ?>">
            <?php
            if (have_posts()) : ?>
                <header class="searсh-header">
                    <h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'atlets' ), '<span>' .get_search_query(). '</span>' ); ?></h1>
                </header>
                <?php
                global $wgl_blog_atts;
                global $wp_query;
                $wgl_blog_atts = [
                    'query' => $wp_query,
                    'animation_class' => '',
                    // General
                    'blog_layout' => 'grid',
                    // Content
                    'blog_columns' => '12',
                    'hide_media' => false,
                    'hide_content' => false,
                    'hide_blog_title' => false,
                    'hide_postmeta' => false,
                    'meta_author' => false,
                    'meta_date' => false,
                    'meta_comments' => false,
                    'meta_categories' => true,
                    'hide_likes' => true,
                    'hide_share' => true,
                    'read_more_hide' => false,
                    'read_more_text' => esc_html__('Read More', 'atlets'),
                    'content_letter_count' => '85',
                    'crop_square_img' => 'true',
                    'heading_tag' => 'h3',
                    'items_load' => 4,
                    'heading_margin_bottom' => '16px',
                ];
                get_template_part('templates/post/posts-list');
                /* Start the Loop */
                echo Atlets_Theme_Helper::pagination();

            else :
                echo '<div class="page_404_wrapper">';
                    echo '<header class="searсh-header">',
                        '<h1 class="page-title">', esc_html__('Nothing Found', 'atlets'), '</h1>',
                    '</header>';

                    echo '<div class="page-content">';
                        if ( is_search() ) : ?>
                            <p class="banner_404_text"><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'atlets'); ?></p>
                            <?php
                        else : ?>
                            <p class="banner_404_text"><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'atlets'); ?></p>
                            <?php
                        endif;
                        ?>
                        <div class="search_result_form">
                            <?php get_search_form(); ?>
                        </div>
                        <div class="atlets_404__button">
                            <a class="wgl-button" href="<?php echo esc_url(home_url('/')); ?>">
                                <div class="button-content-wrapper">
                                <?php esc_html_e('Take Me Home', 'atlets'); ?>
                                </div>
                            </a>
                        </div>
                    </div>

                </div>
                <?php
            endif;
        echo '</div>';

        // Sidebar
        echo !empty($sb['content']) ? $sb['content'] : "";

    echo '</div>';
echo '</div>';

get_footer();
